package cn.com.duiba.order.center.api.paramquery;

import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;

/**
 * 订单售后问题查询入参
 *
 * @author ykb
 * @date 2023-02-16
 */
@Getter
@Setter
@NoArgsConstructor
public class OrderAfterSaleCreateParam implements Serializable{

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 兑吧订单号
     */
    private String orderNum;

    /**
     * 用户uid
     */
    private String uId;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String description;

    @Builder
    public OrderAfterSaleCreateParam(Long appId, String orderNum, String uId, Integer type, String description) {
        this.appId = appId;
        this.orderNum = orderNum;
        this.uId = uId;
        this.type = type;
        this.description = description;
    }
}
