/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.api.tool;

import cn.com.duiba.order.center.api.constant.OrderTypeEnum;
import cn.com.duiba.order.center.api.constant.StatusIntEnum;
import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class OrderUtils {
    public static final String GROUP_ID = "groupId";

    private OrderUtils() {
    }

    public static Boolean isNewOrder(OrdersDto order) {
        return Objects.isNull(order.getAppItemId()) && Objects.isNull(order.getItemId());
    }

    public static void setExtraJson(OrdersDto order, String jsonKey, Object jsonValue) {
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotBlank((String)order.getExtraInfo())) {
            jsonObject = JSONObject.parseObject((String)order.getExtraInfo());
        }
        jsonObject.put(jsonKey, jsonValue);
        order.setExtraInfo(jsonObject.toJSONString());
    }

    public static Long getGroupId(OrdersDto order) {
        if (StringUtils.isNotBlank((String)order.getExtraInfo())) {
            JSONObject jsonObject = JSONObject.parseObject((String)order.getExtraInfo());
            return jsonObject.getLong(GROUP_ID);
        }
        return null;
    }

    public static StatusIntEnum getStatus(OrdersDto dto, AmbSubOrdersDto subDto) {
        if (Objects.equals(dto.getRelationType(), 34) && "ConsumerPay-complete".equals(dto.getFlowworkStage())) {
            return StatusIntEnum.GROUP_BUYING;
        }
        if ("ConsumerPay-started".equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_PAY;
        }
        if ("Audit-started".equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_AUDIT;
        }
        if (OrderTypeEnum.OBJECT.getType().equals(dto.getType()) && "SupplierExchange-started".equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_SEND;
        }
        if ("Success-complete".equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.SUCCESS;
        }
        Integer statusInt = dto.getStatusInt();
        if (statusInt != null && statusInt >= StatusIntEnum.WAIT_PAY.getCode()) {
            if ("Fail-complete".equalsIgnoreCase(dto.getFlowworkStage())) {
                return StatusIntEnum.ofValue(statusInt);
            }
            if ("AfterSend-started".equalsIgnoreCase(dto.getFlowworkStage())) {
                return StatusIntEnum.ofValue(statusInt);
            }
        } else {
            if ("AfterSend-started".equalsIgnoreCase(dto.getFlowworkStage())) {
                if (Objects.nonNull(subDto) && Objects.equals("received", subDto.getShipStatus())) {
                    return StatusIntEnum.RECEIVE;
                }
                return StatusIntEnum.WAIT_RECEIVE;
            }
            if ("fail".equalsIgnoreCase(dto.getStatus()) || "Create-tofail".equalsIgnoreCase(dto.getFlowworkStage())) {
                return StatusIntEnum.FAIL;
            }
        }
        return StatusIntEnum.PROCESSING;
    }

    public static boolean isMallOrder(OrdersDto order) {
        return "mall".equals(order.getChargeMode()) || "api".equals(order.getChargeMode());
    }

    public static boolean isMallOrder(String chargeMode) {
        return "mall".equals(chargeMode) || "api".equals(chargeMode);
    }

    public static boolean isPurchaseOrder(OrdersDto ordersDto) {
        Long supplierId;
        JSONObject extra;
        boolean ret = false;
        if (ordersDto.getItemId() != null && StringUtils.isNotBlank((String)ordersDto.getExtraInfo()) && (extra = JSONObject.parseObject((String)ordersDto.getExtraInfo())) != null && (supplierId = extra.getLong("supplierId")) != null) {
            ret = true;
        }
        return ret;
    }

    public static boolean isProcessStatus(String postsaleStatus) {
        return "wait".equals(postsaleStatus) || "agree".equals(postsaleStatus) || "agreeNoGoods".equals(postsaleStatus) || "merchants_received".equals(postsaleStatus) || "refunding".equals(postsaleStatus);
    }

    public static boolean isProcessStatusWithoutRefunding(String postsaleStatus) {
        return "wait".equals(postsaleStatus) || "agree".equals(postsaleStatus) || "agreeNoGoods".equals(postsaleStatus) || "merchants_received".equals(postsaleStatus);
    }
}

