/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.api.constant;

import cn.com.duiba.order.center.api.constant.AmbPostSalesStatusEnum;
import cn.com.duiba.order.center.api.constant.AmbSubOrderStatusEnum;
import cn.com.duiba.order.center.api.constant.ConsumerPayEnum;
import cn.com.duiba.order.center.api.constant.OrderAuditStatusEnum;
import cn.com.duiba.order.center.api.constant.OrderStatusEnum;
import cn.com.duiba.order.center.api.constant.SupplierOrderStatus;
import cn.com.duiba.order.center.api.dto.AmbPostsaleOrdersDto;
import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.SupplierOrderDto;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public enum OrderStatus4ConsumerEnum {
    CREATE("\u521b\u5efa\u4e2d"),
    WAIT_PAY("\u5f85\u652f\u4ed8"),
    WAIT_AUDIT("\u5f85\u5ba1\u6838"),
    AUDIT_FAIL("\u5ba1\u6838\u5931\u8d25"),
    DEALING("\u5904\u7406\u4e2d"),
    WAIT_SHIP("\u5f85\u53d1\u8d27"),
    AFTER_SEND("\u5df2\u53d1\u8d27"),
    RECEIVED("\u5df2\u6536\u8d27"),
    WAIT_POST("\u552e\u540e\u5f85\u5904\u7406"),
    REJECT_REFUND("\u62d2\u7edd\u552e\u540e"),
    AGREE_REFUND("\u540c\u610f\u552e\u540e"),
    REFUNDING("\u9000\u6b3e\u4e2d"),
    SUCCESS("\u4ea4\u6613\u6210\u529f"),
    FAIL("\u4ea4\u6613\u5173\u95ed"),
    UNKNOWN("\u5904\u7406\u4e2d");

    private String desc;

    private OrderStatus4ConsumerEnum(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getCode() {
        return this.name().toLowerCase();
    }

    public boolean compareCode(String code) {
        return Objects.equals(code, this.getCode());
    }

    public static OrderStatus4ConsumerEnum getStatus(OrdersDto ordersDto, AmbPostsaleOrdersDto postOrdersDto, SupplierOrderDto supplierOrderDto, AmbSubOrdersDto ambSubOrdersDto) {
        if (OrderStatusEnum.StatusCreate.compareCode(ordersDto.getStatus())) {
            return CREATE;
        }
        if (ConsumerPayEnum.ConsumerPayStatusWaitPay.compareCode(ordersDto.getConsumerPayStatus())) {
            return WAIT_PAY;
        }
        if (OrderStatusEnum.StatusConsumeSuccess.compareCode(ordersDto.getStatus())) {
            OrderStatus4ConsumerEnum auditStatus = OrderStatus4ConsumerEnum.getAuditStatus(ordersDto);
            if (Objects.nonNull((Object)auditStatus)) {
                return auditStatus;
            }
            OrderStatus4ConsumerEnum shipStatus = OrderStatus4ConsumerEnum.getShipStatusBySupplierOrderDto(supplierOrderDto);
            if (Objects.nonNull((Object)shipStatus)) {
                return shipStatus;
            }
        }
        if (OrderStatusEnum.StatusAfterSend.compareCode(ordersDto.getStatus())) {
            if (OrderStatus4ConsumerEnum.isWaitShip(ambSubOrdersDto)) {
                return WAIT_SHIP;
            }
            OrderStatus4ConsumerEnum postStatus = OrderStatus4ConsumerEnum.getPostStatus(postOrdersDto);
            if (Objects.nonNull((Object)postStatus)) {
                return postStatus;
            }
            return OrderStatus4ConsumerEnum.getOrderStatus4ConsumerEnum(ambSubOrdersDto);
        }
        if (OrderStatusEnum.StatusSuccess.compareCode(ordersDto.getStatus())) {
            return SUCCESS;
        }
        if (OrderStatusEnum.StatusFAil.compareCode(ordersDto.getStatus())) {
            return FAIL;
        }
        return UNKNOWN;
    }

    private static OrderStatus4ConsumerEnum getOrderStatus4ConsumerEnum(AmbSubOrdersDto ambSubOrdersDto) {
        if (AmbSubOrderStatusEnum.Received.compareCode(ambSubOrdersDto.getShipStatus())) {
            return SUCCESS;
        }
        return AFTER_SEND;
    }

    @Nullable
    private static OrderStatus4ConsumerEnum getShipStatusBySupplierOrderDto(SupplierOrderDto supplierOrderDto) {
        if (Objects.nonNull(supplierOrderDto)) {
            if (SupplierOrderStatus.StatusCreate.compareCode(supplierOrderDto.getStatus())) {
                return DEALING;
            }
            if (SupplierOrderStatus.StatusSend.compareCode(supplierOrderDto.getStatus())) {
                return DEALING;
            }
            if (SupplierOrderStatus.StatusToDeliver.compareCode(supplierOrderDto.getStatus())) {
                return WAIT_SHIP;
            }
            if (SupplierOrderStatus.StatusSuccess.compareCode(supplierOrderDto.getStatus())) {
                return AFTER_SEND;
            }
        }
        return null;
    }

    @Nullable
    private static OrderStatus4ConsumerEnum getAuditStatus(OrdersDto ordersDto) {
        if (OrderAuditStatusEnum.wait.compareCode(ordersDto.getAuditStatus())) {
            return WAIT_AUDIT;
        }
        if (OrderAuditStatusEnum.reject.compareCode(ordersDto.getAuditStatus())) {
            return AUDIT_FAIL;
        }
        return null;
    }

    @Nullable
    private static OrderStatus4ConsumerEnum getPostStatus(AmbPostsaleOrdersDto postOrdersDto) {
        if (Objects.nonNull(postOrdersDto)) {
            String postsaleStatus = postOrdersDto.getPostsaleStatus();
            if (AmbPostSalesStatusEnum.POSTSALE_STATUS_WAIT.compareCode(postsaleStatus)) {
                return WAIT_POST;
            }
            if (AmbPostSalesStatusEnum.POSTSALE_STATUS_REFUNDING.compareCode(postsaleStatus)) {
                return REJECT_REFUND;
            }
            if (AmbPostSalesStatusEnum.POSTSALE_STATUS_AGREE.compareCode(postsaleStatus)) {
                return AGREE_REFUND;
            }
            if (AmbPostSalesStatusEnum.POSTSALE_STATUS_AGREE_NO_GOODS.compareCode(postsaleStatus)) {
                return AGREE_REFUND;
            }
            if (AmbPostSalesStatusEnum.POSTSALE_STATUS_REFUNDING.compareCode(postsaleStatus)) {
                return REFUNDING;
            }
        }
        return null;
    }

    private static boolean isWaitShip(AmbSubOrdersDto ambSubOrdersDto) {
        if (Objects.nonNull(ambSubOrdersDto)) {
            if (AmbSubOrderStatusEnum.WaitShip.compareCode(ambSubOrdersDto.getShipStatus())) {
                return true;
            }
            if (AmbSubOrderStatusEnum.Create.compareCode(ambSubOrdersDto.getShipStatus())) {
                return true;
            }
            if (AmbSubOrderStatusEnum.Canceled.compareCode(ambSubOrdersDto.getShipStatus())) {
                return true;
            }
        }
        return false;
    }

    public static OrderStatus4ConsumerEnum ofValue(String code) {
        for (OrderStatus4ConsumerEnum orderEnum : OrderStatus4ConsumerEnum.values()) {
            if (!Objects.equals(orderEnum.getCode(), code)) continue;
            return orderEnum;
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
    }
}

