/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.api.tool;

import cn.com.duiba.order.center.api.dto.OrderItemDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

public class OrderItemUtils {
    public static boolean isNewOrderItem(Long orderItemId) {
        return orderItemId > 10000000000L;
    }

    public static String getSuffix(Long orderItemId) {
        boolean isNew = OrderItemUtils.isNewOrderItem(orderItemId);
        if (!isNew) {
            throw new RuntimeException("\u8001\u8ba2\u5355\u4e0d\u652f\u6301");
        }
        long tbInt = orderItemId % 10000L;
        String tb = tbInt + "";
        if (tbInt < 10L) {
            tb = "000" + tbInt;
        } else if (tbInt < 100L) {
            tb = "00" + tbInt;
        } else if (tbInt < 1000L) {
            tb = "0" + tbInt;
        }
        return tb;
    }

    public static Long getDistributorsOrderSort(String bizParam) {
        if (StringUtils.isBlank((String)bizParam)) {
            return null;
        }
        JSONObject orderItemExtraInfo = JSON.parseObject((String)bizParam);
        if (orderItemExtraInfo == null) {
            return null;
        }
        Long orderSort = orderItemExtraInfo.getLong("distributorsSubOrderId");
        if (orderSort == null) {
            Long oldOrderSort = orderItemExtraInfo.getJSONArray("distributorsSubOrderIds") != null ? orderItemExtraInfo.getJSONArray("distributorsSubOrderIds").getLong(0) : null;
            orderSort = orderSort == null ? oldOrderSort : orderSort;
        }
        return orderSort;
    }

    public static Long getSupplierOrderSort(String bizParam) {
        if (StringUtils.isBlank((String)bizParam)) {
            return null;
        }
        JSONObject orderItemExtraInfo = JSON.parseObject((String)bizParam);
        if (orderItemExtraInfo == null) {
            return null;
        }
        Long orderSort = orderItemExtraInfo.getLong("supplierSubOrderId");
        if (orderSort == null) {
            Long oldOrderSort = orderItemExtraInfo.getJSONArray("supplierSubOrderIds") != null ? orderItemExtraInfo.getJSONArray("supplierSubOrderIds").getLong(0) : null;
            orderSort = orderSort == null ? oldOrderSort : orderSort;
        }
        return orderSort;
    }

    public static boolean isPurchaseOrder(OrderItemDto orderItemDto) {
        Long supplierId;
        JSONObject extra;
        boolean ret = false;
        if (orderItemDto.getItemId() != null && StringUtils.isNotBlank((String)orderItemDto.getBizParam()) && (extra = JSONObject.parseObject((String)orderItemDto.getBizParam())) != null && (supplierId = extra.getLong("supplierId")) != null) {
            ret = true;
        }
        return ret;
    }
}

