package cn.com.duiba.order.center.api.dto;


import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

/**
 * @author yansen
 */
public class ConsumerExchangeRecordDto implements Serializable{

    public static final int UNREAD = 1;//
	public static final int LUCKBAG = 2;
	public static final int TypeOrder = 1; // 普通的兑换订单而来
	public static final int TypeTurntable = 2; // 大转盘中奖订单而来
	public static final int TypeSingleLottery = 3;// 来源单品抽奖订单
	public static final int TypeManualLottery = 4;// 来源手动开奖订单
	public static final int TypeHdtoolLottery = 5;// 来源活动工具
	public static final int TypeGame = 6;// 来源游戏活动
	public static final int TypeQuestion = 7;// 来源答题活动
	public static final int TypeQuizz = 8;// 来源测试题
	public static final int TypeNgame = 10;// 来源新游戏
	public static final int TypeGameRecord = 9;//游戏记录
	public static final int TypeNgameRecord =11;//游戏记录
	public static final int TypeGuess = 12;// 来源新游戏
	public static final int TypeRob = 13;//来源今日必抢
	public static final int TypeLittleGame = 14;//来源小游戏
	public static final int TypeElasticGifts = 17;//来源弹层活动
	public static final int TypeSign = 18;//签到活动
	public static final int TypePluginLottery = 20;//插件活动
	public static final int TypeCreditGame = 21;//积分游戏
	public static final int TypeMaila = 22;//麦啦商品
	public static final int TYPE_HAPPY_CODE = 23;//开心码子订单
	public static final int TypeLuckyCode = 24; //幸运码
	public static final int TypeFreeGroup = 25; //0元拼团
	public static final int TypeHappyCodeNew = 26; //新版开心码活动
	public static final int TypeDigGold = 27;//挖金矿活动
	public static final int TypeCreditsFarm = 28;//积分农场活动
	public static final int TypeHaggle = 29;//砍价0元拿活动
	public static final int TypeCentscan = 30;//一分扫活动
	public static final int TypeUnderseaGame = 31;//海底游戏机
	public static final int TypeUnderstandLevel = 32;//默契测试活动
	public static final int TypeSuperSurprise = 33;//天降好礼
	public static final int TypeTaiLongTaskUnit = 34;//泰隆任务组件
	public static final int TypeGalaxy = 35;//活动平台
	public static final int TypeTuiALuckBug = 36;//推啊广告福袋

	public static final int EquityCard = 37;//权益卡工具


	/**
	 * 来自入库活动
	 * 拼接规则 入库活动id * 100 + ORIGIN_OPERATING_ACTIVITY;
	 */
	public static final int ORIGIN_OPERATING_ACTIVITY = 0;
	/**
	 * 来自插件活动
	 * 拼接规则 插件活动id * 100 + ORIGIN_PLUGIN_ACTIVITY;
	 */
	public static final int ORIGIN_PLUGIN_ACTIVITY = 1;
	/**
	 * 来自开心码赛事
	 * 拼接规则 开心码赛事id * 100 + ORIGIN_HAPPY_CODE;
	 */
	public static final int ORIGIN_HAPPY_CODE = 2;
	/**
	 * 来自集卡活动
	 * 拼接规则 集卡中奖规则id * 100 + ORIGIN_COLLECT_CARDS;
	 */
	public static final int ORIGIN_COLLECT_CARDS = 3;

	/**
	 * 拉新日历签到
	 */
	public static final int ORIGIN_SIGN_FOR_NEW = 4;

	/**
	 * 日历签到
	 */
	public static final int ORIGIN_SIGN = 5;
	
	
	/**
	 * 来自幸运码活动
	 * 拼接规则 幸运码配置id * 100 + ORGIN_LUCKY_CODE;
	 */
	public static final int ORGIN_LUCKY_CODE = 6;

	/**
	 * 0元拼团
	 */
	public static final int ORIGIN_FREE_GROUP = 7;

    /**
     * 新版夺宝码活动
     */
    public static final int ORIGIN_NEW_HAPPY_CODE = 8;

    /**
     * 夺宝签到活动
     */
    public static final int ORIGIN_SIGN_TREASURE = 9;

	/**
	 * 挖金矿
	 */
	public static final int ORIGIN_DIG_GOLD = 10;

	/**
	 * 砍价0元拿
	 */
	public static final int ORIGIN_HAGGLE = 11;

	/**
	 * 开发者商品
	 */
	public static final int ORIGIN_APP_ITEM = 12;

	/**
	 * 一分扫活动
	 */
	public static final int ORIGIN_CENTSCAN = 13;

	/**
	 * 海底游戏机
	 */
	public static final int ORIGIN_UNDERSEA_GAME = 14;

	/**
	 * 默契测试活动
	 */
	public static final int ORIGIN_UNDERSTAND_LEVEL = 15;

	/**
	 * 泰隆定制任务组件
	 * 任务记录id + * 100 + ORIGIN_TAILONG_TASK_UNIT;
	 */
	public static final int ORIGIN_TAILONG_TASK_UNIT = 16;

	/**
	 * 活动平台
 	 */
	public static final int ORIGIN_GALAXY = 17;

    private static final long serialVersionUID = 5369184460594831014L;

	private Long id;
	private Long consumerId;
	private Integer type;
	private Long orderId;
	private Long relationId;
	private Date gmtCreate;
	private Date gmtModified;
	private Long switchs;
	private String json;
	private Date overDue;
	private Long appId;
	/**
	 * 兑换记录来源
	 * 活动id + 来源类型
	 */
	private Long origin;

	private String tableName;
	/**
	 * 奖品名称
	 */
	private String  prizeName;
	/**
	 * 商品ID
	 */
	private Long    itemId;
	/**
	 * appitemId
	 */
	private Long   appItemId;

	/**
	 * 构造函数
	 */
	public ConsumerExchangeRecordDto() {
		super();
	}

	/**
	 *
	 * @param id
     */
	public ConsumerExchangeRecordDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	/**
	 *
	 * @param init4insert
     */
	public ConsumerExchangeRecordDto(boolean init4insert) {
		if (init4insert) {
			gmtCreate = new Date();
			gmtModified = gmtCreate;
			switchs = (long) 0;
			Calendar cal = Calendar.getInstance();
			cal.add(Calendar.YEAR, 100);
			overDue = cal.getTime();
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getRelationId() {
		return relationId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Long getSwitchs() {
		return switchs;
	}

	public void setSwitchs(Long switchs) {
		this.switchs = switchs;
	}

	/**
	 *
	 * @param type
	 * @return
     */
	public boolean getSwitchs(Integer type) {
		int v = 1 << type;
		long ret = switchs & v;
		return ret != 0;
	}

	/**
	 *
	 * @param type
     */
	public void disableSwitchs(Integer type) {
		int v = 1 << type;
		v = ~v;
		switchs = switchs & v;
	}

	/**
	 *
	 * @param type
     */
	public void enableSwitchs(Integer type) {
		int v = 1 << type;
		switchs = switchs | v;
	}

	public String getJson() {
		return json;
	}

	public void setJson(String json) {
		this.json = json;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public Date getOverDue() {
		return overDue;
	}

	public void setOverDue(Date overDue) {
		this.overDue = overDue;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getOrigin() {
		return origin;
	}

	public void setOrigin(Long origin) {
		this.origin = origin;
	}

	public String getPrizeName() {
		return prizeName;
	}

	public void setPrizeName(String prizeName) {
		this.prizeName = prizeName;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}
}
