package cn.com.duiba.order.center.api.paramquery;

import cn.com.duiba.order.center.api.annotation.EsCustomField;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;

/**
 * Created by yansen on 17/8/17.
 */
@Data
@Slf4j
public class OrdersAppSearchQuery  implements Serializable{

    private static final long serialVersionUID = -2471840020624126786L;


    public static final Integer appItemFilterOnlyDuibaItem = 2;
    public static final Integer appItemFilterOnlyAppItemSelf = 1;
    public static final Integer appItemFilterOnlyAll = 0;

    private Long appId;

    private Date startDate;

    private Date endDate;

    private Date finishStartTime;

    private Date finishEndTime;

    private String itemType;

    private String bizParams;

    private Long consumerId;

    private String orderType;

    private String orderId;

    private String namelike;

    private String exchangeStatus;

    private Integer offset=0;

    private Integer max=20;

    private String tableName;

    private Boolean activityOrder;

    private Boolean supplierOrder;
    //默认降序，升序传ASC
    private String  sortByGmtCreate;
    //默认降序，升序传ASC
    private String  sortByFinishTime;
    //订单来源，普兑给0，活动给1
    private String  relationType;
    //新版订单状态，待付款（100），待审核（200），待发货（300），待收货（400），已收货（500），已失效(700)，已取消(800)，已完成(900)，异常（1000），失败（1100，兼容老数据）
    private Integer  statusInt;

    //0 或者 null 全部搜索  1 只搜索自有商品 2 只搜索兑吧商品
    private Integer appItemFilterType;

    /**
     *  默认按照 创建时间
     *  创建时间 create、
     *  完成时间、 success
     */
    private String orderTimeType;

    //商品id列表
    private List<Long> itemIds;

    // app商品列表
    private List<Long> appItemIds;

    //商品id列表
    private String supplierIds;

    //es 扩展字段搜索 1
    private String customerSearchOne;

    //es 扩展字段搜索 2
    private String customerSearchTwo;

    //es 扩展字段搜索 3
    private String customerSearchThree;

    //es 扩展字段搜索 4
    private String customerSearchFour;


    /**
     * 根据提供的字段名和值，尝试设置对象的相应属性。
     * 需要确保外部提供的字段名与内部映射相符，否则将忽略或抛出异常。
     *
     * @param obj 外部字段名
     */
    public void extractAnnotatedFields(Object obj) throws IllegalAccessException {
        // 获取对象的所有字段
        Field[] fields = obj.getClass().getDeclaredFields();
        for (Field field : fields) {
            // 检查是否存在 QueryField 注解
            EsCustomField queryFieldAnnotation = field.getAnnotation(EsCustomField.class);
            if (queryFieldAnnotation != null) {
                // 确保私有字段也能访问
                field.setAccessible(true);

                // 提取注解的值（即底层字段名）以及字段值
                Object fieldValue = field.get(obj);
                // 使用BeanUtils来设置属性值，它内部处理了类型转换和异常
                try {
                    if(fieldValue!=null){
                        BeanUtils.setProperty(this, queryFieldAnnotation.value(), fieldValue);
                    }
                } catch (InvocationTargetException e) {
                    log.info("Failed to set value for field " + queryFieldAnnotation.value() + ": " + e.getMessage(),e);
                }
            }
        }

    }


}
