package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

/**
 * @author qianjue
 * @date 2018/12/11
 * @description: 订单主类型枚举
 */
public enum EsCustomFieldEnum {

    /**
     * 供应商标记
     */
    SUPPLIERIDS( "supplierIds"),
    CUSTOM_STRING_ONE( "customStringOne"),
    CUSTOM_STRING_TWO("customStringTwo"),
    CUSTOM_STRING_THREE( "customStringThree"),
    CUSTOM_STRING_FOUR("customStringFour"),
    ;



    private String fieldName;

    public String getFieldName() {
        return fieldName;
    }


    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    private EsCustomFieldEnum(String type){
        this.fieldName = type;
    }

    public static EsCustomFieldEnum ofValue(String type){
        for (EsCustomFieldEnum orderEnum:values()){
            if (Objects.equals(orderEnum.getFieldName(),type)){
                return orderEnum;
            }
        }
       return null;
    }
}
