package cn.com.duiba.order.center.api.paramquery;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by yansen on 17/8/17.
 */
@Data
public class OrdersAppSearchQuery  implements Serializable{

    private static final long serialVersionUID = -2471840020624126786L;


    public static final Integer appItemFilterOnlyDuibaItem = 2;
    public static final Integer appItemFilterOnlyAppItemSelf = 1;
    public static final Integer appItemFilterOnlyAll = 0;

    private Long appId;

    private Date startDate;

    private Date endDate;

    private Date finishStartTime;

    private Date finishEndTime;

    private String itemType;

    private String bizParams;

    private Long consumerId;

    private String orderType;

    private String orderId;

    private String namelike;

    private String exchangeStatus;

    private Integer offset=0;

    private Integer max=20;

    private String tableName;

    private Boolean activityOrder;

    private Boolean supplierOrder;
    //默认降序，升序传ASC
    private String  sortByGmtCreate;
    //默认降序，升序传ASC
    private String  sortByFinishTime;
    //订单来源，普兑给0，活动给1
    private String  relationType;
    //新版订单状态，待付款（100），待审核（200），待发货（300），待收货（400），已收货（500），已失效(700)，已取消(800)，已完成(900)，异常（1000），失败（1100，兼容老数据）
    private Integer  statusInt;

    //0 或者 null 全部搜索  1 只搜索自有商品 2 只搜索兑吧商品
    private Integer appItemFilterType;

    /**
     *  默认按照 创建时间
     *  创建时间 create、
     *  完成时间、 success
     */
    private String orderTimeType;

    //商品id列表
    private List<Long> itemIds;

    // app商品列表
    private List<Long> appItemIds;

    //商品id列表
    private String supplierIds;

    //es 扩展字段搜索 1
    private String customerSearchOne;

    //es 扩展字段搜索 2
    private String customerSearchTwo;

    //es 扩展字段搜索 3
    private String customerSearchThree;

    //es 扩展字段搜索 4
    private String customerSearchFour;





}
