package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.AmbOrderFastDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * 加钱购加速订单接口
 * Created by yansen on 16/9/26.
 */
@AdvancedFeignClient
public interface RemoteAmbOrderFastService {

    /**
     *
     * @param orderId
     * @param consumerId
     * @param orderGmtCreate
     * @return
     */
    public DubboResult<AmbOrderFastDto> createOrderFastWaitPay(Long orderId, Long consumerId, Date orderGmtCreate);

    /**
     *
     * @param orderId
     * @return
     */
    public DubboResult<Integer> deleteByOrderId(Long orderId);


    /**
     * 实物待支付记录，可以自定义支付截止时间，
     * 上游需要保证payEndTime 时间是在订单创建时间之后
     * @param orderId
     * @param consumerId
     * @param payEndTime  订单支付的截止时间
     * @return
     */
    AmbOrderFastDto createOrderFastWithPayEndTime(Long orderId, Long consumerId, Date payEndTime) throws BizException;

    /**
     * 推荐用createOrderFastWaitReceiveList
     * @param orderId
     * @param consumerId
     * @return
     */
    @Deprecated
    DubboResult<AmbOrderFastDto> createOrderFastWaitReceive(Long orderId, Long consumerId);

    Integer createOrderFastWaitReceiveList(Long orderId, Long consumerId, List<Long> orderItemIdList) throws BizException;

    /**
     * 按orderFastType查询当前过期加速订单
     * @param orderFastType
     * @return
     */
    DubboResult<List<AmbOrderFastDto>> findExpiredByType(String orderFastType);

    /**
     * 推荐用findByOrderIdAndTypeNew
     * @param orderId
     * @param status
     * @return
     */
    @Deprecated
    DubboResult<AmbOrderFastDto> findByOrderIdAndType(Long orderId, String status);

    AmbOrderFastDto findByOrderIdAndTypeNew(Long orderId, String status, Long ordersItemId) throws BizException;

    /**
     *
     * @param orderId
     * @param orderFastType
     * @return
     */
    @Deprecated
    public DubboResult<Integer> deleteByTypeAndOrderId(Long orderId, String orderFastType);

    Integer deleteByTypeAndOrderIdNew(Long orderId, String orderFastType, Long ordersItemId);

    /**
     * 查询售后订单中扫描时间最长一条的数据(排除max_time)
     * @param orderId
     * @return
     * @throws BizException
     */
    AmbOrderFastDto findByOrderIdAndMaxScan(Long orderId) throws BizException;

    /**
     * 自定义时间将订单置为成功，常用于aftersend订单
     * @param orderId
     * @param maxTime
     * @return
     */
    void createOrderFastMaxTimeByCustom(Long orderId, Date maxTime);


}
