package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

/**
 * @description: 商品来源
 */
public enum ItemSourceEnum {
    //兑吧
    DUIBA("duiba","兑吧"),
    //混合
    MIX("mix","混合"),
    //自有
    DLP("dlp","自有"),
    ;


    private String source;
    private String desc;

    public String getSource() {
        return source;
    }

    public String getDesc() {
        return desc;
    }

    public void setSource(String source) {
        this.source = source;
    }

    private ItemSourceEnum(String source, String desc){
        this.source = source;
        this.desc = desc;
    }

    public static ItemSourceEnum ofValue(String source){
        for (ItemSourceEnum item:values()){
            if (Objects.equals(item.getSource(),source)){
                return item;
            }
        }
       return null;
    }
}
