package cn.com.duiba.order.center.api.constant;

/**
 * @author: LuHui
 * @date: 2023/10/17 17:19
 * @description:
 */
public enum OrdersStatusEnum {
    AUDI_WAIT("audi_wait", "待审核"),
    AUDI_REFUSE("audi_refuse", "审核拒绝"),
    AUDI_PASS("audi_pass", "审核通过"),
    WAIT_SEND("wait_send", "待发货"),
    DELIVERY("delivery", "已发货待收货"),
    CREATE_AFTER_SALE("create_after_sale", "申请售后"),
    CANCEL_AFTER_SALE("cancel_after_sale", "取消售后"),
    SUCCESS_AFTER_SALE("success_after_sale", "售后成功"),
    REFUSE_AFTER_SALE("refuse_after_sale", "售后拒绝"),
    CONFIRM_RECEIVE("confirm_receive", "确认收货"),
    ORDER_FAIL("order_fail", "订单失败"),
    ORDER_SUCCESS("order_success", "订单成功"),
    ORDER_CANCEL("order_cancel", "取消订单"),

    ;

    private String status;

    private String desc;

    OrdersStatusEnum(String status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static OrdersStatusEnum getByStatus(String status) {
        for (OrdersStatusEnum ordersStatusEnum : OrdersStatusEnum.values()) {
            if (ordersStatusEnum.getStatus().equals(status)) {
                return ordersStatusEnum;
            }
        }
        return null;
    }

    public String getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }
}
