package cn.com.duiba.order.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName: OrderAssetDeductDto
 * @Description: 订单支付资产抵扣记录
 * @author: fxr
 * @date: 2018/9/14 下午4:18
 * @version: V1.0.0
 */
public class OrderAssetDeductDto implements Serializable {

    private static final long serialVersionUID = -6535421638567832510L;
    private Long id;
    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 用户ID
     */
    private Long consumerId;

    /**
     * 资产类型 1：钱包账户余额
     */
    private Integer assertType;

    /**
     * 抵扣金额，单位分
     */
    private Long deductMoney;

    /**
     * 状态  1：初始化  2：冻结中 3：扣减成功 4：扣减失败
     */
    private Integer deductStatus;

    /**
     * 关联的资产记录id
     */
    private String releationId;

    /**
     * 逻辑删除标识 1：是 0：否
     */
    private Integer isDeleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Integer getAssertType() {
        return assertType;
    }

    public void setAssertType(Integer assertType) {
        this.assertType = assertType;
    }

    public Long getDeductMoney() {
        return deductMoney;
    }

    public void setDeductMoney(Long deductMoney) {
        this.deductMoney = deductMoney;
    }

    public Integer getDeductStatus() {
        return deductStatus;
    }

    public void setDeductStatus(Integer deductStatus) {
        this.deductStatus = deductStatus;
    }

    public String getReleationId() {
        return releationId;
    }

    public void setReleationId(String releationId) {
        this.releationId = releationId;
    }

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
