package cn.com.duiba.order.center.api.dto.common;

import lombok.Data;

import java.io.Serializable;

public class PostSaleOrderDto implements Serializable {



    /**
     * 售后单ID
     */
    private Long postSaleOrderId;

    /**
     * 售后状态
     * 1、agreeNoGoods 同意售后、无需退款
     * 2、agree 同意售后、待寄回
     * 3、reject 售后拒绝
     * 4、canceled 售后取消
     * 5、success 售后完成
     */
    private String postSaleStatus;

    /**
     * 售后金额
     */
    private Long postSaleMoney;

    /**
     * 售后积分
     */
    private Long postSaleCredits;

    /**
     * 主订单ID
     */
    private Long orderId;

    /**
     * 子订单ID
     */
    private Long orderItemId;


    public Long getPostSaleOrderId() {
        return postSaleOrderId;
    }

    public void setPostSaleOrderId(Long postSaleOrderId) {
        this.postSaleOrderId = postSaleOrderId;
    }

    public String getPostSaleStatus() {
        return postSaleStatus;
    }

    public void setPostSaleStatus(String postSaleStatus) {
        this.postSaleStatus = postSaleStatus;
    }

    public Long getPostSaleMoney() {
        return postSaleMoney;
    }

    public void setPostSaleMoney(Long postSaleMoney) {
        this.postSaleMoney = postSaleMoney;
    }

    public Long getPostSaleCredits() {
        return postSaleCredits;
    }

    public void setPostSaleCredits(Long postSaleCredits) {
        this.postSaleCredits = postSaleCredits;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getOrderItemId() {
        return orderItemId;
    }

    public void setOrderItemId(Long orderItemId) {
        this.orderItemId = orderItemId;
    }
}
