package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.DevAbnormalOrderDto;
import cn.com.duiba.order.center.api.dto.OrderExportTotalDto;
import cn.com.duiba.order.center.api.dto.OrderFasterViewDto;
import cn.com.duiba.order.center.api.dto.OrdersFasterDto;
import cn.com.duiba.order.center.api.paramquery.AabnormalOrderQueryParams;
import cn.com.duiba.order.center.api.paramquery.AmbnormalOrderQuery;
import cn.com.duiba.order.center.api.paramquery.OrderFastShipNewQuery;
import cn.com.duiba.order.center.api.paramquery.OrdersAbnormalQuery;
import cn.com.duiba.order.center.api.paramquery.OrdersWaitQuery;
import cn.com.duiba.order.center.api.paramquery.WaitAuditQuery;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 17/3/29.
 */
@AdvancedFeignClient
public interface RemoteOrdersFasterReadService {
    /**
     *
     * @param appId
     * @param itemTitle
     * @param receiverTel
     * @param consumerId
     * @param orderNum
     * @param startDate
     * @param endDate
     * @param isDevOrder
     * @param isDuibaOrder
     * @return
     */
    public DubboResult<Long> findDevWaitOrderFastCount(Long appId, String itemTitle, String receiverTel, Long consumerId, String orderNum, Date
            startDate, Date endDate, String isDevOrder, String isDuibaOrder,Long developerSupplierId);

    @Deprecated
    DubboResult<Long> findVirtualAbnormalOrderCountByTime(Long appId, String orderNum, String supplierBizId, Long consumerId,
        Date timeout, Date startDate, Date endDate);


    /**
     * 查询开发者后台待发货数量
     * @param ordersWaitQuery
     * @return
     */
    Long countWaitOrders(OrdersWaitQuery ordersWaitQuery);
    /**
     *
     * @param paramMap
     * @return
     */
    DubboResult<Long> findAuditOrderFastCount(Map<String, Object> paramMap);

    /**
     *
     * @param appId
     * @return
     */
    DubboResult<Integer> getAuditOrdersCount(Long appId);

    /**
     * 后续使用
     * @param appId
     * @return
     */
    @Deprecated
    DubboResult<Long> getWaitOrdersCount(Long appId) ;

    /**
     * 总待发货订单数
     * @return
     */
    Long getWaitOrdersTotalCount();

    /**
     *
     * @param appId
     * @param startDay
     * @param endDay
     * @return
     */
    DubboResult<Integer> getProcessingOrdersCount(Long appId, Date startDay, Date endDay) ;

    /**
     * 已经冲载，不用map接受参数
     * @param paramMap
     * @return
     */
    @Deprecated
    DubboResult<List<OrderFasterViewDto>> findAuditOrderFast(Map<String,Object> paramMap);

    /**
     * 查询待审核的订单
     * @param query
     * @return
     */
    List<OrderFasterViewDto> selectAuditOrderFast(WaitAuditQuery query);

    /**
     * 查询待审核订单数量
     * @param query
     * @return
     */
    Long countAutditOrderFast(WaitAuditQuery query);

    /**
     *
     * @param ordersWaitQuery
     * @return
     */
    DubboResult<Map<String, Long>> getWaitRowAndMax(OrdersWaitQuery ordersWaitQuery);


    /**
     * 查询待发货订单总量和当前最大id（供批量查询功能使用）
     * @return
     */
    OrderExportTotalDto getWaitTotalInfo(OrdersWaitQuery ordersWaitQuery) throws BizException;

    /**
     *
     * @param ordersWaitQuery
     * @return
     */
    DubboResult<List<Long>> findWaitExportOrderIds(OrdersWaitQuery ordersWaitQuery);

    /**
     * 批量查询当前待发货订单ids
     * @return
     */
    List<Long> findCurWaitOrderIds(OrdersWaitQuery ordersWaitQuery)throws BizException;

    /**
     *
     * @param ordersWaitQuery
     * @return
     */
    DubboResult<List<OrderFasterViewDto>> findDevWaitOrderFast(OrdersWaitQuery ordersWaitQuery);


    Long findDevWaitOrderFastCountNew(OrdersWaitQuery ordersWaitQuery);

    @Deprecated
    DubboResult<List<DevAbnormalOrderDto>> findVirtualAbnormalOrderByTime(Long appId, String orderNum, String supplierBizId,
        Long consumerId, Date timeout, Integer offset, Integer max, Date startDate, Date endDate);

    List<DevAbnormalOrderDto> findCurrentAbnormalOrder(OrdersAbnormalQuery ordersAbnormalQuery) throws BizException;

    OrderExportTotalDto getAbnormalTotalInfo(OrdersAbnormalQuery ordersAbnormalQuery) throws BizException;

    /**
     *
     * @param appId
     * @param orderNum
     * @return
     */
    DubboResult<List<OrderFasterViewDto>> findDevWaitOrderFastByOrderNum(Long appId, String orderNum);

    /**
     *
     * @param appId
     * @param delayTime
     * @return
     */
    DubboResult<Integer> getVirtualAbnormalOrdersCount(Long appId, Date delayTime);

    /**
     * 虚拟商品异常订单总数
     * @param delayTime
     * @return
     */
    Integer getVirtualAbnormalOrdersTotalCount(Date delayTime);

    /**
     *
     * @param appId
     * @param orderNum
     * @param supplierBizId
     * @param consumerId
     * @param timeout
     * @return
     */
    public  DubboResult<Long> findVirtualAbnormalOrderCount(Long appId, String orderNum, String supplierBizId, Long consumerId, Date timeout);
    /**
     *
     * @param appId
     * @param orderNum
     * @param supplierBizId
     * @param consumerId
     * @param timeout
     * @param offset
     * @param max
     * @return
     */
    DubboResult<List<DevAbnormalOrderDto>> findVirtualAbnormalOrder(Long appId, String orderNum, String supplierBizId,
                                                       Long consumerId, Date timeout, Integer offset, Integer max);


    /**
     * 批量查询开发者
     * */
    List<OrderFasterViewDto> batchFindWaitOrdersByOrderNums(Long appId,List<String> orderNums);

    List<OrderFasterViewDto> selectAbnormalOrder(AmbnormalOrderQuery param);

    Integer countAbnormalOrder(AmbnormalOrderQuery param);

    /**
     * 兑吧管理端 待发货订单 分页查询
     */
    Page<OrderFasterViewDto> findOrderFastShipNewPage(OrderFastShipNewQuery param);

    /**
     * 兑吧管理端 待发货订单 按照导出条件进行分页查询 返回订单id集合
     */
    List<OrderFasterViewDto> findExportShipDuiBaOrderIdsAndExportSign(OrderFastShipNewQuery param);

    /**
     * 浙江中烟-定制待发货订单导出（填充JD地址）
     *
     * @param param 参数
     * @return {@link List<OrderFasterViewDto>}
     * @author fxr
     * @date 2020-4-24
     */
    List<OrderFasterViewDto> findZjzyExportShipDuiBaOrder(OrderFastShipNewQuery param);

    /**
     * 兑吧管理端 待发货订单 按照导出条件进行查询 返回最后一条数据的id
     */
    Long getShipDuiBaMax(OrderFastShipNewQuery param);

    /**
     * 兑吧管理端 待发货订单 按照导出条件进行查询 订单数量
     */
    Long getShipDuiBaCount(OrderFastShipNewQuery param);

    /**
     * 兑吧管理端,超时订单 分页查询
     * @param param
     * @return
     */
    public List<OrdersFasterDto> findTimeoutOrder(AabnormalOrderQueryParams param);

    /**
     * 兑吧管理端,超时订单 订单数量
     * @param param
     * @return
     */
    public Long getTimeOutRow(AabnormalOrderQueryParams param);

    public List<OrdersFasterDto> findSencodeKillOrder(AabnormalOrderQueryParams queryEntity);

    public Long findSencodeKillOrderCount(AabnormalOrderQueryParams queryEntity);


    /**
     * 批量查询待发货订单,包含兑吧、开发者
     */
    List<OrderFasterViewDto> batchFindWaitOrdersByOrderNum(List<String> orderNums);
}
