package cn.com.duiba.order.center.api.dto;

import cn.com.duiba.wolf.utils.MirrorEqualsUtils;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 主订单类
 */
@Data
public class OrdersDto implements Serializable {
    private static final long serialVersionUID = 12312L;
    public static final String StatusCreate = "create";
    public static final String StatusSuccess = "success";
    public static final String StatusFAil = "fail";
    public static final String StatusConsumeSuccess = "consume_success";
    public static final String StatusConsumeFail = "consume_fail";

    public static final String StatusWaitWriteOff = "wait_write_off";
    public static final String StatusNewRefunding = "newRefunding";


    public static final String StatusAfterSend = "after_send";

    public static final String FlowworkStageOrderCreateStart = "Create-started";


    public static final String AuditStatusNotNeed = null;
    public static final String AuditStatusWait = "wait";
    public static final String AuditStatusPass = "pass";
    public static final String AuditStatusReject = "reject";



    public static final String PayStatusPrereduce = "prereduce";// 预扣费
    public static final String PayStatusSuccess = "successs"; // 扣费成功，交易完成
    public static final String PayStatusPayback = "payback"; // 交易失败，费用已反冲
    public static final String PayStatusUnknowPay = "unknown_pay";  //未知的支付状态
    public static final String PayStatusWaitPay = "wait_pay";  //待付款
    public static final String PayStatusNone = "none";  //无须付款，或者无付款信息

    public static final String type_coupon = "coupon";  //无须付款，或者无付款信息


    public static final String ChargeModeMall = "mall";
    public static final String ChargeModeApi = "api";
    public static final String ChargeModeTurntable = "turntable";// 来自大转盘订单
    public static final String ChargeModeSingleLottery = "singlelottery"; //来自单品抽奖
    public static final String ChargeModeManualLottery = "manuallottery";//手工开奖
    public static final String ChargeModeHdtool = "hdtool"; //活动工具
    public static final String ChargeModeGame = "game"; //游戏活动
    public static final String ChargeModeQuestion = "question"; //答题活动
    public static final String ChargeModeQuizz = "quizz";//测试题活动
    public static final String ChargeModeSeckill = "seckill"; //秒杀活动
    public static final String ChargeModeNgame = "ngame"; //游戏活动
    public static final String ChargeModeGuess = "guess"; //游戏活动
    public static final String ChargeModeActivity = "activity";//新活动，今日必抢等等
    public static final String CHARGE_MODE_HAPPY_CODE = "happyCode";//开心码
    public static final String ChargeModeLuckyCode = "luckyCode";//幸运码
    public static final String ChargeModeHappyCodeNew = "happyCodeNew";//新版开心码活动
    public static final String ChargeModeFreeGroup = "freeGroup";//0元拼团
    public static final String ChargeModeCreditsFarm = "creditsFarm";//积分农场
    public static final String ChargeModeCentscan = "centscan";//一分扫活动

    /**
     * project-x
     */
    public static final String ChargeModeProjectX = "project-x";
    public static final String ChargeModeDigGold = "digGold";//挖金矿
    public static final String ChargeModeHaggle = "haggle";//砍价0元拿
    public static final String ChargeModeUnderseaGame = "underseaGame";//海底游戏机
    public static final String ChargeModeUnderstandLevel = "understandLevel";//默契测试活动
    public static final String ChargeModeSuperSurprise = "superSurprise";//天降好礼
    public static final String ChargeModeTaiLongTaskUnit = "taiLongTaskUnit";//泰隆任务组件


    public static final int NotifyStatusSuccess = 999;// 通知成功
    public static final int MaxNotifyTimes = 5;// 最大通知次数

    public static final int FailTypeSupplier = 1;// 上游兑换失败
    public static final int FailTypeDeveloperServerErr = 2;// 开发者服务器异常
    public static final int FailTypeDeveloperFeedback = 3;// 开发者反馈失败：扣积分失败 积分不足等
    public static final int FailTypeAuditReject = 4;// 审核拒绝
    public static final int FailTypeSupplierFeedback = 5;// 供应商采购失败
    //农总行定制-用户取消订单
    public static final int FailTypeUserCancel = 6;

    public static final int RelationTypeDefault = 0; // 普通订单
    public static final int RelationTypeActivity = 1; // 专题活动订单
    public static final int RelationTypeSingleLottery = 2; // 单品抽奖
    public static final int RelationTypeTurntable = 3;// 大转盘订单
    public static final int RelationTypeManualLottery = 4;//手动开奖
    public static final int RelationTypeHdtool = 5;//活动工具
    public static final int RelationTypeGame = 6;//游戏活动
    public static final int RelationTypeSecondsKill = 7;//秒杀专题
    public static final int RelationTypeQuestion = 8;//答题活动
    public static final int RelationTypeQuizz = 10;//测试题活动
    public static final int RelationTypeSeckill = 9;//秒杀活动
    public static final int RelationTypeNgame = 11;//新游戏
    public static final int RelationTypeGuess = 12;//竞猜活动
    public static final int RelationTypeRob = 13;//今日必抢
    public static final int RelationTypeCreditGame = 14; //积分游戏
    public static final int RelationTypeLittleGame = 15; //小游戏
    public static final int RelationTypePlugin = 16;//插件活动
    public static final int RelationTypeElasticGifts = 17;//弹层活动
    public static final int RelationTypeSign = 18;//签到活动
    public static final int RelationTypeMailaRob=19;//麦啦今日必抢
    public static final int RELATION_TYPE_HAPPY_CODE = 20;//开心码
    public static final int RelationTypeLuckyCode = 21;//幸运码
    public static final int RelationTypeFreeGroup = 22;//0元拼团
    public static final int RELATION_TYPE_HAPPY_CODE_NEW = 23;//新版开心码
    public static final int RELATION_TYPE_VIP_GOODS=24; //会员商品
    public static final int RelationTypeDigGold = 25; //挖金矿
    /**
     * project-x
     */
    public static final int RELATION_TYPE_PROJECT_X = 26;
    public static final int RelationTypeCreditsFarm = 27; //积分农场
    public static final int RelationTypeCentscan = 28; //一分扫
    public static final int RelationTypeHaggle = 29; //砍价0元拿
    public static final int RelationTypeUnderseaGame = 30; //海底游戏机
    public static final int RelationTypeUnderstandLevel = 31; //默契测试活动

    public static final int RelationTypeOrderGivingAct = 32; // 订单满赠活动
    public static final int RelationTypeOrderBonus = 33; // 订单赠品
    public static final int RelationTypeGroupBuy = 34; // 拼团活动
    public static final int RelationTypeMerchants = 55; // 商户权益订单
    public static final int RelationTypeSuperSurprise = 60; //天降好礼
    public static final int RelationTypeTaiLongTaskUnit = 61; //泰隆任务组件

    public static final int RelationTypeEquityCard = 62; //权益卡工具

    public static final String DuibaPayStatusNone = "none";//没有支付需求
    public static final String DuibaPayStatusPrereduce = "prereduce";// 预扣费
    public static final String DuibaPayStatusSuccess = "success"; // 扣费成功，交易完成
    public static final String DuibaPayStatusPayback = "payback"; // 交易失败，费用已反冲
    public static final String DuibaPayStatusUnknowPay = "unknown_pay";  //未知的支付状态
    public static final String DuibaPayStatusWaitPay = "wait_pay";  //待付款

    //none | wait_pay | pay_success | pay_back | canceled | success
    public static final String ConsumerPayStatusNone = "none";
    public static final String ConsumerPayStatusWaitPay = "wait_pay";
    public static final String ConsumerPayStatusPaySuccess = "pay_success";
    public static final String ConsumerPayStatusPayBack = "pay_back";
    public static final String ConsumerPayStatusCanceled = "canceled";
    public static final String ConsumerPayStatusSuccess = "success";
    public static final String ConsumerPayStatusCreditsPayBack = "credits_pay_back";

    /**
     * 加钱购
     */
    public static final String SubOrderTypeAmb = "amb";
    /**
     * 活动工具
     */
    public static final String SubOrderTypeHdtool = "hdtool";
    /**
     * 插件
     */
    public static final String SubOrderTypePlugin = "plugin";
    /**
     * 游戏
     */
    public static final String SubOrderTypeNgame = "ngame";
    /**
     * 签到
     */
    public static final String SubOrderTypeSign = "sign";
    /**
     * 单品抽奖
     */
    public static final String SubOrderTypeSinglelottery = "singlelottery";
    /**
     * 开心码
     */
    public static final String SubOrderTypeHappyCode = "happycode";
    /**
     * 新版开心码
     */
    public static final String SubOrderTypeHappyCodeNew = "happycodenew";
    /**
     * 手动开奖
     */
    public static final String SubOrderTypeManuallottery = "manuallottery";
    /**
     * 答题
     */
    public static final String SubOrderTypeQuestion = "question";
    /**
     * 测试题
     */
    public static final String SubOrderTypeQuizz = "quizz";
    /**
     * 竞猜
     */
    public static final String SubOrderTypeGuess = "guess";

    /**
     * 幸运码
     */
    public static final String SubOrderTypeLuckyCode = "luckyCode";

    /**
     * 幸运码
     */
    public static final String SubOrderTypeFreeGroup = "freeGroup";
    /**
     * project-x
     */
    public static final String SubOrderTypeProjectX = "project-x";

    /**
     * 挖金矿
     */
    public static final String SubOrderTypeDigGold = "digGold";
    /**
     * 积分农场
     */
    public static final String SubOrderTypeCreditsFarm = "creditsFarm";

    /**
     * 砍价0元拿
     */
    public static final String SubOrderTypeHaggle = "haggle";

    /**
     * 一分扫活动
     */
    public static final String SubOrderTypeCentscan = "centscan";

    /**
     * 海底游戏机
     */
    public static final String SubOrderTypeUnderseaGame = "underseaGame";

    /**
     * 默契测试活动
     */
    public static final String SubOrderTypeUnderstandLevel = "understandLevel";

    /**
     * 天降好礼
     */
    public static final String SubOrderTypeSuperSurprise = "superSurprise";

    /** 泰隆任务组件 */
    public static final String SubOrderTypeTaiLongTaskUnit = "taiLongTaskUnit";


    /**
     * 权益包工具
     */
    public static final String SubOrderTypeEquityCardUnit = "equityCarUnit";


    public static final Integer try_again_count = 1;

    public static final Integer try_again_interval_time = 50;

    public static final String SUB_ORDER_TYPE = "amb";    // 子订单为加钱购

    public static final String MOBIKE_CREDITS="bizCredits";

    public static final String IS_RESTORE_BUGDET="isRestoreBudget";

    //订单Extra字段的jsonKey 拼团活动团id
    public static final String GROUP_ID = "groupId";
    //订单Extra字段的jsonKey 购物车商品来源，兑吧 duiba  混合mix 自有 dlp
    public static final String ITEM_SOURCE = "itemSource";
    //订单Extra字段的jsonKey 供应商父订单号
    public static final String SUPPLIER_PARENT_ORDER_ID = "SPOrderId";
    //订单Extra字段的jsonKey 分销商父订单号
    public static final String DISTRIBUTORS_PARENT_ORDER_ID = "DPOrderId";
    //订单Extra字段的jsonKey 分账id
    public static final String SUB_ACCOUNT_ID = "subAccountId";
    //订单Extra字段的jsonKey 蜜雪冰城物流同步信息
    public static final String LOGISTICS_SYNC_INFO = "logisticsSyncInfo";
    // 订单Extra字段的jsonKey 发起支付时的访问渠道
    public static final String PAY_VISIT_CHANNEL = "pay_visit_channel";

    // 订单Extra字段的jsonKey 权益包工具活动id
    public static final String EQUITY_CARD_ACT_ID = "equityCardActId";
    // 订单Extra字段的jsonKey 权益包工具活动商品归属权益包id
    public static final String EQUITY_CARD_PACKAGE_ID = "equityCardPackageId";

    // 订单Extra字段的jsonKey 权益包工具活动配置id
    public static final String EQUITY_CARD_CONFIG_ID = "equityCardConfigId";

    // 订单Extra字段的jsonKey 权益包工具活动商品归属权益包奖品主键id
    public static final String EQUITY_CARD_PACKAGE_PRIZE_ID = "equityCardPackagePrizeId";
    // 订单Extra字段的jsonKey 权益包工具活动 开通权益月卡记录id
    public static final String EQUITY_CARD_PAY_RECORD_ID = "payRecordId";
    // 订单Extra字段的jsonKey 权益包工具活动 权益包类型(商品类型)
    public static final String EQUITY_CARD_ITEM_TYPE = "equityCardItemType";

    /**
     * 门店ID
     */
    public static final String MM_STORE_ID = "storeId";
    /**
     * 门店编码
     */
    public static final String MM_STORE_CODE = "storeCode";


    private Long id;
    private String orderNum;// 订单号
    private Long developerId;
    private Long appId;
    private Long consumerId;
    private Long itemId;
    private Long appItemId;
    private Long couponId;
    private String type;// qb phonebill coupon
    /**
     * 使用GoodsTypeEnum的gtype类型常量
     */
    private Integer typeInt;
    private Integer facePrice;
    private Integer actualPrice;
    private Long credits;// 消耗的积分数
    private Integer quantity;
    private String bizParams; // 业务参数，比如qq号码

    private String status;// 处理中 成功 失败
    private String errorMessage;
    private String failReason; // 失败原因，主要是给用户看的

    private String error4Consumer;// 给用户的出错提示
    private String error4Developer; // 给开发者的出错提示
    private String error4Admin;// 给兑吧管理员的出错提示

    private String payStatus;// 预扣费 扣费成功 已反冲
    private String auditStatus;

    private Boolean allowInputAgain; // 是否允许用户再次填写，重新兑换
    private String allowInputTips; // 允许用户再次填写时，给用户的提示语

    private Date auditTime; // 审核时间

    private String developerBizId; // 开发者的业务id

    private Long supplierOrderId;

    private Date finishTime;// 订单结束时间

    private String chargeMode;// 充值模式 api mall 默认mall
    private String brief;

    private String ip;
    private Integer notify;// 通知状态 null 1-通知次数

    private Date lastSendTime;// 上游请求发送时间
    private Integer failType; // 失败类型 0-成功 1-上游失败 2-开发者服务器异常 3-开发者反馈失败 4审核拒绝

    private Long relationId;// 关联对象id，如果ChargeMode=turntable，则此为大转盘订单id
    private Integer relationType;

    private Date gmtCreate;
    private Date gmtModified;

    private Integer duibaActualPrice;
    private String duibaPayStatus;

    private Long subOrderId;// 子订单ID
    private String subOrderType;// 子订单类型 amb:加钱购
    private String consumerPayStatus;// 用户付款状态 none | wait_pay | pay_success |
    // pay_back | canceled | success
    private Long consumerPayPrice;// 用户支付金额
    private Long consumerPayBackPrice;//

    private String flowworkStage;
    
    private Integer statusInt;  
    private Integer auditStatusInt;
    private Integer payStatusInt;

    private String tableName;//表名，数据库无此字段

    //额外信息,目前用来存储了摩拜的积分信息
    private String extraInfo;

    /** 子订单 入参 */
    private List<OrderItemDto> orderItemDtoList;
    private AmbSubOrdersDto ambSubOrdersDto;//加钱购子订单

    private Long ambPostsaleOrdersId;

    private String consumerRemark; //买家留言

    private Long salePrice;

    /**
     * 默认构造函数
     */
    public OrdersDto() {
    }

    /**
     *
     * @param id
     */
    public OrdersDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    /**
     *
     * @param init4insert
     */
    public OrdersDto(boolean init4insert) {
        if (init4insert) {
            failType = 0;
            allowInputAgain = false;
            facePrice = 0;
            auditStatus = AuditStatusNotNeed;
            relationType = RelationTypeDefault;

            consumerPayPrice = 0L;
            consumerPayBackPrice = 0L;

            duibaActualPrice = 0;

            flowworkStage = FlowworkStageOrderCreateStart;

            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }


    public void setError4Consumer(String error4Consumer) {
        if (error4Consumer != null && error4Consumer.length() > 255) {
            this.error4Consumer = error4Consumer.substring(0, 255);
        } else {
            this.error4Consumer = error4Consumer;
        }
    }

    public String getError4Developer() {
        return error4Developer;
    }

    public void setError4Developer(String error4Developer) {
        if (error4Developer != null && error4Developer.length() > 255) {
            this.error4Developer = error4Developer.substring(0, 255);
        } else {
            this.error4Developer = error4Developer;
        }
    }

    public String getError4Admin() {
        return error4Admin;
    }

    public void setError4Admin(String error4Admin) {
        if (error4Admin != null && error4Admin.length() > 255) {
            this.error4Admin = error4Admin.substring(0, 255);
        } else {
            this.error4Admin = error4Admin;
        }
    }


    /**
     * 判断 extra 字段里面有没有指定的字段值
     * @param fieldName
     * @return
     */
    public Boolean extraInfoHasFieldCheck(String fieldName){
        if(StringUtils.isNotBlank(this.extraInfo) && JSONValidator.from(this.extraInfo).validate()){
            JSONObject object = JSONObject.parseObject(this.extraInfo);
            return object.containsKey(fieldName);
        }

        return false;
    }

    /**
     * 获取 extra json 字段的话，获取里面具体字段的值
     * @param fieldName
     * @return
     */
    public Object getExtraInfoFieldValue(String fieldName){
        if(StringUtils.isNotBlank(this.extraInfo) && JSONValidator.from(this.extraInfo).validate()){
            JSONObject object = JSONObject.parseObject(this.extraInfo);
            return object.get(fieldName);
        }

        return null;
    }


    /**
     * 是否像镜像一样字段数据完全相同
     *
     * @param order
     * @return
     */
    public boolean equalsMirror(OrdersDto order) {
        return MirrorEqualsUtils.mirrorEquals(this, order);
    }


}
