package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.ConsumerExchangeLimitDto;
import cn.com.duiba.order.center.api.dto.ConsumerLimitRecordDto;
import cn.com.duiba.order.center.api.dto.ConsumerLimitRecordMultiDto;
import cn.com.duiba.order.center.api.paramquery.ConsumerExchangeLimitParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 17/5/15.
 */
@AdvancedFeignClient
public interface RemoteConsumerLimitRecordService {

    /**
     *
     * @param consumerLimitRecordMultiDto
     * @return
     */
    public DubboResult<ConsumerLimitRecordMultiDto> insert(ConsumerLimitRecordMultiDto consumerLimitRecordMultiDto);

    /**
     *
     * @param sourceId
     * @param sourceType
     * @return
     */
    public DubboResult<Integer> deleteBySource(Long sourceId, String sourceType);

    /**
     * 根据商品id和数量删除兑换限制
     * @param sourceId
     * @param appItemIdAndQuantityMap
     */
    public void deleteByAppItemIdAndQuantity(Long sourceId, Map<Long/*appItemId*/,Integer/*quantity*/> appItemIdAndQuantityMap);

    /**
     *
     * @param consumerExchangeLimitParams
     * @return
     */
    public DubboResult<Integer> countByItemKey(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    /**
     *
     * @param consumerExchangeLimitParams
     * @return
     */
    public DubboResult<Integer> countByItemKeyAndGmtCreate(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    /**
     *
     * @param consumerExchangeLimitParams
     * @return
     */
    public DubboResult<Integer> countByItemSubKey(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    /**
     *
     * @param consumerExchangeLimitParams
     * @return
     */
    public DubboResult<List<ConsumerExchangeLimitDto>> countByInItemKeySubKey(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    /**
     *
     * @param consumerExchangeLimitParams
     * @return
     */
    public DubboResult<List<ConsumerExchangeLimitDto>> countByInItemKeySubKeyAndGmtCreate(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    /**
     * 通过参数批量查询
     * @param consumerExchangeLimitParams
     * @return
     */
    public DubboResult<List<ConsumerExchangeLimitDto>> findByParams(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    /**
     * 根据条件查询时间记录
     * @param consumerExchangeLimitParams
     * @return
     */
    List<ConsumerLimitRecordDto> findLastRecordByParams(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    DubboResult<Integer> countByItemKeyAndPhone(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    DubboResult<Integer> countByItemKeyAndPhoneAndGmtCreate(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    Integer countByItemKeyAndSubItemKeyAndPhone(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    Integer countByItemKeyAndSubItemKeyAndPhoneAndGmtCreate(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    Integer batchInsert(List<ConsumerLimitRecordMultiDto> consumerLimitRecordMultiDtoList);
}
