package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.DevWaitSettleMoneyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * 加钱购子订单接口
 * Created by yansen on 16/9/26.
 */
@AdvancedFeignClient
public interface RemoteAmbSubOrdersService {
    /**
     *
     * @param subId
     * @return
     */
    public DubboResult<Integer> updateSettleStatusWaitSettleBySubId(Long subId);

    /**
     *
     * @param subId
     * @return
     */
    public DubboResult<AmbSubOrdersDto> findSubOrderById(Long subId);

    /**
     *
     * @param subId
     * @return
     */
    public DubboResult<Integer> updateSettleStatusSettleBySubId(Long subId);

    /**
     *
     * @param subId
     * @param remark
     * @return
     */
    public DubboResult<Integer> updateRemarkBySubId(Long subId, String remark);

    /**
     *
     * @param subId
     * @param consumerPayBackPrice
     * @return
     */
    public DubboResult<Integer> updateSettleStatusNoneBySubId(Long subId, Long consumerPayBackPrice);

    /**
     *
     * @param subId
     * @return
     */
    public DubboResult<Integer> updateShipStatus4ReceivedAtCreate(Long subId);

    /**
     *
     * @param subId
     * @return
     */
    DubboResult<Integer> updateShipStatus4WaitShip(Long subId);

    /**
     *
     * @param subId
     * @return
     */
    DubboResult<Integer> updateShipStatus4Shiped(Long subId);
    /**
     * 子订单确认收货
     * @param orderId
     * @param consumerId
     * @return
     */
    DubboResult<Void> consumerConfirmReceived(Long orderId,Long consumerId);

    /**
     *
     * @param developerId
     * @param appId
     * @param orderId
     * @param startDate
     * @param endDate
     * @param offset
     * @param max
     * @return
     */
    DubboResult<List<AmbSubOrdersDto>> findWaitSettleOrderList(Long developerId, Long appId, Long orderId, Date startDate, Date endDate, Integer offset, Integer max);

    /**
     *
     * @param developerId
     * @param appId
     * @param orderId
     * @param startDate
     * @param endDate
     * @return
     */
    DubboResult<Long> findWaitSettleOrderCount(Long developerId, Long appId, Long orderId, Date startDate, Date endDate);

    /**
     *
     * @param developerId
     * @return
     */
    DubboResult<Long> findWaitSettleMoney(Long developerId);

    /**
     *
     * @param orderId
     * @return
     */
    DubboResult<AmbSubOrdersDto> findByOrderId(Long orderId);

    /**
     *
     * @param ids
     * @return
     */
    DubboResult<List<AmbSubOrdersDto>> findAllByIds(List<Long> ids);

    /**
     * 批量获取开发者待结算金额
     * @param developerIds 开发者ID集合
     * @return
     */
    List<DevWaitSettleMoneyDto> batchFindWaitSettleMoney(List<Long> developerIds);
}
