package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.order.center.api.dto.ActivityOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.paramquery.ActivityOrdersPageQuery;
import cn.com.duiba.order.center.api.paramquery.OrdersAppSearchQuery;
import cn.com.duiba.order.center.api.paramquery.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * 主订单--开发者维度拆分表--基础接口
 * @author zhaodongxue
 *
 */
@AdvancedFeignClient
public interface RemoteMirrorOrderSimpleService {

	/**
	 *
	 * @param orderId
	 * @param appId
	 * @return
     */
	DubboResult<OrdersDto> findByOrderId(Long orderId, Long appId);

	/**
	 *
	 * @param ids
	 * @param appId
     * @return
     */
	DubboResult<List<OrdersDto>> findByOrderIds(List<Long> ids, Long appId);

	/**
	 *
	 * @param orderNum
	 * @param appId
     * @return
     */
	DubboResult<OrdersDto> findByOrderNum(String orderNum, Long appId);

	/**
	 *
	 * @param orderNums
	 * @param appId
     * @return
     */
	DubboResult<List<OrdersDto>> findByOrderNums(List<String> orderNums, Long appId);

	/**
	 *
	 * @param ordersAppSearchQuery
	 * @return
     */
	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	Page<OrdersDto> findOrdersByGmtCreate(OrdersAppSearchQuery ordersAppSearchQuery);

	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	DubboResult<Long> countOrdersByGmtCreate(OrdersAppSearchQuery ordersAppSearchQuery);

    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	Page<ActivityOrdersDto> findActivityOrdersPageByDay(ActivityOrdersPageQuery activityOrdersPageQuery);

    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	DubboResult<Integer> findOrderCountByAppIdAndDate(Long appId, Date startDate, Date endDate);

	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	Page<OrdersDto> findOrderByApp(OrdersAppSearchQuery ordersAppSearchQuery);
}
