package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.OrderItemDto;
import cn.com.duiba.service.exception.BusinessException;

import java.util.List;

/**
 * @author JunAngLiu
 * @Title: RemoteOrderItemService
 * @Description:
 * @date 2018/7/413:57
 */
@AdvancedFeignClient
public interface RemoteOrderItemService {

    /**
     * 根据 主订单id查询 子订单
     * */
     List<OrderItemDto> queryByOderId(Long OrderId) throws BusinessException;

    /**
     * 根据 主订单id集合 批量 查询 子订单
     * */
    List<OrderItemDto>queryByOrderIds(List<Long> orderIds,Long consumerId) throws BusinessException;


    /**
     * 根据 主订单id查询 子订单
     * */
    List<OrderItemDto> queryByOderIds(List<Long> OrderIds);


    /**
     * 更新优惠券ID
     * @param orderId
     * @param consumerId
     * @param couponId
     * @return
     */
    Boolean updateCouponId(Long orderId, Long consumerId, Long couponId);

    /**
     * 根据itemId查询商品
     * @param itemId
     * @return
     */
    OrderItemDto queryByItemId(Long itemId);
}
