package cn.com.duiba.order.center.api.constant;

/**
 * Created by dugq on 2018-12-24.
 */
public enum OrderRelationTypeEnum {
    DEFAULT(0, "普通订单"),
    ACTIVITY(1, "专题活动订单"),
    SINGLE_LOTTERY(2, "单品抽奖"),
    TURNTABLE(3, "大转盘订单"),
    MANUAL_LOTTERY(4,"手动开奖"),
    HDTOOL(5,"活动工具"),
    GAME(6,"游戏活动"),
    SECONDS_KILL(7,"秒杀专题"),
    QUESTION(8,"答题活动"),
    QUIZZ(10,"测试题活动"),
    SECKILL(9,"秒杀活动"),
    NGAME(11,"新游戏"),
    GUESS(12,"竞猜活动"),
    ROB(13,"今日必抢"),
    CREDIT_GAME(14,"积分游戏"),
    LITTLE_GAME(15,"小游戏"),
    PLUGIN(16,"插件活动"),
    ELASTIC_GIFTS(17,"弹层活动"),
    SIGN(18,"签到活动"),
    MAILA_ROB(19,"麦啦今日必抢"),
    HAPPY_CODE(20,"开心码"),
    ;

    private Integer code;
    private String desc;

    OrderRelationTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static OrderRelationTypeEnum ofValue(int code){
        for (OrderRelationTypeEnum type : values()){
            if(code == type.getCode()){
                return type;
            }
        }
        throw new UnsupportedOperationException("不支持的类型");
    }
}
