package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.OrdersFasterDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * Created by yansen on 16/9/23.
 */
@AdvancedFeignClient
public interface RemoteOrdersFasterSimpleService {
    /**
     *
     * @param ordersFasterDto
     * @return
     */
    public DubboResult<OrdersFasterDto> insert(OrdersFasterDto ordersFasterDto);

    /**
     *
     * @param orderId
     * @param fasterType
     * @return
     *
     */
    public DubboResult<OrdersFasterDto> findByOrderIdAndFastertype(Long orderId, Integer fasterType);

    /**
     *
     * @param id
     * @param lastSendTime
     * @return
     */
    public DubboResult<Integer> updateLastSendTime(Long id, Date lastSendTime);

    /**
     *
     * @param orderId
     * @param fasterType
     * @return
     */
    public DubboResult<Integer> deleteOrderByOrderIdAndFasterType(Long orderId, Integer fasterType);

    /**
     *
     * @param fasterType
     * @return
     */
    @Deprecated
    public DubboResult<List<OrdersFasterDto>> findHuiChangeAndSuDuDaTimeOutOrder(Integer fasterType);

    /**
     *
     * @param orderId
     * @return
     */
    public DubboResult<Void> deleteOrderFast(Long orderId);

	/**
     * 根据fasterType查询加速订单列表
     * @param fasterType
     * @return
     */
    public List<OrdersFasterDto> findOrdersFasterListByFasterType(Integer fasterType);


    /**
     * 根据fasterType和 开始日期 查询加速订单列表
     * */
    List<OrdersFasterDto> findOrdersFasListByFasTypeAndBTime(Integer fasterType,Date beginTime);


    /**
     * 根据fasterType和数据库的最小值id查询加速订单列表
     * 最多只返回10条数据
     * @param fasterType
     * @param minId
     * @return
     */
    public List<OrdersFasterDto> findListByFasterTypeWithLimit(Integer fasterType,Long minId);
}
