/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo;

import cn.com.duiba.wolf.utils.DateUtils;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.IntegerTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppTradingLimit {
    private final String APP_NAMESPACE = "app_trading";
    @Autowired
    private MemcachedClient memcachedClient;

    public Integer getTodayTradingCount(Long appId) {
        String key = "app_trading" + appId;
        Integer appItemCounter = 0;
        try {
            appItemCounter = (Integer)this.memcachedClient.get(key);
            if (appItemCounter == null) {
                appItemCounter = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appItemCounter;
    }

    public void resetTodayTradingCount(Long appId) {
        try {
            String key = "app_trading" + appId;
            this.memcachedClient.delete(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addTrading(Long appId) {
        try {
            String key = "app_trading" + appId;
            if (this.setByCas(key, 1) == 2) {
                this.memcachedClient.add(key, DateUtils.getToTomorrowSeconds(), (Object)1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Integer setByCas(String key, int type) {
        Integer result = null;
        boolean loop = true;
        try {
            int loopNum = 0;
            while (loop) {
                if (loopNum >= 10) {
                    loop = false;
                    result = 1;
                    break;
                }
                CASValue last = this.memcachedClient.gets(key);
                if (last == null) {
                    loop = false;
                    result = 2;
                    break;
                }
                int nextValue = (Integer)last.getValue();
                if (type > 0) {
                    ++nextValue;
                } else {
                    if (type >= 0) {
                        loop = false;
                        result = 4;
                        break;
                    }
                    --nextValue;
                }
                CASResponse caseResponse = this.memcachedClient.cas(key, last.getCas(), DateUtils.getToTomorrowSeconds(), (Object)nextValue, (Transcoder)new IntegerTranscoder());
                switch (caseResponse) {
                    case OK: {
                        loop = false;
                        result = 0;
                        break;
                    }
                    case NOT_FOUND: {
                        loop = false;
                        result = 2;
                        break;
                    }
                    case EXISTS: {
                        loop = true;
                    }
                }
                ++loopNum;
            }
        }
        catch (Exception e) {
            result = 5;
        }
        return result;
    }
}

