/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.amb.impl;

import cn.com.duiba.order.center.api.dto.ExpressCacheDto;
import cn.com.duiba.order.center.api.dto.amb.AmbExpressTemplateDto;
import cn.com.duiba.order.center.api.dto.amb.AmbExpressTemplateOptionDto;
import cn.com.duiba.order.center.biz.bo.amb.AmbExpressTemplateBo;
import cn.com.duiba.order.center.biz.service.amb.AmbExpressTemplateOptionService;
import cn.com.duiba.order.center.biz.service.amb.AmbExpressTemplateService;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.dataobject.ProvinceCityCodeDO;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.service.remoteservice.RemoteProvinceCityCodeService;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.spy.memcached.MemcachedClient;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AmbExpressTemplateBoImpl
implements AmbExpressTemplateBo {
    @Resource
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private AmbExpressTemplateService ambExpressTemplateService;
    @Autowired
    private AmbExpressTemplateOptionService ambExpressTemplateOptionService;
    @Autowired
    private RemoteProvinceCityCodeService remoteProvinceCityCodeService;
    @Autowired
    private MemcachedClient memcachedClient;

    @Override
    public Long matchExpressPrice(Long consumerId, Long expressTemplateId) throws Exception {
        ConsumerDO consumerDO = this.remoteConsumerService.find(consumerId);
        if (consumerDO == null) {
            throw new Exception("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        return this.matchExpressPrice(consumerDO.getAddrProvince(), consumerDO.getAddrCity(), consumerDO.getAddrArea(), expressTemplateId);
    }

    private Map<String, Long> getCodesAndPriceMatchs(List<AmbExpressTemplateOptionDto> templateOptionDOs) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (AmbExpressTemplateOptionDto ambExpressTemplateOptionDO : templateOptionDOs) {
            ArrayList<String> availableCodes = new ArrayList<String>();
            List<String> cityCodes = Arrays.asList(ambExpressTemplateOptionDO.getCityCode().split(","));
            List<String> provinceCodes = Arrays.asList(ambExpressTemplateOptionDO.getProvinceCode().split(","));
            for (int i = 0; i < cityCodes.size(); ++i) {
                if (cityCodes.get(i).equals("all")) {
                    availableCodes.add(provinceCodes.get(i));
                    continue;
                }
                availableCodes.add(cityCodes.get(i));
            }
            for (String string : availableCodes) {
                map.put(string, ambExpressTemplateOptionDO.getExpressPrice());
            }
        }
        return map;
    }

    @Override
    public Long matchExpressPrice(String addrProvince, String addrCity, String addrArea, Long expressTemplateId) throws Exception {
        ProvinceCityCodeDO provinceDO;
        Long expressPrice = null;
        String provinceCode = null;
        String cityCode = null;
        boolean isZxs = AmbExpressTemplateBoImpl.isZxsProvince(addrProvince);
        if (isZxs) {
            ProvinceCityCodeDO provinCityDO;
            if (!StringUtils.isBlank((String)addrProvince) && (provinCityDO = this.remoteProvinceCityCodeService.findByProvince(addrProvince.substring(0, 2))) != null) {
                provinceCode = provinCityDO.getCode();
                cityCode = provinCityDO.getCode();
            }
        } else if (!StringUtils.isBlank((String)addrProvince) && (provinceDO = this.remoteProvinceCityCodeService.findByProvince(addrProvince.substring(0, 2))) != null) {
            provinceCode = provinceDO.getCode();
            if (!StringUtils.isBlank((String)addrCity)) {
                ProvinceCityCodeDO cityDO = this.remoteProvinceCityCodeService.findByName(addrCity.substring(0, 2), provinceDO.getCode());
                cityCode = cityDO != null ? cityDO.getCode() : null;
            }
        }
        AmbExpressTemplateDto expressTemplateDO = this.ambExpressTemplateService.find(expressTemplateId);
        List<AmbExpressTemplateOptionDto> expressTemplateOptionDOs = this.ambExpressTemplateOptionService.findByTemplateId(expressTemplateId);
        if (expressTemplateDO == null && expressTemplateOptionDOs == null) {
            throw new Exception("\u8fd0\u8d39\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u5339\u914d\u5931\u8d25\uff01");
        }
        if (cityCode != null && provinceCode != null && expressTemplateOptionDOs != null) {
            String str = String.valueOf(this.memcachedClient.get(this.getExpressTemplateKey(expressTemplateDO.getId())));
            ExpressCacheDto cacheVO = (ExpressCacheDto)JSONObject.parseObject((String)str, ExpressCacheDto.class);
            Map matchs = null;
            if (cacheVO == null || !cacheVO.getGmtModified().equals(expressTemplateDO.getGmtModified())) {
                matchs = this.getCodesAndPriceMatchs(expressTemplateOptionDOs);
                cacheVO = new ExpressCacheDto();
                cacheVO.setGmtModified(expressTemplateDO.getGmtModified());
                cacheVO.setMatchs(matchs);
                this.memcachedClient.set(this.getExpressTemplateKey(expressTemplateDO.getId()), 3600, (Object)JSONObject.toJSONString((Object)cacheVO));
            } else {
                matchs = cacheVO.getMatchs();
            }
            Long temp = (Long)matchs.get(cityCode);
            expressPrice = temp == null ? (Long)matchs.get(provinceCode) : temp;
        }
        return expressPrice != null ? expressPrice : expressTemplateDO.getDefaultExpressPrice();
    }

    @Override
    public Long getDefaultPrice(Long expressTemplateId) {
        return this.ambExpressTemplateService.find(expressTemplateId).getDefaultExpressPrice();
    }

    private String getExpressTemplateKey(Long expressTemplateId) {
        return "123-" + expressTemplateId;
    }

    public static boolean isZxsProvince(String province) {
        return StringUtils.isNotBlank((String)province) && Arrays.asList("\u5317\u4eac\u5e02", "\u4e0a\u6d77\u5e02", "\u5929\u6d25\u5e02", "\u91cd\u5e86\u5e02").contains(province.trim());
    }
}

