/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.amb.impl;

import cn.com.duiba.order.center.api.dto.amb.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbSettledBo;
import cn.com.duiba.order.center.biz.service.amb.AmbSubOrdersService;
import cn.com.duiba.order.center.biz.service.email.PayCenterLog;
import cn.com.duiba.paycenter.client.AmbPayCenterServiceClient;
import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.result.AmbResult;
import cn.com.duiba.paycenter.service.AmbPayCenterService;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AmbSettledBoImpl
implements AmbSettledBo {
    private static Logger logger = LoggerFactory.getLogger(AmbSettledBoImpl.class);
    @Autowired
    private OrderReadManagerBo orderReadManagerBo;
    @Autowired
    private AmbSubOrdersService ambSubOrdersService;
    @Autowired
    private AmbPayCenterServiceClient ambPayCenterServiceClient;

    @Override
    public void ambSettled(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        if (null == order) {
            return;
        }
        if (!"success".equals(order.getStatus())) {
            throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97");
        }
        if (order.getConsumerPayPrice() <= 0L) {
            throw new Exception("\u7528\u6237\u4ed8\u8d39\u91d1\u989d\u4e0d\u6b63\u786e\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97");
        }
        if (!"success".equals(order.getConsumerPayStatus()) && !"pay_back".equals(order.getConsumerPayStatus())) {
            throw new Exception("\u7528\u6237\u652f\u4ed8\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97");
        }
        AmbSubOrdersDto subOrder = this.ambSubOrdersService.findSubOrderById(order.getSubOrderId());
        Long dlpMoney = 0L;
        Long duibaMoney = 0L;
        if ("dlp".equals(subOrder.getOrdersSource())) {
            dlpMoney = subOrder.getDlpSalePrice() + subOrder.getExpressPrice() - subOrder.getConsumerPayBackPrice();
        } else if ("duiba".equals(subOrder.getOrdersSource())) {
            if (null != order.getItemId() && order.getAppItemId() == null) {
                if (subOrder.getDuibaSalePrice() == subOrder.getDlpSalePrice()) {
                    duibaMoney = subOrder.getDuibaSalePrice() + subOrder.getExpressPrice() - subOrder.getConsumerPayBackPrice();
                    if (duibaMoney < 0L) {
                        throw new Exception("\u7ed3\u7b97\u91d1\u989d\u9519\u8bef");
                    }
                } else if (subOrder.getDuibaSalePrice() > subOrder.getDlpSalePrice()) {
                    Long m = subOrder.getDuibaSalePrice() - subOrder.getDlpSalePrice() - subOrder.getConsumerPayBackPrice();
                    if (m > 0L) {
                        dlpMoney = m;
                        duibaMoney = subOrder.getDlpSalePrice() + subOrder.getExpressPrice();
                    } else {
                        duibaMoney = subOrder.getDuibaSalePrice() + subOrder.getExpressPrice() - subOrder.getConsumerPayBackPrice();
                    }
                } else if (subOrder.getDuibaSalePrice() < subOrder.getDlpSalePrice()) {
                    logger.error("\u4e0d\u652f\u6301\u964d\u4ef7\u5356");
                }
            } else if (null != order.getAppItemId() && null != order.getItemId()) {
                logger.error("orderID: " + order.getId() + " subOrderId: " + subOrder.getId() + " \u5546\u54c1\u4e0d\u652f\u6301\u52a0\u94b1\u8d2d\uff0c\u62d2\u7edd\u7ed3\u7b97");
                throw new Exception("\u5546\u54c1\u4e0d\u652f\u6301\u52a0\u94b1\u8d2d\uff0c\u62d2\u7edd\u7ed3\u7b97");
            }
        }
        if (dlpMoney == 0L && duibaMoney == 0L) {
            this.ambSubOrdersService.updateSettleStatusSettleBySubId(subOrder.getId());
            return;
        }
        AmbPayCenterService.AmbPayChargeExtraParams params = new AmbPayCenterService.AmbPayChargeExtraParams();
        params.setAppId(order.getAppId());
        try {
            this.payCenterSettled(order, subOrder, params, dlpMoney, duibaMoney);
        }
        catch (Exception e) {
            logger.error("\u5411\u652f\u4ed8\u4e2d\u5fc3\u53d1\u8d77   \u7ed3\u7b97   \u5f02\u5e38", (Throwable)e);
        }
    }

    private void payCenterSettled(OrdersDto order, AmbSubOrdersDto subOrder, AmbPayCenterService.AmbPayChargeExtraParams params, Long dlpMoney, Long duibaMoney) throws Exception {
        RpcResult result = this.ambPayCenterServiceClient.orderSettle(order.getId(), duibaMoney, dlpMoney, params);
        if (!result.isOpSuccess()) {
            PayCenterLog.info("ambPayCenterServiceClient.orderSettle orderID :  " + order.getId() + " subId : " + subOrder.getId(), (Throwable)result.getRpcException());
            for (int i = 0; i < OrdersDto.try_again_count; ++i) {
                Uninterruptibles.sleepUninterruptibly((long)OrdersDto.try_again_interval_time.intValue(), (TimeUnit)TimeUnit.MILLISECONDS);
                result = this.ambPayCenterServiceClient.orderSettle(order.getId(), duibaMoney, dlpMoney, params);
                if (result.isOpSuccess()) break;
                PayCenterLog.info("ambPayCenterServiceClient.orderSettle orderID :  " + order.getId() + "  try again " + i + " subId : " + subOrder.getId());
            }
            if (!result.isOpSuccess()) {
                PayCenterLog.info("ambPayCenterServiceClient.orderSettle orderID :  " + order.getId() + "   subId : " + subOrder.getId(), (Throwable)result.getRpcException());
                String remark = subOrder.getRemark();
                remark = "ambSettled \u7ed3\u7b97\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7f51\u7edc\u5f02\u5e38\uff01" + remark;
                this.ambSubOrdersService.updateRemarkBySubId(subOrder.getId(), remark);
                throw new Exception("\u7ed3\u7b97 \u7f51\u7edc\u5f02\u5e38   orderID:" + order.getId());
            }
        }
        if (result.isOpSuccess()) {
            if (((AmbResult)result.getResult()).isBizSuccess()) {
                this.ambSubOrdersService.updateSettleStatusSettleBySubId(subOrder.getId());
            } else {
                PayCenterLog.info("ambPayCenterServiceClient.orderSettle orderID :  " + order.getId() + "  settled is failed !  " + " subId : " + subOrder.getId());
                String remark = subOrder.getRemark();
                remark = "ambSettled \u7ed3\u7b97\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7ed3\u7b97 \u652f\u4ed8\u4e2d\u5fc3\u53cd\u9988 \u5931\u8d25\uff01" + remark;
                this.ambSubOrdersService.updateRemarkBySubId(subOrder.getId(), remark);
                throw new Exception("\u7ed3\u7b97 \u5931\u8d25   orderID:" + order.getId());
            }
        }
    }
}

