/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.amb.impl;

import cn.com.duiba.order.center.api.dto.amb.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.ActualPriceCalculateBo;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbExpressTemplateBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbOrderFastBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbPostsaleBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbSubOrdersBo;
import cn.com.duiba.order.center.biz.service.amb.AmbSubOrdersService;
import cn.com.duiba.order.center.biz.service.amb.impl.AmbSubOrdersServiceImpl;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class AmbSubOrdersBoImpl
implements AmbSubOrdersBo {
    private static Logger log = LoggerFactory.getLogger(AmbSubOrdersServiceImpl.class);
    @Autowired
    private AmbSubOrdersService ambSubOrdersService;
    @Autowired
    private AmbPostsaleBo ambPostsaleBo;
    @Autowired
    private ActualPriceCalculateBo actualPriceCalculateBo;
    @Autowired
    private AmbExpressTemplateBo ambExpressTemplateBo;
    @Autowired
    private AmbOrderFastBo ambOrderFastBo;
    @Autowired
    private PlatformTransactionManager creditsMasterTransactionManager;
    @Autowired
    private OrderReadManagerBo orderReadManagerBo;

    @Override
    public AmbSubOrdersDto createAmbSubOrder(OrdersDto order, ItemKey key) throws Exception {
        Long expressPrice;
        AmbSubOrdersDto sub = new AmbSubOrdersDto();
        sub.setAppId(order.getAppId());
        sub.setAppItemId(order.getAppItemId());
        sub.setDeveloperId(order.getDeveloperId());
        sub.setOrdersId(order.getId());
        sub.setSettleStatus("none");
        sub.setShipStatus("create");
        AppItemDO aItem = key.getAppItem();
        ItemDO item1 = key.getItem();
        if (null != item1 && aItem == null) {
            if (item1.isOpTypeItem(11)) {
                sub.setDuibaSalePrice(key.getItem().getSalePrice());
                expressPrice = 0L;
                if ("unity".equals(key.getItem().getExpressType()) && null != key.getItem().getExpressPrice()) {
                    expressPrice = key.getItem().getExpressPrice();
                } else if ("template".equals(key.getItem().getExpressType()) && null != key.getItem().getExpressTemplateId()) {
                    expressPrice = this.ambExpressTemplateBo.matchExpressPrice(order.getConsumerId(), key.getItem().getExpressTemplateId());
                }
                sub.setExpressPrice(expressPrice);
                sub.setItemId(key.getItem().getId());
                Integer actualPrice = this.actualPriceCalculateBo.calculateNormalActualPrice(key);
                sub.setDlpSalePrice(Long.valueOf(actualPrice.intValue()));
                sub.setOrdersSource("duiba");
            }
        } else if (null != aItem && null == item1) {
            if (aItem.isOpTypeAppItem(11)) {
                sub.setDlpSalePrice(key.getAppItem().getSalePrice());
                sub.setOrdersSource("dlp");
                expressPrice = 0L;
                if ("unity".equals(key.getAppItem().getExpressType()) && null != key.getAppItem().getExpressPrice()) {
                    expressPrice = key.getAppItem().getExpressPrice();
                } else if ("template".equals(key.getAppItem().getExpressType()) && null != key.getAppItem().getExpressTemplateId()) {
                    expressPrice = this.ambExpressTemplateBo.matchExpressPrice(order.getConsumerId(), key.getAppItem().getExpressTemplateId());
                }
                sub.setExpressPrice(expressPrice);
            }
        } else if (null != aItem && null != item1) {
            throw new Exception("\u5151\u5427\u52a0\u94b1\u8d2d\u5546\u54c1\u4e0d\u53ef\u4ee5   \u52a0\u5165\u5230\u5f00\u53d1\u8005\u5546\u54c1\u4e2d");
        }
        try {
            this.ambSubOrdersService.createSubOrders(sub);
        }
        catch (Exception e) {
            log.error("createSubOrders  ", (Throwable)e);
            throw new Exception("make sub orders is error", e);
        }
        return sub;
    }

    @Override
    public boolean consumerConfirmReceived(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.creditsMasterTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            this.ambPostsaleBo.cancel(order.getId(), order.getConsumerId());
            this.ambSubOrdersService.updateShipStatus4Received(order.getSubOrderId());
            this.ambOrderFastBo.removeOrderFastWaitReceive(orderId);
            this.ambOrderFastBo.createOrderFastReceived(orderId, consumerId);
        }
        catch (Exception e) {
            status.setRollbackOnly();
            log.error("\u7528\u6237\u786e\u8ba4\u6536\u8d27\u64cd\u4f5c\u5931\u8d25\uff0corderId = " + order.getId(), (Throwable)e);
            throw e;
        }
        finally {
            this.creditsMasterTransactionManager.commit(status);
        }
        return true;
    }
}

