/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.impl;

import cn.com.duiba.goods.center.api.remoteservice.RemotePhoneBillListsService;
import cn.com.duiba.goods.center.api.remoteservice.dto.PhonebillListDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.biz.bo.ActualPriceCalculateBo;
import cn.com.duiba.order.center.biz.service.supplier_order.SupplierProductsService;
import cn.com.duiba.service.domain.dataobject.CenterConfigDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.domain.vo.PriceDegree;
import cn.com.duiba.service.remoteservice.RemoteCenterConfigService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActualPriceCalculateBoImpl
implements ActualPriceCalculateBo {
    @Autowired
    private RemoteCenterConfigService remoteCenterConfigService;
    @Autowired
    private RemotePhoneBillListsService remotePhoneBillListsService;
    @Autowired
    private SupplierProductsService supplierProductsService;

    @Override
    public Integer calculateMinActualPrice(ItemKey key) {
        if (key.getItemType().equals("alipay") || key.getItemType().equals("qb") || key.getItemType().equals("alipayfast") || key.getItemType().equals("alipaycode")) {
            PriceDegree pd = new PriceDegree(key.getAppItem().getCustomPrice());
            String minDegree = pd.getMinDegreeKey();
            return this.calculateNormalActualPrice(key, minDegree);
        }
        if (key.getItemType().equals("phonebill") || key.getItemType().equals("phoneflow")) {
            return 100;
        }
        if (key.getItemType().equals("coupon") || key.getItemType().equals("object")) {
            return this.calculateNormalActualPrice(key);
        }
        if (key.getItemType().equals("phonebillDingzhi")) {
            return key.getItem().getFacePrice();
        }
        return 0;
    }

    @Override
    public Integer calculateActualPrice(ItemKey key, String degree) {
        if (key.getItemType().equals("alipay") || key.getItemType().equals("qb") || key.getItemType().equals("alipayfast") || key.getItemType().equals("alipaycode")) {
            return this.calculateNormalActualPrice(key, degree);
        }
        if (key.getItemType().equals("phonebill") || key.getItemType().equals("phoneflow")) {
            return 100;
        }
        if (key.getItemType().equals("coupon") || key.getItemType().equals("object")) {
            return this.calculateNormalActualPrice(key);
        }
        return 0;
    }

    @Override
    public Integer calculateNormalActualPrice(ItemKey key, String degree) {
        if (key.isItemMode() || key.isDuibaAppItemMode()) {
            if (key.getItemType().equals("coupon") || key.getItemType().equals("object")) {
                if (degree == null) {
                    return key.getItem().getActualPrice();
                }
                throw new RuntimeException("\u5238\u6216\u8005\u5b9e\u7269\u7c7b\u5546\u54c1\u4e0d\u7528\u4f20\u6863\u4f4d\u4fe1\u606f\uff01");
            }
            if (key.getItem().getType().equals("phonebill") || key.getItemType().equals("phoneflow") || key.getItemType().equals("phonebillDingzhi")) {
                throw new RuntimeException("\u8bdd\u8d39\u548c\u6d41\u91cf\u5546\u54c1\u4e0d\u8d70\u8fd9\u4e2a\u65b9\u6cd5\uff01");
            }
            if (key.getItemType().equals("alipay") || key.getItemType().equals("qb") || key.getItemType().equals("alipayfast") || key.getItemType().equals("alipaycode")) {
                Integer price;
                if (degree == null) {
                    throw new RuntimeException("\u76f4\u5145\u7c7b\u5546\u54c1\u4e0d\u53ef\u4ee5\u6ca1\u6709\u6863\u4f4d\u4fe1\u606f\uff01");
                }
                Integer actualPrice = price = Integer.valueOf(Integer.valueOf(degree) * 100);
                CenterConfigDO ccDO = null;
                if (key.getItem().getType().equals("alipay")) {
                    ccDO = this.remoteCenterConfigService.findByType("alipay-rate");
                } else if (key.getItem().getType().equals("qb")) {
                    ccDO = this.remoteCenterConfigService.findByType("qb-rate");
                } else if (key.getItem().getType().equals("alipayfast")) {
                    ccDO = this.remoteCenterConfigService.findByType("alipayfast-rate");
                } else if (key.getItem().getType().equals("alipaycode")) {
                    ccDO = this.remoteCenterConfigService.findByType("alipaycode-rate");
                } else {
                    throw new RuntimeException("\u6ca1\u6709\u6b64\u5546\u54c1\u7684\u8d39\u7387\u4fe1\u606f\uff01");
                }
                String rateString = null;
                rateString = ccDO.getValue() != null ? ccDO.getValue() : ccDO.getFloatValue().toString();
                BigDecimal ret = new BigDecimal(price).multiply(new BigDecimal(rateString));
                actualPrice = (int)Math.ceil(ret.doubleValue());
                return actualPrice;
            }
            throw new RuntimeException("\u65e0\u6b64\u5546\u54c1\u7c7b\u578b\uff01");
        }
        if (key.isSelfAppItemMode()) {
            if (key.getItemType().equals("coupon") || key.getItemType().equals("object")) {
                return 0;
            }
            if ("virtual".equals(key.getItemType())) {
                return 0;
            }
            throw new RuntimeException("\u672a\u77e5\u7684\u81ea\u6709\u5546\u54c1\u7c7b\u578b\uff01");
        }
        throw new RuntimeException("\u65e0\u6b64\u6a21\u5f0f\u7c7b\u578b\uff01");
    }

    @Override
    public Integer calculateNormalActualPrice(ItemKey key) {
        return this.calculateNormalActualPrice(key, null);
    }

    @Override
    public Integer calculatePhoneflowActualPrice(SupplierProductDto product) {
        Integer actualPrice = product.getActualPrice() == null ? product.getSupplierPrice() : product.getActualPrice();
        return actualPrice;
    }

    @Override
    public Integer calculatePhonebillActualPrice(String mobile, String province, Integer facePrice) {
        SupplierProductDto sp = this.queryProduct(mobile, province, facePrice);
        Integer actualPrice = this.getActualPrice(sp);
        return actualPrice;
    }

    @Override
    public SupplierProductDto queryProduct(String mobile, String province, int facePrice) {
        CenterConfigDO gyjxConfig = this.remoteCenterConfigService.findByType("lianlian-phonebill-switch");
        if (!(facePrice < 1000 || gyjxConfig != null && gyjxConfig.getBoolValue().booleanValue())) {
            return null;
        }
        List<Object> ps = new ArrayList();
        if (facePrice < 1000) {
            if (mobile.contains("\u7535\u4fe1")) {
                CenterConfigDO oufeiConfig = this.remoteCenterConfigService.findByType("oufei-phonebill-switch");
                if (oufeiConfig == null || !oufeiConfig.getBoolValue().booleanValue()) {
                    return null;
                }
                ps = this.supplierProductsService.findBySupplierAndFacePrice("phonebill-oufei", facePrice);
            } else {
                CenterConfigDO sududaConfig = this.remoteCenterConfigService.findByType("sududa-phonebill-switch");
                if (sududaConfig == null || !sududaConfig.getBoolValue().booleanValue()) {
                    return null;
                }
                ps = this.supplierProductsService.findBySupplierAndFacePrice("phonebill-sududa", facePrice);
            }
        } else {
            ps = this.supplierProductsService.findBySupplierAndFacePrice("phonebill-lianlian-new-platform", facePrice);
        }
        for (SupplierProductDto supplierProductDto : ps) {
            if (mobile.contains(supplierProductDto.getMobile()) && province.contains(supplierProductDto.getProvince()) && facePrice == supplierProductDto.getFacePrice()) {
                return supplierProductDto;
            }
            if (!mobile.contains(supplierProductDto.getMobile()) || facePrice != supplierProductDto.getFacePrice() || !supplierProductDto.getProvince().contains("\u5168\u56fd")) continue;
            return supplierProductDto;
        }
        return null;
    }

    private Integer getActualPrice(SupplierProductDto sp) {
        PhonebillListDto p = this.findPhonebill(sp.getMobile(), sp.getProvince(), sp.getFacePrice(), sp.getSupplier());
        if (p != null) {
            if (p.getPublicPrice() != null) {
                return p.getPublicPrice();
            }
            if ("phonebill-gyjx".equals(sp.getSupplier())) {
                return p.getGyjxPrice() + 2;
            }
            if ("phonebill-sududa".equals(sp.getSupplier())) {
                return p.getSududaPrice() + 2;
            }
            if ("phonebill-oufei".equals(sp.getSupplier())) {
                return p.getOufeiPrice() + 2;
            }
            if ("phonebill-lianlian-new".equals(sp.getSupplier())) {
                return p.getLianlianPrice() + 2;
            }
            if ("phonebill-lianlian-new-platform".equals(sp.getSupplier())) {
                return p.getLianlianPrice() + 2;
            }
        }
        return null;
    }

    @Override
    public PhonebillListDto findPhonebill(String mobile, String province, Integer facePrice, String supplier) {
        DubboResult dubboResult;
        List pls = new ArrayList();
        if (mobile.contains("\u79fb\u52a8")) {
            dubboResult = this.remotePhoneBillListsService.findByMobileAndFacePrice("\u79fb\u52a8", facePrice);
            if (!dubboResult.isSuccess()) {
                throw new RuntimeException(dubboResult.getMsg());
            }
            pls = (List)dubboResult.getResult();
        } else if (mobile.contains("\u8054\u901a")) {
            dubboResult = this.remotePhoneBillListsService.findByMobileAndFacePrice("\u8054\u901a", facePrice);
            if (!dubboResult.isSuccess()) {
                throw new RuntimeException(dubboResult.getMsg());
            }
            pls = (List)dubboResult.getResult();
        } else if (mobile.contains("\u7535\u4fe1")) {
            dubboResult = this.remotePhoneBillListsService.findByMobileAndFacePrice("\u7535\u4fe1", facePrice);
            if (!dubboResult.isSuccess()) {
                throw new RuntimeException(dubboResult.getMsg());
            }
            pls = (List)dubboResult.getResult();
        }
        for (PhonebillListDto p : pls) {
            if (!province.contains(p.getProvince()) && !p.getProvince().contains("\u5168\u56fd")) continue;
            if ("phonebill-gyjx".equals(supplier) && p.getGyjxPrice() != null) {
                return p;
            }
            if ("phonebill-sududa".equals(supplier) && p.getSududaPrice() != null) {
                return p;
            }
            if ("phonebill-oufei".equals(supplier) && p.getOufeiPrice() != null) {
                return p;
            }
            if ("phonebill-lianlian-new".equals(supplier) && p.getLianlianPrice() != null) {
                return p;
            }
            if (!"phonebill-lianlian-new-platform".equals(supplier) || p.getLianlianPrice() == null) continue;
            return p;
        }
        return null;
    }
}

