/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.impl;

import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryOrderDto;
import cn.com.duiba.activity.center.api.remoteservice.singlelottery.RemoteSingleLotteryOrderService;
import cn.com.duiba.order.center.api.dto.OrdersViewDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.orders_faster.OrdersFasterDto;
import cn.com.duiba.order.center.api.dto.queryparam.AabnormalOrderQueryDto;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.bo.OrdersFasterService;
import cn.com.duiba.order.center.biz.service.orders_faster.OrdersFasterBizReadService;
import cn.com.duiba.order.center.biz.service.orders_faster.OrdersFasterSimpleService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.TurntableOrderDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteTurntableOrderService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrdersFasterServiceImpl
implements OrdersFasterService {
    @Autowired
    private RemoteTurntableOrderService remoteTurntableOrderService;
    @Autowired
    private RemoteSingleLotteryOrderService remoteSingleLotteryOrderService;
    @Autowired
    private OrderReadManagerBo orderReadManagerBo;
    @Autowired
    private OrdersFasterSimpleService ordersFasterSimpleService;
    @Autowired
    private OrdersFasterBizReadService ordersFasterBizReadService;
    @Autowired
    private RemoteAppService remoteAppService;

    @Override
    public void insert(OrdersDto ordersDO, int type) {
        this.ordersFasterSimpleService.insert(this.orderParseToOrdersFaster(ordersDO, type));
    }

    public OrdersFasterDto orderParseToOrdersFaster(OrdersDto ordersDO, int type) {
        OrdersFasterDto ordersFasterDO = new OrdersFasterDto(true);
        ordersFasterDO.setAppId(ordersDO.getAppId());
        ordersFasterDO.setLastSendTime(ordersDO.getLastSendTime());
        ordersFasterDO.setOrderId(ordersDO.getId());
        ordersFasterDO.setType(ordersDO.getType());
        ordersFasterDO.setOrderNum(ordersDO.getOrderNum());
        ordersFasterDO.setFasterType(Integer.valueOf(type));
        ordersFasterDO.setBrief(ordersDO.getBrief());
        ordersFasterDO.setDevelopBizId(ordersDO.getDeveloperBizId());
        ordersFasterDO.setActualPrice(ordersDO.getActualPrice());
        ordersFasterDO.setConsumerId(ordersDO.getConsumerId());
        ordersFasterDO.setAccount(this.getAccountByOrder(ordersDO));
        ordersFasterDO.setOrderGmtCreate(ordersDO.getGmtCreate());
        ordersFasterDO.setRelationType(ordersDO.getRelationType());
        return ordersFasterDO;
    }

    @Override
    public String getAccountByOrder(OrdersDto order) {
        if (null == order) {
            return null;
        }
        String type = order.getType();
        String bizParam = order.getBizParams();
        if (StringUtils.isBlank((String)bizParam)) {
            return null;
        }
        if (type.equals("alipay") || type.equals("phonebill")) {
            return StringUtils.split((String)bizParam, (String)":")[0];
        }
        if (type.equals("alipaycode") || type.equals("alipayfast") || type.equals("phoneflow") || type.equals("qb")) {
            return order.getBizParams();
        }
        if (type.equals("object")) {
            if (order.getChargeMode().equals("manuallottery")) {
                return StringUtils.split((String)bizParam, (String)":")[0];
            }
            return StringUtils.split((String)bizParam, (String)":")[1];
        }
        return null;
    }

    @Override
    public void update(OrdersDto ordersDO, OrdersFasterDto orderFastDO) {
        OrdersFasterDto OrdersFasterDONew = new OrdersFasterDto(orderFastDO.getId());
        OrdersFasterDONew.setLastSendTime(ordersDO.getLastSendTime());
        this.ordersFasterSimpleService.updateLastSendTime(OrdersFasterDONew.getId(), OrdersFasterDONew.getLastSendTime());
    }

    @Override
    public void deleteOrdersFast(OrdersDto ordersDO) {
        List<OrdersFasterDto> orderFastDOList = this.ordersFasterSimpleService.findByOrderId(ordersDO.getId());
        if (null == orderFastDOList || orderFastDOList.isEmpty()) {
            return;
        }
        this.ordersFasterSimpleService.deleteOrderFast(ordersDO.getId());
    }

    @Override
    public List<OrdersDto> parseOrdersFaster(AabnormalOrderQueryDto queryEntity) {
        List<OrdersFasterDto> orderFastList = this.ordersFasterBizReadService.findTimeoutOrder(queryEntity);
        List<OrdersDto> result = new ArrayList<OrdersDto>();
        if (null == orderFastList || orderFastList.isEmpty()) {
            return result;
        }
        ArrayList<Long> orderIds = new ArrayList<Long>();
        for (OrdersFasterDto fasterOrder : orderFastList) {
            orderIds.add(fasterOrder.getOrderId());
        }
        result = this.orderReadManagerBo.findAllByIds(orderIds);
        if (null == result || result.isEmpty()) {
            return result;
        }
        for (int i = result.size() - 1; i >= 0; --i) {
            OrdersDto order = result.get(i);
            if (order.getStatus().equals("consume_success")) continue;
            result.remove(i);
            this.ordersFasterSimpleService.deleteOrderFast(order.getId());
        }
        return result;
    }

    @Override
    public List<OrdersDto> parseKillOrderFaster(Map<String, Object> queryEntity) {
        List<OrdersFasterDto> orderFastList = this.ordersFasterBizReadService.findSencodeKillOrder(queryEntity);
        List<OrdersDto> result = new ArrayList<OrdersDto>();
        if (null == orderFastList || orderFastList.isEmpty()) {
            return result;
        }
        ArrayList<Long> orderIds = new ArrayList<Long>();
        for (OrdersFasterDto fasterOrder : orderFastList) {
            orderIds.add(fasterOrder.getOrderId());
        }
        result = this.orderReadManagerBo.findAllByIds(orderIds);
        if (null == result || result.isEmpty()) {
            return result;
        }
        for (int i = result.size() - 1; i >= 0; --i) {
            OrdersDto order = result.get(i);
            if (order.getStatus().equals("consume_fail")) continue;
            result.remove(i);
            this.ordersFasterSimpleService.deleteOrderFast(order.getId());
        }
        return result;
    }

    @Override
    public List<OrdersViewDto> parseLotteryOrdersFaster(AabnormalOrderQueryDto queryEntity) {
        ArrayList<OrdersViewDto> ordersDto = new ArrayList<OrdersViewDto>();
        if (StringUtils.isNotBlank((String)queryEntity.getOrderNum())) {
            OrdersViewDto ov = new OrdersViewDto();
            SingleLotteryOrderDto sl = null;
            TurntableOrderDO to = null;
            OrdersDto o = null;
            if (queryEntity.getOrderNum().startsWith("singlelottery-")) {
                String soid = queryEntity.getOrderNum().substring("singlelottery-".length(), queryEntity.getOrderNum().length());
                try {
                    sl = this.remoteSingleLotteryOrderService.find(Long.valueOf(soid));
                    o = this.orderReadManagerBo.find(sl.getOrderId(), sl.getConsumerId());
                }
                catch (NumberFormatException e) {
                    o = null;
                }
            } else {
                to = this.remoteTurntableOrderService.findByOrderNum(queryEntity.getOrderNum());
                if (to != null) {
                    o = this.orderReadManagerBo.find(to.getOrderId(), to.getConsumerId());
                }
            }
            if (o != null) {
                ov.setId(o.getId());
                ov.setGmtCreate(o.getGmtCreate());
                ov.setBrief(o.getBrief());
                ov.setOrderType(o.getType());
                ov.setError4Admin(o.getError4Admin());
                ov.setAllowInputAgain(o.getAllowInputAgain());
                ov.setStatus(o.getStatus());
                AppDO app = this.remoteAppService.find(o.getAppId());
                ov.setAppName(app.getName());
                if (o.getChargeMode().equals("turntable")) {
                    ov.setFasterType(Integer.valueOf(7));
                    ov.setTurntableOrderNum(to.getOrderNum());
                }
                if (o.getChargeMode().equals("singlelottery")) {
                    ov.setFasterType(Integer.valueOf(8));
                    ov.setSingleLotteryOrderNum("singlelottery-" + sl.getId());
                }
                ordersDto.add(ov);
            }
            return ordersDto;
        }
        List<OrdersFasterDto> orderFastList = this.ordersFasterBizReadService.findLotteryTimeoutOrder(queryEntity);
        if (null == orderFastList || orderFastList.isEmpty()) {
            return ordersDto;
        }
        ArrayList<Long> orderIds = new ArrayList<Long>();
        ArrayList<Long> appIds = new ArrayList<Long>();
        ArrayList<Long> toids = new ArrayList<Long>();
        ArrayList<Long> soids = new ArrayList<Long>();
        Long appId = 0L;
        for (OrdersFasterDto fasterOrder : orderFastList) {
            orderIds.add(fasterOrder.getOrderId());
            if (appId.equals(fasterOrder.getAppId())) continue;
            appId = fasterOrder.getAppId();
            appIds.add(appId);
        }
        List<OrdersDto> result = this.orderReadManagerBo.findAllByIds(orderIds);
        for (int i = result.size() - 1; i >= 0; --i) {
            OrdersDto order = result.get(i);
            if (!order.getStatus().equals("consume_success")) {
                result.remove(i);
                this.ordersFasterSimpleService.deleteOrderFast(order.getId());
            }
            if (order.getChargeMode().equals("turntable")) {
                toids.add(order.getId());
            }
            if (!order.getChargeMode().equals("singlelottery")) continue;
            soids.add(order.getId());
        }
        List apps = this.remoteAppService.findByIds(appIds);
        HashMap<Long, String> appmaps = new HashMap<Long, String>();
        for (AppDO app : apps) {
            appmaps.put(app.getId(), app.getName());
        }
        HashMap<Long, String> tomaps = new HashMap<Long, String>();
        if (toids.size() > 0) {
            List tos = this.remoteTurntableOrderService.findByInOrderIds(toids);
            for (TurntableOrderDO to : tos) {
                tomaps.put(to.getOrderId(), to.getOrderNum());
            }
        }
        HashMap<Long, String> somaps = new HashMap<Long, String>();
        if (soids.size() > 0) {
            List slos = this.remoteSingleLotteryOrderService.findByInOrderIds(soids);
            for (SingleLotteryOrderDto so : slos) {
                somaps.put(so.getOrderId(), "singlelottery-" + so.getId());
            }
        }
        for (OrdersDto o : result) {
            OrdersViewDto ov = new OrdersViewDto();
            ov.setId(o.getId());
            ov.setGmtCreate(o.getGmtCreate());
            ov.setBrief(o.getBrief());
            ov.setOrderType(o.getType());
            ov.setError4Admin(o.getError4Admin());
            ov.setAllowInputAgain(o.getAllowInputAgain());
            ov.setStatus(o.getStatus());
            if (appmaps.get(o.getAppId()) != null) {
                ov.setAppName((String)appmaps.get(o.getAppId()));
            }
            if (o.getChargeMode().equals("turntable")) {
                ov.setTurntableOrderNum((String)tomaps.get(o.getId()));
                ov.setFasterType(Integer.valueOf(7));
            }
            if (o.getChargeMode().equals("singlelottery")) {
                ov.setFasterType(Integer.valueOf(8));
                ov.setSingleLotteryOrderNum((String)somaps.get(o.getId()));
            }
            ordersDto.add(ov);
        }
        return ordersDto;
    }
}

