/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.impl;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteOperatingActivityServiceNew;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersSeriousExcetpionDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.biz.bo.OrdersStatusChangeBo;
import cn.com.duiba.order.center.biz.service.email.EmailService;
import cn.com.duiba.order.center.biz.service.email.PayCenterLog;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersSimpleService;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersStatusChangeService;
import cn.com.duiba.order.center.biz.service.orders.master.MasterOrdersPayCenterExceptionService;
import cn.com.duiba.order.center.biz.service.orders.master.MasterOrdersSeriousExceptionLogService;
import cn.com.duiba.order.center.biz.service.supplier_order.SupplierOrdersService;
import cn.com.duiba.paycenter.client.DuibaPayOrdersServiceClient;
import cn.com.duiba.paycenter.client.PayOrdersServiceClient;
import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.dto.DuibaDeduceDetailDto;
import cn.com.duiba.paycenter.params.PayOrdersExtraParams;
import cn.com.duiba.paycenter.remoteservice.RemoteDuibaDeduceDetailService;
import cn.com.duiba.paycenter.result.PayOrdersResult;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import com.google.common.base.Objects;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class OrdersStatusChangeBoImpl
implements OrdersStatusChangeBo {
    private static Logger log = LoggerFactory.getLogger(OrdersStatusChangeBoImpl.class);
    @Autowired
    private OrdersStatusChangeService ordersStatusChangeService;
    @Autowired
    private OrdersSimpleService ordersSimpleService;
    @Resource
    private PlatformTransactionManager ordersConsumerTransactionManager;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private SupplierOrdersService supplierOrdersService;
    @Autowired
    private MasterOrdersPayCenterExceptionService masterOrdersPayCenterExceptionService;
    @Autowired
    private MasterOrdersSeriousExceptionLogService masterOrdersSeriousExceptionLogService;
    @Autowired
    private PayOrdersServiceClient payOrdersServiceClient;
    @Autowired
    private DuibaPayOrdersServiceClient duibaPayOrdersServiceClient;
    @Autowired
    private EmailService emailService;
    @Resource
    private RemoteDuibaDeduceDetailService remoteDuibaDeduceDetailService;
    @Autowired
    private RemoteOperatingActivityServiceNew remoteOperatingActivityServiceNew;

    @Override
    public boolean doAmbPaySuccess(Long orderId, Long consumerId) throws Exception {
        block7: {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
            try {
                OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                if ("consume_success".equals(order.getStatus()) && "wait_pay".equals(order.getConsumerPayStatus())) {
                    int ret = this.ordersStatusChangeService.doAmbConsumerPayStatusPaySuccess(orderId, consumerId);
                    if (ret == 0) {
                        throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
                    }
                    break block7;
                }
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c");
            }
            catch (Exception e1) {
                status.setRollbackOnly();
                throw e1;
            }
            finally {
                this.ordersConsumerTransactionManager.commit(status);
            }
        }
        return true;
    }

    @Override
    public boolean doAmbStatusAfterSend(Long orderId, Long consumerId) throws Exception {
        block7: {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
            try {
                OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                if ("consume_success".equals(order.getStatus()) && "pay_success".equals(order.getConsumerPayStatus())) {
                    int ret = this.ordersStatusChangeService.doAmbStatusAfterSend(orderId, consumerId);
                    if (ret == 0) {
                        throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
                    }
                    break block7;
                }
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c");
            }
            catch (Exception e1) {
                status.setRollbackOnly();
                throw e1;
            }
            finally {
                this.ordersConsumerTransactionManager.commit(status);
            }
        }
        return true;
    }

    @Override
    public boolean doAuditPass(Long orderId, Long consumerId) throws Exception {
        block8: {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
            try {
                OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                if (order.getConsumerPayPrice() > 0L && !"pay_success".equals(order.getConsumerPayStatus())) {
                    throw new Exception("\u52a0\u94b1\u8d2d\u4ed8\u8d39\u72b6\u6001\u5f02\u5e38");
                }
                if ("wait".equals(order.getAuditStatus()) && "consume_success".equals(order.getStatus())) {
                    order.setAuditStatus("pass");
                    order.setAuditTime(new Date());
                    int ret = this.ordersStatusChangeService.doAuditPass(orderId, consumerId);
                    if (ret == 0) {
                        throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
                    }
                    break block8;
                }
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c");
            }
            catch (Exception e1) {
                status.setRollbackOnly();
                throw e1;
            }
            finally {
                this.ordersConsumerTransactionManager.commit(status);
            }
        }
        return true;
    }

    @Override
    public boolean doAuditPass(OrdersDto order) throws Exception {
        if (order.getConsumerPayPrice() > 0L && !"pay_success".equals(order.getConsumerPayStatus())) {
            throw new Exception("\u52a0\u94b1\u8d2d\u4ed8\u8d39\u72b6\u6001\u5f02\u5e38");
        }
        if ("wait".equals(order.getAuditStatus()) && "consume_success".equals(order.getStatus())) {
            order.setAuditStatus("pass");
            order.setAuditTime(new Date());
            int ret = this.ordersStatusChangeService.doAuditPass(order.getId(), order.getConsumerId());
            if (ret == 0) {
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
        } else {
            throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c");
        }
        return true;
    }

    @Override
    public boolean doAuditReject(Long orderId, Long consumerId) throws Exception {
        block8: {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
            try {
                OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                if (order.getConsumerPayPrice() > 0L && !"pay_success".equals(order.getConsumerPayStatus())) {
                    throw new Exception("\u52a0\u94b1\u8d2d\u4ed8\u8d39\u72b6\u6001\u5f02\u5e38");
                }
                if ("wait".equals(order.getAuditStatus()) && "consume_success".equals(order.getStatus())) {
                    order.setAuditStatus("reject");
                    order.setAuditTime(new Date());
                    order.setError4Consumer("\u5ba1\u6838\u4e0d\u901a\u8fc7");
                    order.setError4Developer("\u5ba1\u6838\u4e0d\u901a\u8fc7");
                    order.setError4Admin("\u5ba1\u6838\u4e0d\u901a\u8fc7");
                    order.setFailType(Integer.valueOf(4));
                    int ret = this.ordersStatusChangeService.doAuditReject(order.getId(), order.getConsumerId(), order.getError4Consumer(), order.getError4Developer(), order.getError4Admin(), order.getFailType());
                    if (ret == 0) {
                        status.setRollbackOnly();
                        throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
                    }
                    break block8;
                }
                status.setRollbackOnly();
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c");
            }
            catch (Exception e1) {
                status.setRollbackOnly();
                throw e1;
            }
            finally {
                this.ordersConsumerTransactionManager.commit(status);
            }
        }
        return true;
    }

    @Override
    public boolean doMakeSuccess(Long orderId, Long consumerId) throws Exception {
        block12: {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
            if (!status.isNewTransaction()) {
                throw new Exception("doMakeSuccess \u4e0d\u80fd\u5d4c\u5957\u4e8b\u52a1");
            }
            try {
                OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                if (!"success".equals(order.getStatus()) && !"fail".equals(order.getStatus())) {
                    int ret;
                    if (order.getSupplierOrderId() != null) {
                        SupplierOrderDto so4u = new SupplierOrderDto(order.getSupplierOrderId());
                        so4u.setStatus("success");
                        this.supplierOrdersService.update(so4u);
                    }
                    String duibaPayStatus = null;
                    if (!Objects.equal((Object)"none", (Object)order.getDuibaPayStatus())) {
                        duibaPayStatus = "success";
                    }
                    String payStatus = null;
                    if (!Objects.equal((Object)"none", (Object)order.getPayStatus())) {
                        payStatus = "successs";
                    }
                    String consumerPayStatus = null;
                    if (order.getConsumerPayPrice() > 0L && "pay_success".equals(order.getConsumerPayStatus())) {
                        consumerPayStatus = "success";
                    }
                    if ((ret = this.ordersStatusChangeService.doMakeSuccess(orderId, consumerId, payStatus, duibaPayStatus, consumerPayStatus)) == 0) {
                        status.setRollbackOnly();
                        throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
                    }
                    break block12;
                }
                status.setRollbackOnly();
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u6210\u529f\u64cd\u4f5c");
            }
            catch (Exception e1) {
                status.setRollbackOnly();
                throw e1;
            }
            finally {
                this.ordersConsumerTransactionManager.commit(status);
            }
        }
        return true;
    }

    @Override
    public boolean doMakeFail(Long orderId, Long consumerId) throws Exception {
        block35: {
            OrdersDto tempOrder = this.ordersSimpleService.find(orderId, consumerId);
            if (tempOrder.getActualPrice() > 0 || tempOrder.getDuibaActualPrice() > 0) {
                DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
                if (!status.isNewTransaction()) {
                    throw new Exception("doMakeFail \u4e0d\u80fd\u5d4c\u5957\u4e8b\u52a1");
                }
                try {
                    int ret;
                    OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                    if ("success".equals(order.getStatus()) || "fail".equals(order.getStatus())) {
                        throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
                    }
                    if ("successs".equals(order.getPayStatus()) || "payback".equals(order.getPayStatus())) {
                        throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
                    }
                    if ("payback".equals(order.getDuibaPayStatus()) || "success".equals(order.getDuibaPayStatus())) {
                        throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
                    }
                    String duibaPayStatus = null;
                    if (!Objects.equal((Object)"none", (Object)order.getDuibaPayStatus())) {
                        duibaPayStatus = order.getDuibaPayStatus();
                    }
                    String payStatus = null;
                    if (!Objects.equal((Object)"none", (Object)order.getPayStatus())) {
                        payStatus = order.getPayStatus();
                    }
                    String consumerPayStatus = null;
                    Long consumerPaybackPrice = null;
                    if (order.getConsumerPayPrice() > 0L) {
                        if ("wait_pay".equals(order.getConsumerPayStatus())) {
                            consumerPayStatus = "canceled";
                        } else if ("pay_success".equals(order.getConsumerPayStatus())) {
                            consumerPayStatus = "pay_back";
                            consumerPaybackPrice = order.getConsumerPayPrice();
                        }
                    }
                    if ((ret = this.ordersStatusChangeService.doMakeFail(orderId, consumerId, payStatus, duibaPayStatus, consumerPayStatus, consumerPaybackPrice)) == 0) {
                        status.setRollbackOnly();
                        throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
                    }
                }
                catch (Exception e) {
                    status.setRollbackOnly();
                    throw e;
                }
                finally {
                    this.ordersConsumerTransactionManager.commit(status);
                }
                OrdersDto ods = this.ordersSimpleService.find(orderId, consumerId);
                if (ods.getDuibaActualPrice() > 0) {
                    try {
                        this.callbackDuibaPayOrders(ods);
                    }
                    catch (Exception e) {
                        log.error("doMakeFail callbackDuibaPayOrders error", (Throwable)e);
                    }
                }
                if (ods.getActualPrice() > 0) {
                    try {
                        this.callbackPayOrders(ods);
                    }
                    catch (Exception e) {
                        log.error("doMakeFail callbackPayOrders error", (Throwable)e);
                    }
                }
                return true;
            }
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
            try {
                OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                if (!"success".equals(order.getStatus()) && !"fail".equals(order.getStatus())) {
                    int ret;
                    String consumerPayStatus = null;
                    Long consumerPaybackPrice = null;
                    if (order.getConsumerPayPrice() > 0L) {
                        if ("wait_pay".equals(order.getConsumerPayStatus())) {
                            consumerPayStatus = "canceled";
                        } else if ("pay_success".equals(order.getConsumerPayStatus())) {
                            consumerPayStatus = "pay_back";
                            consumerPaybackPrice = order.getConsumerPayPrice();
                        }
                    }
                    if ((ret = this.ordersStatusChangeService.doMakeFail(orderId, consumerId, null, null, consumerPayStatus, consumerPaybackPrice)) == 0) {
                        status.setRollbackOnly();
                        throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
                    }
                    break block35;
                }
                status.setRollbackOnly();
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c\u5931\u8d25\u64cd\u4f5c");
            }
            catch (Exception e) {
                status.setRollbackOnly();
                throw e;
            }
            finally {
                this.ordersConsumerTransactionManager.commit(status);
            }
        }
        return true;
    }

    private void callbackDuibaPayOrders(OrdersDto order) {
        DuibaDeduceDetailDto detail = this.genDuibaDeduceDetail(order);
        RpcResult result = this.duibaPayOrdersServiceClient.backpayOrder(order.getId(), Long.valueOf(order.getDuibaActualPrice().intValue()));
        if (!result.isOpSuccess()) {
            PayCenterLog.info("call duibaPayOrdersServiceClient.backpayOrder  exception developId " + order.getDeveloperId() + "  " + result.getRpcException());
            for (int i = 0; i < OrdersDto.try_again_count; ++i) {
                Uninterruptibles.sleepUninterruptibly((long)OrdersDto.try_again_interval_time.intValue(), (TimeUnit)TimeUnit.MILLISECONDS);
                result = this.duibaPayOrdersServiceClient.backpayOrder(order.getId(), Long.valueOf(order.getDuibaActualPrice().intValue()));
                if (result.isOpSuccess()) break;
                PayCenterLog.info("call duibaPayOrdersServiceClient.backpayOrder  exception developId" + order.getDeveloperId() + " try again " + i, (Throwable)result.getRpcException());
            }
            if (!result.isOpSuccess()) {
                this.masterOrdersPayCenterExceptionService.insert(order, "payback \u5151\u5427\u5e10\u6237   \u4e09\u6b21\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3 \u5931\u8d25\u4e4b\u540e\u5907\u4efd\u5b9a\u5355");
                OrdersSeriousExcetpionDto serious = new OrdersSeriousExcetpionDto(true);
                serious.setDone(Integer.valueOf(0));
                serious.setStype("DuibaBackPayOrder");
                serious.setJson("{'orderId':" + order.getId() + "'money': " + order.getDuibaActualPrice() + "}");
                this.masterOrdersSeriousExceptionLogService.insert(serious);
                PayCenterLog.info("try again " + OrdersDto.try_again_count + " failed" + " call  duibaPayOrdersServiceClient.backpayOrder  exception developId" + order.getDeveloperId() + "  money:  " + order.getDuibaActualPrice() + "  ordersID : " + order.getId() + "  serioiusId: " + serious.getId(), (Throwable)result.getRpcException());
                String text = "developId: " + order.getDeveloperId() + "  money:  " + order.getDuibaActualPrice() + "  ordersID : " + order.getId() + "  serioiusId: " + serious.getId();
                text = text + "call duibaPayOrdersServiceClient.backpayOrder ";
                this.emailService.sendSeriousEmail4PayCenter("\u5411\u652f\u4ed8\u4e2d\u5fc3\u53d1\u9001\u8fd8\u94b1\u64cd\u4f5c\u5f02\u5e38\uff0c\u7b49\u5f85\u5904\u7406", text);
                this.remoteDuibaDeduceDetailService.updateDuibaDeduceDetail(detail.getId(), "unknow");
                throw new RuntimeException("\u5411\u652f\u4ed8\u4e2d\u5fc3\u53d1\u9001\u8fd8\u94b1\u64cd\u4f5c\u5f02\u5e38\uff0c\u7b49\u5f85\u5904\u7406");
            }
        }
        if (result.isOpSuccess()) {
            if (!((PayOrdersResult)result.getResult()).isBizSuccess()) {
                PayCenterLog.info("call duibaPayOrdersServiceClient.backpayOrder   is failed ");
                order.setDuibaPayStatus("payback");
                this.masterOrdersPayCenterExceptionService.insert(order, "payback  \u5151\u5427\u5e10\u6237  \u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u8fd8\u6b3e\uff0c\u652f\u4ed8\u4e2d\u5fc3\u53cd\u9988\u5931\u8d25");
                this.remoteDuibaDeduceDetailService.updateDuibaDeduceDetail(detail.getId(), "failed");
                new RuntimeException("\u8fd8\u6b3e\u5931\u8d25   ");
            } else {
                this.remoteDuibaDeduceDetailService.updateDuibaDeduceDetail(detail.getId(), " payback");
            }
        }
    }

    private void callbackPayOrders(OrdersDto order) {
        PayOrdersExtraParams p = new PayOrdersExtraParams();
        p.setAppId(order.getAppId());
        p.setCredits(order.getCredits());
        p.setMemo("\u5151\u6362\u5931\u8d25\uff0c\u8fd4\u8fd8\u8d44\u91d1");
        RpcResult result = this.payOrdersServiceClient.backpayOrder(order.getDeveloperId(), order.getId(), Long.valueOf(order.getActualPrice().intValue()), p);
        if (!result.isOpSuccess()) {
            PayCenterLog.info("call payOrdersServiceClient.backpayOrder  exception developId " + order.getDeveloperId() + "  " + result.getRpcException());
            for (int i = 0; i < OrdersDto.try_again_count; ++i) {
                Uninterruptibles.sleepUninterruptibly((long)OrdersDto.try_again_interval_time.intValue(), (TimeUnit)TimeUnit.MILLISECONDS);
                result = this.payOrdersServiceClient.backpayOrder(order.getDeveloperId(), order.getId(), Long.valueOf(order.getActualPrice().intValue()), p);
                if (result.isOpSuccess()) break;
                PayCenterLog.info("call payOrdersServiceClient.backpayOrder  exception developId" + order.getDeveloperId() + " try again " + i);
            }
            if (!result.isOpSuccess()) {
                this.masterOrdersPayCenterExceptionService.insert(order, "payback \u4e09\u6b21\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3 \u5931\u8d25\u4e4b\u540e\u5907\u4efd\u5b9a\u5355");
                OrdersSeriousExcetpionDto serious = new OrdersSeriousExcetpionDto(true);
                serious.setDone(Integer.valueOf(0));
                serious.setStype("backPayOrder");
                serious.setJson("{'orderId':" + order.getId() + "'money':" + order.getActualPrice() + "}");
                this.masterOrdersSeriousExceptionLogService.insert(serious);
                PayCenterLog.info("try again " + OrdersDto.try_again_count + " failed" + " call payOrdersServiceClient.backpayOrder  exception developId" + order.getDeveloperId() + "  money:  " + order.getActualPrice() + "  ordersID : " + order.getId() + "  serioiusId: " + serious.getId());
                String text = "developId: " + order.getDeveloperId() + "  money:  " + order.getActualPrice() + "  ordersID : " + order.getId() + "  serioiusId: " + serious.getId();
                text = text + "call payOrdersServiceClient.backpayOrder";
                this.emailService.sendSeriousEmail4PayCenter("\u5411\u652f\u4ed8\u4e2d\u5fc3\u53d1\u9001\u8fd8\u94b1\u64cd\u4f5c\u5f02\u5e38\uff0c\u7b49\u5f85\u5904\u7406", text);
                throw new RuntimeException("\u5411\u652f\u4ed8\u4e2d\u5fc3\u53d1\u9001\u8fd8\u94b1\u64cd\u4f5c\u5f02\u5e38\uff0c\u7b49\u5f85\u5904\u7406");
            }
        }
        if (result.isOpSuccess() && !((PayOrdersResult)result.getResult()).isBizSuccess()) {
            PayCenterLog.info("call payOrdersServiceClient.backpayOrder is failed ");
            order.setPayStatus("payback");
            this.masterOrdersPayCenterExceptionService.insert(order, "payback  \u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u8fd8\u6b3e\uff0c\u652f\u4ed8\u4e2d\u5fc3\u53cd\u9988\u5931\u8d25");
            new RuntimeException("\u8fd8\u6b3e\u5931\u8d25   ");
        }
    }

    @Override
    public boolean doForceConsumeSuccess(Long orderId, Long consumerId, String error4admin) throws Exception {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
            if ("success".equals(order.getStatus()) || "fail".equals(order.getStatus())) {
                status.setRollbackOnly();
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
            int ret = this.ordersStatusChangeService.doForceConsumeSuccess(order.getId(), consumerId, error4admin);
            if (ret == 0) {
                status.setRollbackOnly();
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
        }
        catch (Exception e) {
            status.setRollbackOnly();
            throw e;
        }
        finally {
            this.ordersConsumerTransactionManager.commit(status);
        }
        return true;
    }

    @Override
    public boolean doUpdateAllowInputUsed(Long orderId, Long consumerId, SupplierOrderDto supplierOrder, String bizParams, String brief) throws Exception {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
            if ("success".equals(order.getStatus()) || "fail".equals(order.getStatus()) || !order.getAllowInputAgain().booleanValue()) {
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
            this.supplierOrdersService.insert(supplierOrder);
            int ret = this.ordersStatusChangeService.doUpdateAllowInputUsed(order.getId(), consumerId, supplierOrder.getId(), bizParams, brief);
            if (ret == 0) {
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
        }
        catch (Exception e1) {
            status.setRollbackOnly();
            throw e1;
        }
        finally {
            this.ordersConsumerTransactionManager.commit(status);
        }
        return true;
    }

    @Override
    public boolean doUpdateAllowInputUsed4Object(Long orderId, Long consumerId, SupplierOrderDto supplierOrder, String bizParams) throws Exception {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
            if ("success".equals(order.getStatus()) || "fail".equals(order.getStatus()) || !order.getAllowInputAgain().booleanValue()) {
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
            this.supplierOrdersService.insert(supplierOrder);
            int ret = this.ordersStatusChangeService.doUpdateAllowInputUsed4Object(order.getId(), consumerId, supplierOrder.getId(), bizParams);
            if (ret == 0) {
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
        }
        catch (Exception e1) {
            status.setRollbackOnly();
            throw e1;
        }
        finally {
            this.ordersConsumerTransactionManager.commit(status);
        }
        return true;
    }

    @Override
    public boolean doMakeConsumeSuccess(Long orderId, Long consumerId) throws Exception {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
            if (!"create".equals(order.getStatus())) {
                status.setRollbackOnly();
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
            int ret = this.ordersStatusChangeService.doMakeConsumeSuccess(order.getId(), consumerId);
            if (ret == 0) {
                status.setRollbackOnly();
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
        }
        catch (Exception e) {
            status.setRollbackOnly();
            throw e;
        }
        finally {
            this.ordersConsumerTransactionManager.commit(status);
        }
        return true;
    }

    @Override
    public boolean doMakeConsumeFail(Long orderId, Long consumerId, Integer failType, String error4consumer, String error4developer, String error4admin) throws Exception {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
            if (!"create".equals(order.getStatus())) {
                status.setRollbackOnly();
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
            int ret = this.ordersStatusChangeService.doMakeConsumeFail(order.getId(), consumerId, failType, error4consumer, error4developer, error4admin);
            if (ret == 0) {
                status.setRollbackOnly();
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
            }
        }
        catch (Exception e) {
            status.setRollbackOnly();
            throw e;
        }
        finally {
            this.ordersConsumerTransactionManager.commit(status);
        }
        return true;
    }

    private DuibaDeduceDetailDto genDuibaDeduceDetail(OrdersDto order) {
        DuibaDeduceDetailDto detail = new DuibaDeduceDetailDto();
        detail.setOperationStatus("create");
        detail.setAppId(order.getAppId());
        if (!Objects.equal(null, (Object)order.getRelationId())) {
            OperatingActivityDto ado = this.remoteOperatingActivityServiceNew.find(order.getRelationId());
            detail.setActivityId(ado.getActivityId());
            detail.setActivityTitle(ado.getTitle());
        }
        AppDO app = this.remoteAppService.find(order.getAppId());
        detail.setAppName(app.getName());
        detail.setActivityType(String.valueOf(order.getRelationType()));
        detail.setDevelopId(order.getDeveloperId());
        detail.setOrderNo(order.getOrderNum());
        detail.setOrderId(order.getId().longValue());
        detail.setOperationMoney(Double.valueOf(Double.parseDouble(order.getDuibaActualPrice() + "")));
        detail.setMemo("\u8bf7\u6c42\u652f\u4ed8 \u5b9a\u5355");
        detail.setOperationType("payback");
        this.remoteDuibaDeduceDetailService.insert(detail);
        return detail;
    }

    @Override
    public boolean doAmbPayBack(Long orderId, Long consumerId) throws Exception {
        block7: {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
            try {
                OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                if ("after_send".equals(order.getStatus()) && "pay_success".equals(order.getConsumerPayStatus())) {
                    int ret = this.ordersStatusChangeService.doAmbConsumerPayStatusPayBack(orderId, consumerId);
                    if (ret == 0) {
                        throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c");
                    }
                    break block7;
                }
                throw new Exception("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c");
            }
            catch (Exception e1) {
                status.setRollbackOnly();
                throw e1;
            }
            finally {
                this.ordersConsumerTransactionManager.commit(status);
            }
        }
        return true;
    }
}

