/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.impl;

import cn.com.duiba.order.center.api.dto.MemLockDto;
import cn.com.duiba.order.center.biz.bo.QuantityLimitService;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.domain.vo.PriceDegree;
import cn.com.duiba.service.item.domain.dataobject.ItemLimitDO;
import cn.com.duiba.service.item.remoteservice.RemoteItemLimitService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuantityLimitServiceImpl
implements QuantityLimitService {
    private static Logger log = LoggerFactory.getLogger(QuantityLimitService.class);
    private final String ITEM_NAMESPACE = "itemcache";
    private final String APPITEM_NAMESPACE = "appitemcache";
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private RemoteItemLimitService remoteItemLimitService;

    @Override
    public Integer getQuantityLimitItemRemaining(ItemKey itemKey) {
        if (!this.isQuantityLimitItem(itemKey).booleanValue()) {
            return null;
        }
        try {
            String key = this.getKey(itemKey);
            Integer appItemCounter = (Integer)this.cacheClient.get(key);
            if (appItemCounter == null) {
                int exp = Math.min(DateUtils.getToTomorrowSeconds(), 3600);
                Integer countNum = 0;
                try {
                    countNum = this.countOrder(itemKey);
                }
                catch (Exception e) {
                    exp = 600;
                    countNum = new Integer(0);
                    log.error("count\u5f02\u5e38", (Throwable)e);
                }
                this.cacheClient.set(key, (Object)countNum, exp);
                appItemCounter = countNum;
            }
            Integer limit = this.getLimit(itemKey);
            Integer remaining = 0;
            if (appItemCounter < limit) {
                remaining = limit - appItemCounter;
            }
            return remaining;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u9650\u91cf\u5269\u4f59\u5e93\u5b58\u5f02\u5e38", (Throwable)e);
            return 0;
        }
    }

    @Override
    public Boolean deleteCounterByItemkey(ItemKey itemKey) throws Exception {
        String key = this.getKey(itemKey);
        boolean result = false;
        try {
            this.cacheClient.remove(key);
            result = true;
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u9650\u91cf\u5e93\u5b58\u6807\u8bb0\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return result;
    }

    @Override
    public Boolean addCounter(ItemKey itemKey) {
        if (!this.isQuantityLimitItem(itemKey).booleanValue()) {
            return null;
        }
        try {
            boolean result;
            String key = this.getKey(itemKey);
            Integer limit = this.getLimit(itemKey);
            Integer state = this.setByCas(key, limit, 1);
            boolean bl = result = state == 0;
            if (!result && state == 2) {
                Integer countNum = this.countOrder(itemKey);
                this.cacheClient.set(key, (Object)countNum, DateUtils.getToTomorrowSeconds());
                state = this.setByCas(key, limit, 1);
                result = state == 0;
            }
            return result;
        }
        catch (Exception e) {
            log.error("\u9650\u91cf\u5e93\u5b58\u5546\u54c1\u52a01\u5f02\u5e38\uff1a", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean chargeMode(String chargeMode) {
        if ("hdtool".equals(chargeMode)) {
            return false;
        }
        if ("singlelottery".equals(chargeMode)) {
            return false;
        }
        if ("turntable".equals(chargeMode)) {
            return false;
        }
        if ("manuallottery".equals(chargeMode)) {
            return false;
        }
        if ("game".equals(chargeMode)) {
            return false;
        }
        if ("seckill".equals(chargeMode)) {
            return false;
        }
        if ("ngame".equals(chargeMode)) {
            return false;
        }
        if ("guess".equals(chargeMode)) {
            return false;
        }
        return !"activity".equals(chargeMode);
    }

    @Override
    public Boolean subtractCounter(ItemKey itemKey) throws Exception {
        boolean result;
        if (!this.isQuantityLimitItem(itemKey).booleanValue()) {
            return null;
        }
        String key = this.getKey(itemKey);
        Integer state = this.setByCas(key, 0, -1);
        boolean bl = result = state == 0;
        if (!result && state == 2) {
            result = this.deleteCounterByItemkey(itemKey);
        }
        return result;
    }

    private Integer setByCas(String key, int limit, int type) {
        Integer result = null;
        try {
            Integer last = (Integer)this.cacheClient.get(key);
            if (last == null) {
                result = 2;
                return result;
            }
            if (type > 0) {
                int nextValue = last + 1;
                if (nextValue > limit) {
                    result = 3;
                } else {
                    this.cacheClient.incr(key, 1L, (long)DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
                    result = 0;
                }
            } else if (type < 0) {
                int nextValue = last - 1;
                if (nextValue < limit) {
                    result = 3;
                } else {
                    this.cacheClient.decr(key, 1L, (long)DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
                    result = 0;
                }
            } else {
                result = 4;
            }
        }
        catch (Exception e) {
            result = 5;
            log.error("\u66f4\u65b0\u7f13\u5b58\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    @Override
    public Boolean isQuantityLimitItem(ItemKey itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().isOpTypeItem(1);
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                return true;
            }
            if (itemKey.getItem().isOpTypeItem(1)) {
                return true;
            }
        } else if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().isOpTypeAppItem(1);
        }
        return false;
    }

    @Override
    public Boolean isLimit(ItemKey itemKey) {
        block13: {
            block14: {
                block12: {
                    if (this.isQuantityLimitItem(itemKey).booleanValue()) {
                        return true;
                    }
                    if (!itemKey.isItemMode()) break block12;
                    if (itemKey.getItem().getLimitCount() != null) {
                        return true;
                    }
                    break block13;
                }
                if (!itemKey.isDuibaAppItemMode()) break block14;
                if (itemKey.getAppItem().getLimitCount() != null) {
                    return true;
                }
                if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                    return true;
                }
                if (StringUtils.isNotEmpty((String)itemKey.getAppItem().getCustomPrice())) {
                    PriceDegree pd = new PriceDegree(itemKey.getAppItem().getCustomPrice());
                    Map map = pd.getCustomDegree();
                    for (String key : map.keySet()) {
                        Map dmap = (Map)map.get(key);
                        String limitCount = dmap == null ? null : (String)dmap.get("limitCount");
                        if (!StringUtils.isNotEmpty((String)limitCount) || Integer.valueOf(limitCount) <= 0) continue;
                        return true;
                    }
                } else if (itemKey.getItem().getLimitCount() != null) {
                    return true;
                }
                break block13;
            }
            if (!itemKey.isSelfAppItemMode()) break block13;
            if (itemKey.getAppItem().getLimitCount() != null) {
                return true;
            }
            if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                return true;
            }
            if (StringUtils.isNotEmpty((String)itemKey.getAppItem().getCustomPrice())) {
                PriceDegree pd = new PriceDegree(itemKey.getAppItem().getCustomPrice());
                Map map = pd.getCustomDegree();
                for (String key : map.keySet()) {
                    Map dmap = (Map)map.get(key);
                    String limitCount = dmap == null ? null : (String)dmap.get("limitCount");
                    if (!StringUtils.isNotEmpty((String)limitCount) || Integer.valueOf(limitCount) <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getKey(ItemKey itemKey) throws Exception {
        String key = null;
        if (itemKey.isItemMode()) {
            key = "itemcache" + itemKey.getItem().getId();
        } else if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getItem().isOpTypeItem(1)) {
                key = "itemcache" + itemKey.getItem().getId();
            } else if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                key = "appitemcache" + itemKey.getAppItem().getId();
            }
        } else if (itemKey.isSelfAppItemMode()) {
            key = "appitemcache" + itemKey.getAppItem().getId();
        }
        return key;
    }

    @Override
    public Integer countOrder(ItemKey itemKey) throws Exception {
        return this.countItemLimit(itemKey);
    }

    private Integer countItemLimit(ItemKey itemKey) throws Exception {
        String key = null;
        if (itemKey.isItemMode()) {
            key = ItemLimitDO.getItemKey((Long)itemKey.getItem().getId(), null);
        } else if (itemKey.isDuibaAppItemMode()) {
            key = ItemLimitDO.getItemKey((Long)itemKey.getItem().getId(), (Long)itemKey.getAppItem().getId());
        } else if (itemKey.isSelfAppItemMode()) {
            key = ItemLimitDO.getItemKey(null, (Long)itemKey.getAppItem().getId());
        }
        return this.remoteItemLimitService.countByItemKeyAndGmtCreate(key, DateUtils.getDayDate((Date)new Date()));
    }

    @Override
    public Integer getLimit(ItemKey itemKey) {
        Integer limit = null;
        if (itemKey.isItemMode()) {
            limit = itemKey.getItem().getLimitEverydayQuantity();
        } else if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getItem().isOpTypeItem(1)) {
                limit = itemKey.getItem().getLimitEverydayQuantity();
            } else if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                limit = itemKey.getAppItem().getLimitEverydayQuantity();
            }
        } else if (itemKey.isSelfAppItemMode()) {
            limit = itemKey.getAppItem().getLimitEverydayQuantity();
        }
        return limit;
    }

    @Override
    public MemLockDto lockPrize(Long operatingActivityId, Long prizeId) {
        MemLockDto memLock = new MemLockDto();
        String value = String.valueOf(System.currentTimeMillis());
        boolean locked = false;
        try {
            String key = "110-" + operatingActivityId + "-" + prizeId;
            Object lock = this.cacheClient.get(key);
            memLock.setTicket(value);
            if (lock == null) {
                locked = true;
                this.cacheClient.set(key, (Object)value, 30);
            }
        }
        catch (Exception e) {
            log.error("lockPrize", (Throwable)e);
        }
        memLock.setLocked(locked);
        memLock.setTicket(value);
        return memLock;
    }

    @Override
    public void unlockPrize(Long operatingActivityId, Long prizeId, String ticket) {
        try {
            String key = "110-" + operatingActivityId + "-" + prizeId;
            String lock = (String)this.cacheClient.get(key);
            if (lock != null) {
                this.cacheClient.remove(key);
            }
        }
        catch (Exception e) {
            log.error("unlockPrize", (Throwable)e);
        }
    }
}

