/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.ordercreate;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.order.center.api.dto.ChomeMarqueeDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.DataToolService;
import cn.com.duiba.order.center.biz.service.orders.mirror.OrdersMirrorBussinessService;
import cn.com.duiba.order.center.biz.tool.StringTool;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ConsumerExtraDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChomeMarqueeService {
    @Autowired
    private MemcachedClient memcachedClient;
    @Autowired
    private DataToolService dataToolService;
    @Autowired
    private RemotePreStockService remotePreStockService;
    @Autowired
    private OrdersMirrorBussinessService ordersMirrorBussinessService;
    @Autowired
    private RemoteAppService remoteAppService;

    private String getAppKey(Long appId) {
        return "112-" + appId;
    }

    public String getAppMarqueeOrderIds(Long appId) {
        return (String)this.memcachedClient.get(this.getAppKey(appId));
    }

    public void addAppMarqueeOrderIds(Long appId, Long orderId) {
        try {
            if (this.setByCas(appId, orderId) == 2) {
                this.memcachedClient.add(this.getAppKey(appId), 2592000, (Object)(orderId + ""));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Integer setByCas(Long appId, Long orderId) {
        Integer result = null;
        boolean loop = true;
        try {
            int loopNum = 0;
            while (loop) {
                if (loopNum >= 10) {
                    loop = false;
                    result = 1;
                    break;
                }
                CASValue last = this.memcachedClient.gets(this.getAppKey(appId));
                if (last == null) {
                    loop = false;
                    result = 2;
                    break;
                }
                if (orderId == null) {
                    loop = false;
                    result = 4;
                    break;
                }
                String oldValue = (String)last.getValue();
                String[] oldValueArray = oldValue.split(",");
                String newValue = orderId + "," + oldValue;
                if (oldValueArray.length >= 30) {
                    newValue = newValue.substring(0, newValue.lastIndexOf(44, newValue.length()));
                }
                CASResponse caseResponse = this.memcachedClient.cas(this.getAppKey(appId), last.getCas(), (Object)newValue);
                switch (caseResponse) {
                    case OK: {
                        loop = false;
                        result = 0;
                        break;
                    }
                    case NOT_FOUND: {
                        loop = false;
                        result = 2;
                        break;
                    }
                    case EXISTS: {
                        loop = true;
                    }
                }
                ++loopNum;
            }
        }
        catch (Exception e) {
            result = 5;
        }
        return result;
    }

    public List<ChomeMarqueeDto> getChomeMarqueeVOs(Long appId) {
        ItemDO item;
        ArrayList<ChomeMarqueeDto> result = new ArrayList<ChomeMarqueeDto>();
        AppDO app = this.remoteAppService.find(appId);
        String oidStr = this.getAppMarqueeOrderIds(appId);
        List<Long> oidList = StringTool.getLongListByStr(oidStr);
        List<OrdersDto> orders = null;
        orders = oidList.size() > 0 ? this.ordersMirrorBussinessService.doFindAppOrderRuning(appId, oidList, oidStr) : Collections.emptyList();
        Map<Long, AppItemDO> appItemMap = this.dataToolService.getAppItemMapByOrderList(orders);
        Map<Long, ItemDO> itemMap = this.dataToolService.getItemMapByOrderList(orders);
        Map<Long, ConsumerExtraDO> ceMap = this.dataToolService.getConsumerExtraMapByOrderList(orders);
        Map<Long, OperatingActivityDto> oaMap = this.dataToolService.getOperatingActivityMapByOrderList(orders);
        ArrayList<OrdersDto> ordersNew = new ArrayList<OrdersDto>();
        for (OrdersDto o : orders) {
            AppItemDO appItem;
            if (o.getItemId() != null) {
                OperatingActivityDto activity;
                item = itemMap.get(o.getItemId());
                if (item == null || item.getDeleted().booleanValue() || !item.getEnable().booleanValue()) continue;
                if (item.getAutoRecommend().booleanValue()) {
                    ordersNew.add(o);
                    continue;
                }
                if (item.isOpTypeItem(2) && (1 != o.getRelationType() || 2 != (activity = oaMap.get(o.getRelationId())).getStatus())) continue;
            }
            if (o.getAppItemId() != null && ((appItem = appItemMap.get(o.getAppItemId())) == null || appItem.getDeleted().booleanValue() || "off".equals(appItem.getStatus()) || "expired".equals(appItem.getSubStatus()))) continue;
            ordersNew.add(o);
        }
        for (OrdersDto o : ordersNew) {
            item = itemMap.get(o.getItemId());
            AppItemDO appItem = appItemMap.get(o.getAppItemId());
            ItemKey itemKey = ItemKey.generate((ItemDO)item, (AppItemDO)appItem, (AppDO)app);
            ItemKeyVO keyVO = new ItemKeyVO(itemKey);
            ConsumerExtraDO consumerExtra = ceMap.get(o.getConsumerId());
            ChomeMarqueeDto chVo = new ChomeMarqueeDto(keyVO, consumerExtra);
            chVo.setCredits(this.remotePreStockService.calculateCreditsByItemKeyAndDegree(itemKey, null) + "");
            result.add(new ChomeMarqueeDto(keyVO, consumerExtra));
        }
        return result;
    }
}

