/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.ordercreate;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.supplier_order.RemoteSupplierOrdersService;
import cn.com.duiba.order.center.biz.bo.ConsumerFootprintService;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.bo.OrdersInsertManager;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.FlowworkEngine;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class OrderCreateBaseBo {
    @Autowired
    protected RemoteConsumerService remoteConsumerService;
    @Autowired
    protected RemoteItemKeyService remoteItemKeyService;
    @Autowired
    protected ConsumerFootprintService consumerFootprintService;
    @Autowired
    private OrdersInsertManager ordersInsertManager;
    @Autowired
    private OrderReadManagerBo orderReadManagerBo;
    @Autowired
    protected RemoteSupplierOrdersService remoteSupplierOrdersService;
    @Autowired
    protected MessageService messageService;
    @Autowired
    protected TopicConstant topicConstant;
    @Autowired
    protected FlowworkEngine flowworkEngine;

    public void consumeCreditsLocal(long credits, long consumerId) {
        if (credits > 0L) {
            this.remoteConsumerService.decrementCredits(Long.valueOf(consumerId), Long.valueOf(credits));
        }
    }

    protected OrdersDto takePcgOrder(OrdersDto order) throws Exception {
        if (order.getId() != null) {
            throw new Exception("\u8ba2\u5355\u5df2\u7ecf\u6709\u4e3b\u952eid\uff0c\u65e0\u6cd5\u521b\u5efa");
        }
        if (order.getActualPrice() != 0 || order.getDuibaActualPrice() != 0 || order.getConsumerPayPrice() != 0L) {
            if (order.getActualPrice() == 0 && order.getDuibaActualPrice() > 0 && order.getConsumerPayPrice() == 0L) {
                throw new Exception("\u6682\u4e0d\u652f\u6301");
            }
            if (order.getActualPrice() > 0 && order.getDuibaActualPrice() == 0 && order.getConsumerPayPrice() == 0L) {
                throw new Exception("\u6682\u4e0d\u652f\u6301");
            }
            if (order.getActualPrice() == 0 && order.getDuibaActualPrice() == 0 && order.getConsumerPayPrice() > 0L) {
                throw new Exception("\u6682\u4e0d\u652f\u6301");
            }
            throw new Exception("\u6263\u8d39\u4ef7\u683c\u4e0d\u6b63\u786e");
        }
        order = this.ordersInsertManager.takeOrderFree(order);
        if (order.getId() != null) {
            if ((order = this.orderReadManagerBo.find(order.getId(), order.getConsumerId())) == null) {
                throw new Exception("\u8ba2\u5355\u6ca1\u6709\u521b\u5efa");
            }
            return order;
        }
        throw new Exception("\u8ba2\u5355\u6ca1\u6709\u521b\u5efa");
    }

    protected OrdersDto takeOrderIntimes(OrdersDto order, ItemKey key, int notimes) throws Exception {
        if (order.getId() != null) {
            throw new Exception("\u8ba2\u5355\u5df2\u7ecf\u6709\u4e3b\u952eid\uff0c\u65e0\u6cd5\u521b\u5efa");
        }
        if (order.getActualPrice() == 0 && order.getDuibaActualPrice() == 0 && order.getConsumerPayPrice() == 0L) {
            order = this.ordersInsertManager.takeOrderFree(order);
        } else if (order.getActualPrice() == 0 && order.getDuibaActualPrice() > 0 && order.getConsumerPayPrice() == 0L) {
            order = this.ordersInsertManager.duibaTakeOrderInFee(order, key);
        } else if (order.getActualPrice() > 0 && order.getDuibaActualPrice() == 0 && order.getConsumerPayPrice() == 0L) {
            order = this.ordersInsertManager.takeOrderInFee(order, key);
        } else if (order.getActualPrice() == 0 && order.getDuibaActualPrice() == 0 && order.getConsumerPayPrice() > 0L) {
            order = this.ordersInsertManager.ambTakeOrderInFee(order, key);
        } else {
            throw new Exception("\u6263\u8d39\u4ef7\u683c\u4e0d\u6b63\u786e");
        }
        if (order.getId() != null) {
            if ((order = this.orderReadManagerBo.find(order.getId(), order.getConsumerId())) == null) {
                throw new Exception("\u8ba2\u5355\u6ca1\u6709\u521b\u5efa");
            }
            return order;
        }
        throw new Exception("\u8ba2\u5355\u6ca1\u6709\u521b\u5efa");
    }

    protected boolean canUseByAmb(OrdersDto order) {
        return "mall".equals(order.getChargeMode()) || "seckill".equals(order.getChargeMode());
    }

    public boolean isOverThreshold(OrdersDto order, AppDO app) {
        if ("api".equals(order.getChargeMode())) {
            return false;
        }
        if ("turntable".equals(order.getChargeMode())) {
            return false;
        }
        if (app.getAuditPricePerConsumer() == null) {
            return false;
        }
        return order.getActualPrice() >= app.getAuditPricePerConsumer() && order.getActualPrice() > 0;
    }
}

