/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.ordercreate.impl;

import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.crecord.ConsumerExchangeRecordDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.crecord.RemoteConsumerExchangeRecordService;
import cn.com.duiba.order.center.biz.bo.ActualPriceCalculateBo;
import cn.com.duiba.order.center.biz.bo.OrderToolBo;
import cn.com.duiba.order.center.biz.bo.ordercreate.CouponOrderCreateBo;
import cn.com.duiba.order.center.biz.bo.ordercreate.OrderCreateBaseBo;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsDispatcher;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginEventsDispatcher;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersTextChangeService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.CreateFlowWorker;
import cn.com.duiba.order.center.biz.tool.TimeProfile;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.dataobject.CouponBatchDO;
import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.remoteservice.RemoteCouponBatchService;
import cn.com.duiba.service.item.remoteservice.RemoteCouponService;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import cn.com.duiba.service.tools.DuibaEvent;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponOrderCreateBoImpl
extends OrderCreateBaseBo
implements CouponOrderCreateBo {
    private static Logger log = LoggerFactory.getLogger(CouponOrderCreateBoImpl.class);
    @Resource
    private RemotePreStockService remotePreStockService;
    @Autowired
    private ActualPriceCalculateBo actualPriceCalculateBo;
    @Autowired
    private OrderToolBo orderToolBo;
    @Autowired
    private RemoteCouponBatchService remoteCouponBatchService;
    @Autowired
    private RemoteCouponService remoteCouponService;
    @Autowired
    private RemoteConsumerExchangeRecordService remoteConsumerExchangeRecordService;
    @Autowired
    private CreateFlowWorker createFlowWorker;
    @Autowired
    private OrdersTextChangeService ordersTextChangeService;
    @Autowired
    private DuibaEventsDispatcher duibaEventsDispatcher;

    @Override
    public OrdersDto createCouponOrder(DuibaEvent.RequestParams params, ConsumerDO consumer, ItemKey key, String chargeMode, String developerBizId, Long couponId, Long relationId, Integer relationType) throws Exception {
        Integer facePrice;
        Integer actualPrice = this.actualPriceCalculateBo.calculateNormalActualPrice(key);
        OrdersDto order = new OrdersDto(true);
        order.setIp(params.getIp());
        order.setChargeMode(chargeMode);
        order.setDeveloperBizId(developerBizId);
        order.setConsumerId(consumer.getId());
        order.setAppId(key.getApp().getId());
        order.setDeveloperId(key.getApp().getDeveloperId());
        order.setCouponId(couponId);
        order.setQuantity(Integer.valueOf(1));
        order.setStatus("create");
        order.setType("coupon");
        order.setActualPrice(actualPrice);
        order.setRelationType(relationType);
        order.setRelationId(relationId);
        if ("api".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("mall".equals(chargeMode)) {
            Long credits = this.remotePreStockService.calculateCreditsByItemKeyAndDegree(key, null);
            order.setCredits(credits);
            if (key.isSelfAppItemMode()) {
                AppItemDO appItem = key.getAppItem();
                if (appItem.isOpTypeAppItem(4)) {
                    order.setAuditStatus("wait");
                }
            } else if (this.orderToolBo.isOverThreshold(order, key.getApp())) {
                order.setAuditStatus("wait");
            }
        } else if ("turntable".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("singlelottery".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("hdtool".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("game".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("question".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("quizz".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("ngame".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("guess".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("activity".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u6b64\u6765\u6e90");
        }
        if (key.getItem() != null) {
            order.setItemId(key.getItem().getId());
        }
        if (key.getAppItem() != null) {
            order.setAppItemId(key.getAppItem().getId());
        }
        if (key.isItemMode()) {
            order.setBrief(key.getItem().getName());
            facePrice = key.getItem().getFacePrice();
            if (facePrice == null) {
                facePrice = 0;
            }
            order.setFacePrice(facePrice);
        } else if (key.isSelfAppItemMode()) {
            facePrice = key.getAppItem().getFacePrice();
            if (facePrice == null) {
                facePrice = 0;
            }
            order.setFacePrice(facePrice);
            order.setBrief(key.getAppItem().getTitle());
        } else if (key.isDuibaAppItemMode()) {
            facePrice = key.getItem().getFacePrice();
            if (facePrice == null) {
                facePrice = 0;
            }
            order.setFacePrice(facePrice);
            if (StringUtils.isNotBlank((String)key.getAppItem().getTitle())) {
                order.setBrief(key.getAppItem().getTitle());
            } else {
                order.setBrief(key.getItem().getName());
            }
        } else {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u6b64\u7c7b\u578b");
        }
        if (order.getActualPrice() > 0) {
            order.setPayStatus("wait_pay");
        } else {
            order.setPayStatus("none");
        }
        if (order.getDuibaActualPrice() > 0) {
            order.setDuibaPayStatus("wait_pay");
            throw new Exception("\u975e\u5151\u5427\u4ed8\u8d39\u5546\u54c1");
        }
        order.setDuibaPayStatus("none");
        if (order.getConsumerPayPrice() > 0L) {
            order.setSubOrderType("amb");
            order.setConsumerPayStatus("wait_pay");
            throw new Exception("\u975e\u52a0\u94b1\u8d2d\u5546\u54c1");
        }
        order.setConsumerPayStatus("none");
        this.takeOrderIntimes(order, key, 3);
        Long appId = null;
        Long appItemId = null;
        Long itemId = null;
        if (key.getApp() != null) {
            appId = key.getApp().getId();
        }
        if (key.getAppItem() != null) {
            appItemId = key.getAppItem().getId();
        }
        if (key.getItem() != null) {
            itemId = key.getItem().getId();
        }
        OrderCreateContext orderCreateContext = new OrderCreateContext(params, actualPrice, itemId, appItemId, appId, consumer.getId(), order.getId(), chargeMode, null);
        orderCreateContext.addParam("couponId", (Object)couponId);
        this.messageService.sendMsg(this.topicConstant.getCouponOrderCreate(), JSONObject.toJSONString((Object)orderCreateContext));
        return order;
    }

    @Override
    public void asynCreate(DuibaEvent.RequestParams params, OrdersDto order, ConsumerDO consumer, String chargeMode, ItemKey key, Long couponId) throws Exception {
        try {
            OrdersPlugin.OrdersPluginContext context = new OrdersPlugin.OrdersPluginContext();
            context.setAttribute("orderNum", order.getOrderNum());
            try {
                TimeProfile.enter("takeOrderIntimes");
                DuibaPluginEventsDispatcher.get().triggerBeforeOrderCreate(key, consumer, chargeMode, params, context);
                Object obj = context.getAttribute("couponId");
                if (null != obj) {
                    couponId = (Long)obj;
                }
                order.setCouponId(couponId);
                if (order.getCouponId() == null) {
                    throw new Exception("\u83b7\u53d6\u4f18\u60e0\u52b5id\u5931\u8d25");
                }
                this.ordersTextChangeService.updateCouponId(order.getId(), order.getConsumerId(), order.getCouponId());
            }
            catch (Exception e) {
                DuibaPluginEventsDispatcher.get().triggerOnOrderCreateException(key, consumer, chargeMode, params, e, context);
                throw e;
            }
            finally {
                TimeProfile.release();
            }
            if ("mall".equals(chargeMode)) {
                CouponBatchDO batch;
                ConsumerExchangeRecordDto cer = new ConsumerExchangeRecordDto(true);
                cer.setConsumerId(consumer.getId());
                cer.setType(Integer.valueOf(1));
                cer.setOrderId(order.getId());
                CouponDO coupon = this.remoteCouponService.find(couponId);
                if (null != coupon && null != (batch = this.remoteCouponBatchService.find(coupon.getBatchId()))) {
                    cer.setOverDue(batch.getValidEndDate());
                }
                this.remoteConsumerExchangeRecordService.insert(cer);
            }
            if (order.getCredits() > 0L) {
                this.consumeCreditsLocal(order.getCredits(), consumer.getId());
            }
            DuibaPluginEventsDispatcher.get().triggerAfterOrderCreate(order, params, context);
            if ("unknown_pay".equals(order.getPayStatus()) || "unknown_pay".equals(order.getDuibaPayStatus())) {
                this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId());
            } else {
                this.createFlowWorker.makeCompleteByCreator(order.getId(), order.getConsumerId());
            }
            this.flowworkEngine.go(order.getId(), consumer.getId());
        }
        catch (StatusException e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), e.getMessage());
        }
        catch (Exception e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), "\u672a\u77e5\u9519\u8bef");
            log.error("asynCreate:", (Throwable)e);
        }
    }
}

