/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.ordercreate.impl;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.manual.AppManualLotteryDto;
import cn.com.duiba.activity.center.api.dto.manual.ManualLotteryOrderDto;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteOperatingActivityServiceNew;
import cn.com.duiba.activity.center.api.remoteservice.manual.RemoteManualOrderLotteryService;
import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.crecord.ConsumerExchangeRecordDto;
import cn.com.duiba.order.center.api.dto.orders.ObjectAddressDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.remoteservice.crecord.RemoteConsumerExchangeRecordService;
import cn.com.duiba.order.center.biz.bo.OrdersNormalUpdateManager;
import cn.com.duiba.order.center.biz.bo.amb.AmbExpressTemplateBo;
import cn.com.duiba.order.center.biz.bo.ordercreate.ObjectOrderCreateBo;
import cn.com.duiba.order.center.biz.bo.ordercreate.OrderCreateBaseBo;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsDispatcher;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginEventsDispatcher;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.CreateFlowWorker;
import cn.com.duiba.order.center.biz.service.supplier_order.SupplierProductsService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.remoteservice.RemoteAppManualLotteryService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import cn.com.duiba.service.tools.DuibaEvent;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ObjectOrderCreateBoImpl
extends OrderCreateBaseBo
implements ObjectOrderCreateBo {
    private static Logger log = LoggerFactory.getLogger(ObjectOrderCreateBoImpl.class);
    @Autowired
    private OrdersNormalUpdateManager ordersNormalUpdateManager;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private RemoteAppManualLotteryService remoteAppManualLotteryService;
    @Autowired
    private RemoteManualOrderLotteryService remoteManualOrderLotteryService;
    @Autowired
    private RemotePreStockService remotePreStockService;
    @Autowired
    private AmbExpressTemplateBo ambExpressTemplateBo;
    @Autowired
    private RemoteConsumerExchangeRecordService remoteConsumerExchangeRecordService;
    @Autowired
    private CreateFlowWorker createFlowWorker;
    @Autowired
    private SupplierProductsService supplierProductsService;
    @Autowired
    private RemoteOperatingActivityServiceNew remoteOperatingActivityServiceNew;
    @Autowired
    private DuibaEventsDispatcher duibaEventsDispatcher;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OrdersDto innerCreate(ObjectAddressDto address, ItemKey key, DuibaEvent.RequestParams params, ConsumerDO consumer, Integer tempActualPrice, Long appItemId, Long itemId, String chargeMode, String developerBizId, Long relationId, Integer relationType) throws Exception {
        Long exPrise;
        OrdersDto order = new OrdersDto(true);
        order.setChargeMode(chargeMode);
        order.setDeveloperBizId(developerBizId);
        order.setConsumerId(consumer.getId());
        order.setAppId(consumer.getAppId());
        order.setDeveloperId(key.getApp().getDeveloperId());
        if (key.getAppItem() != null) {
            order.setFacePrice(key.getAppItem().getFacePrice());
            if (StringUtils.isNotBlank((String)key.getAppItem().getTitle())) {
                order.setBrief("\u5151\u6362\u5b9e\u7269\uff1a" + key.getAppItem().getTitle());
            } else {
                order.setBrief("\u5151\u6362\u5b9e\u7269\uff1a" + key.getItem().getName());
            }
        } else {
            order.setFacePrice(key.getItem().getFacePrice());
            order.setBrief("\u5151\u6362\u5b9e\u7269\uff1a" + key.getItem().getName());
        }
        if (address.getAddrName() == null || address.getAddrPhone() == null || address.getAddrProvince() == null || address.getAddrCity() == null || address.getAddrDetail() == null) {
            throw new Exception("\u6536\u8d27\u5730\u5740\u4fe1\u606f\u4e0d\u8db3");
        }
        order.setBizParams(address.getAddrName() + ":" + address.getAddrPhone() + ":" + address.getAddrProvince() + ":" + address.getAddrCity() + ":" + (address.getAddrArea() == null ? "" : address.getAddrArea()) + ":" + address.getAddrDetail());
        long money = 0L;
        AppItemDO aItem = key.getAppItem();
        ItemDO item1 = key.getItem();
        if (null != item1 && aItem == null) {
            if (item1.isOpTypeItem(11)) {
                if (null != item1.getSalePrice()) {
                    money = item1.getSalePrice();
                    if (tempActualPrice > 0) {
                        if (money < tempActualPrice.longValue()) throw new Exception("\u52a0\u94b1\u8d2d\u91d1\u989d\u4e0d\u6b63\u786e\uff01");
                        tempActualPrice = 0;
                    }
                }
                if ("unity".equals(item1.getExpressType()) && null != item1.getExpressPrice()) {
                    money += item1.getExpressPrice().longValue();
                } else if ("template".equals(item1.getExpressType()) && null != item1.getExpressTemplateId() && null != (exPrise = this.ambExpressTemplateBo.matchExpressPrice(consumer.getId(), item1.getExpressTemplateId()))) {
                    money += exPrise.longValue();
                }
                if (money > 0L) {
                    if (!this.canUseByAmb(order)) throw new Exception("\u975e\u5151\u6362\u9879");
                    order.setConsumerPayPrice(Long.valueOf(money));
                    order.setConsumerPayStatus("wait_pay");
                }
            }
        } else if (null != aItem && null == item1) {
            if (aItem.isOpTypeAppItem(11)) {
                if (null != aItem.getSalePrice()) {
                    money = aItem.getSalePrice();
                }
                if ("unity".equals(aItem.getExpressType()) && null != aItem.getExpressPrice()) {
                    money += aItem.getExpressPrice().longValue();
                } else if ("template".equals(aItem.getExpressType()) && null != aItem.getExpressTemplateId() && null != (exPrise = this.ambExpressTemplateBo.matchExpressPrice(consumer.getId(), aItem.getExpressTemplateId()))) {
                    money += exPrise.longValue();
                }
                if (money > 0L) {
                    if (!this.canUseByAmb(order)) throw new Exception("\u975e\u5151\u6362\u9879");
                    order.setConsumerPayPrice(Long.valueOf(money));
                    order.setConsumerPayStatus("wait_pay");
                }
            }
        } else if (null != aItem && null != item1 && item1.isOpTypeItem(11)) {
            throw new Exception("\u5151\u5427\u52a0\u94b1\u8d2d\u5546\u54c1\u4e0d\u53ef\u4ee5   \u52a0\u5165\u5230\u5f00\u53d1\u8005\u5546\u54c1\u4e2d");
        }
        order.setActualPrice(tempActualPrice);
        order.setQuantity(Integer.valueOf(1));
        order.setStatus("create");
        order.setType("object");
        order.setRelationType(relationType);
        order.setRelationId(relationId);
        if ("api".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("mall".equals(chargeMode) || "seckill".equals(chargeMode)) {
            Long credits = this.remotePreStockService.calculateCreditsByItemKeyAndDegree(key, null);
            order.setCredits(credits);
            if (key.isSelfAppItemMode()) {
                AppItemDO appItem = key.getAppItem();
                if (appItem.isOpTypeAppItem(4)) {
                    order.setAuditStatus("wait");
                }
            } else if (this.isOverThreshold(order, key.getApp())) {
                order.setAuditStatus("wait");
            }
        } else if ("turntable".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("singlelottery".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("hdtool".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("game".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("question".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("quizz".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("ngame".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else if ("guess".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else {
            if (!"activity".equals(chargeMode)) throw new RuntimeException("\u672a\u77e5\u6765\u6e90\u7684\u8ba2\u5355");
            order.setCredits(Long.valueOf(0L));
        }
        if (key.getItem() != null) {
            order.setItemId(key.getItem().getId());
        }
        if (key.getAppItem() != null) {
            order.setAppItemId(key.getAppItem().getId());
        }
        if (order.getActualPrice() > 0) {
            order.setPayStatus("wait_pay");
        } else {
            order.setPayStatus("none");
        }
        if (order.getDuibaActualPrice() > 0) {
            order.setDuibaPayStatus("wait_pay");
            throw new Exception("\u975e\u5151\u5427\u4ed8\u8d39\u5546\u54c1");
        }
        order.setDuibaPayStatus("none");
        order.setIp(params.getIp());
        if (order.getConsumerPayPrice() > 0L) {
            order.setSubOrderType("amb");
            order.setConsumerPayStatus("wait_pay");
        } else {
            order.setConsumerPayStatus("none");
        }
        OrdersPlugin.OrdersPluginContext context = new OrdersPlugin.OrdersPluginContext();
        context.setAttribute("orderNum", order.getOrderNum());
        this.takeOrderIntimes(order, key, 3);
        Long appId = null;
        Long supplierProductId = null;
        if (key.getApp() != null) {
            appId = key.getApp().getId();
        }
        if (key.getAppItem() != null) {
            appItemId = key.getAppItem().getId();
        }
        if (key.getItem() != null) {
            itemId = key.getItem().getId();
        }
        OrderCreateContext orderCreateContext = new OrderCreateContext(params, tempActualPrice, itemId, appItemId, appId, consumer.getId(), order.getId(), chargeMode, supplierProductId);
        this.messageService.sendMsg(this.topicConstant.getObjectOrderCreate(), JSONObject.toJSONString((Object)orderCreateContext));
        return order;
    }

    @Override
    public void asynCreate(OrdersDto order, DuibaEvent.RequestParams params, ConsumerDO consumer, ItemKey key, String chargeMode) throws Exception {
        try {
            OrdersPlugin.OrdersPluginContext context = new OrdersPlugin.OrdersPluginContext();
            context.setAttribute("orderNum", order.getOrderNum());
            try {
                DuibaPluginEventsDispatcher.get().triggerBeforeOrderCreate(key, consumer, chargeMode, params, context);
            }
            catch (Exception e) {
                log.error("takeOrderIntimes  ", (Throwable)e);
                DuibaPluginEventsDispatcher.get().triggerOnOrderCreateException(key, consumer, chargeMode, params, e, context);
                throw e;
            }
            try {
                this.duibaEventsDispatcher.dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderCreate, order, params));
            }
            catch (Exception e) {
                log.error("className: " + this.getClass().getName() + "   method: innerCreate", (Throwable)e);
            }
            if ("mall".equals(chargeMode) || "seckill".equals(chargeMode)) {
                ConsumerExchangeRecordDto cer = new ConsumerExchangeRecordDto(true);
                cer.setConsumerId(consumer.getId());
                cer.setType(Integer.valueOf(1));
                cer.setOrderId(order.getId());
                this.remoteConsumerExchangeRecordService.insert(cer);
            }
            SupplierOrderDto supplierOrder = new SupplierOrderDto(true);
            supplierOrder.setOrderId(order.getId());
            supplierOrder.setStatus("create");
            SupplierProductDto sp = this.supplierProductsService.findBySupplier("developer-object");
            supplierOrder.setSupplierProductId(sp.getId());
            supplierOrder.setBizParams(order.getBizParams());
            supplierOrder.setDuibaOrderNum(order.getOrderNum());
            this.remoteSupplierOrdersService.insert(supplierOrder);
            order.setSupplierOrderId(supplierOrder.getId());
            OrdersDto o4u = new OrdersDto(order.getId());
            o4u.setSupplierOrderId(order.getSupplierOrderId());
            this.ordersNormalUpdateManager.updateSupplierOrderId(o4u.getId(), order.getConsumerId(), o4u.getSupplierOrderId());
            this.consumeCreditsLocal(order.getCredits(), consumer.getId());
            DuibaPluginEventsDispatcher.get().triggerAfterOrderCreate(order, params, context);
            if ("unknown_pay".equals(order.getPayStatus()) || "unknown_pay".equals(order.getDuibaPayStatus())) {
                this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId());
            } else {
                System.out.println("orderId:" + order.getId());
                System.out.println("consumerId" + order.getConsumerId());
                this.createFlowWorker.makeCompleteByCreator(order.getId(), order.getConsumerId());
            }
            this.flowworkEngine.go(order.getId(), consumer.getId());
        }
        catch (StatusException e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), e.getMessage());
        }
        catch (Exception e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), "\u672a\u77e5\u9519\u8bef");
            log.error("asynCreate:", (Throwable)e);
        }
    }

    @Override
    public OrdersDto innerManualLottery(DuibaEvent.RequestParams params, ConsumerExchangeRecordDto record) throws Exception {
        ManualLotteryOrderDto manualLotteryOrder = this.remoteManualOrderLotteryService.find(record.getRelationId());
        OrdersDto order = null;
        ConsumerDO consumer = this.remoteConsumerService.find(manualLotteryOrder.getConsumerId());
        AppDO app = this.remoteAppService.find(consumer.getAppId());
        order = new OrdersDto(true);
        order.setChargeMode("manuallottery");
        String developerBizId = manualLotteryOrder.getDeveloperBizId() == null ? null : manualLotteryOrder.getDeveloperBizId();
        order.setDeveloperBizId(developerBizId);
        order.setConsumerId(manualLotteryOrder.getConsumerId());
        order.setAppId(consumer.getAppId());
        order.setDeveloperId(app.getDeveloperId());
        OperatingActivityDto opActivity = this.remoteOperatingActivityServiceNew.find(manualLotteryOrder.getOperatingActivityId());
        AppManualLotteryDto appManualDO = this.remoteAppManualLotteryService.find(opActivity.getActivityId());
        order.setFacePrice(appManualDO.getMarketPrice() == null ? null : Integer.valueOf(appManualDO.getMarketPrice() * 100));
        order.setBrief(appManualDO.getTitle());
        order.setActualPrice(Integer.valueOf(0));
        if (StringUtils.isBlank((String)manualLotteryOrder.getPhone())) {
            throw new Exception("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String adrInfo = manualLotteryOrder.getAddressInfo();
        String bizParams = manualLotteryOrder.getPhone();
        if (StringUtils.isNotBlank((String)adrInfo)) {
            String[] addrInfo;
            for (String str : addrInfo = StringUtils.split((String)adrInfo, (String)":")) {
                if ("null".equals(str)) continue;
                bizParams = bizParams + ":" + str;
            }
        }
        order.setBizParams(bizParams);
        order.setQuantity(Integer.valueOf(1));
        order.setStatus("create");
        order.setType("object");
        order.setRelationId(manualLotteryOrder.getOperatingActivityId());
        order.setRelationType(Integer.valueOf(4));
        order.setCredits(Long.valueOf(0L));
        order.setIp(params.getIp());
        order.setAppItemId(opActivity.getAppItemId());
        if (order.getActualPrice() > 0) {
            order.setPayStatus("wait_pay");
        } else {
            order.setPayStatus("none");
        }
        if (order.getDuibaActualPrice() > 0) {
            order.setDuibaPayStatus("wait_pay");
            throw new Exception("\u975e\u5151\u5427\u4ed8\u8d39\u5546\u54c1");
        }
        order.setDuibaPayStatus("none");
        if (order.getConsumerPayPrice() > 0L) {
            order.setSubOrderType("amb");
            order.setConsumerPayStatus("wait_pay");
        } else {
            order.setConsumerPayStatus("none");
        }
        try {
            this.takeOrderIntimes(order, null, 3);
        }
        catch (Exception e) {
            log.error("takeOrderIntimes", (Throwable)e);
            throw e;
        }
        return order;
    }

    @Override
    public void innerManualLotteryAsynCreate(OrdersDto order, DuibaEvent.RequestParams params, ConsumerDO consumer, ManualLotteryOrderDto manualLotteryOrder, ConsumerExchangeRecordDto record) throws Exception {
        try {
            this.duibaEventsDispatcher.dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderCreate, order, null));
        }
        catch (Exception e) {
            log.error("className: " + this.getClass().getName() + "   method: innerManualLottery", (Throwable)e);
        }
        SupplierOrderDto supplierOrder = new SupplierOrderDto(true);
        supplierOrder.setOrderId(order.getId());
        supplierOrder.setStatus("create");
        SupplierProductDto sp = this.supplierProductsService.findBySupplier("developer-object");
        supplierOrder.setSupplierProductId(sp.getId());
        supplierOrder.setBizParams(manualLotteryOrder.getPhone());
        supplierOrder.setDuibaOrderNum(order.getOrderNum());
        this.remoteSupplierOrdersService.insert(supplierOrder);
        order.setSupplierOrderId(supplierOrder.getId());
        OrdersDto o4u = new OrdersDto(order.getId());
        o4u.setSupplierOrderId(order.getSupplierOrderId());
        this.ordersNormalUpdateManager.updateSupplierOrderId(o4u.getId(), order.getConsumerId(), o4u.getSupplierOrderId());
        if (order != null) {
            ManualLotteryOrderDto t4u = new ManualLotteryOrderDto(manualLotteryOrder.getId());
            t4u.setOrderId(order.getId());
            t4u.setWinDate(new Date());
            this.remoteManualOrderLotteryService.update(t4u);
            ConsumerExchangeRecordDto c4update = new ConsumerExchangeRecordDto(record.getId());
            c4update.setOrderId(order.getId());
            this.remoteConsumerExchangeRecordService.updateOrderId(c4update.getId(), c4update.getOrderId(), consumer.getId().longValue());
        }
        if ("unknown_pay".equals(order.getPayStatus()) || "unknown_pay".equals(order.getDuibaPayStatus())) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId());
        } else {
            this.createFlowWorker.makeCompleteByCreator(order.getId(), order.getConsumerId());
        }
    }
}

