/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.ordercreate.impl;

import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.crecord.ConsumerExchangeRecordDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.remoteservice.crecord.RemoteConsumerExchangeRecordService;
import cn.com.duiba.order.center.biz.bo.OrdersNormalUpdateManager;
import cn.com.duiba.order.center.biz.bo.ordercreate.OrderCreateBaseBo;
import cn.com.duiba.order.center.biz.bo.ordercreate.OufeiPhoneflowOrderCreateBo;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsDispatcher;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginEventsDispatcher;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.CreateFlowWorker;
import cn.com.duiba.order.center.biz.service.supplier_order.SupplierOrdersService;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import cn.com.duiba.service.tools.DuibaEvent;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OufeiPhoneflowOrderCreateBoImpl
extends OrderCreateBaseBo
implements OufeiPhoneflowOrderCreateBo {
    private static Logger log = LoggerFactory.getLogger(OufeiPhoneflowOrderCreateBoImpl.class);
    @Resource
    private RemotePreStockService remotePreStockService;
    @Autowired
    private RemoteConsumerExchangeRecordService remoteConsumerExchangeRecordService;
    @Autowired
    private CreateFlowWorker createFlowWorker;
    @Autowired
    private SupplierOrdersService supplierOrdersService;
    @Autowired
    private OrdersNormalUpdateManager ordersNormalUpdateManager;
    @Autowired
    private DuibaEventsDispatcher duibaEventsDispatcher;
    private static Long LianHua_AppId = 4560L;
    private static Integer Fixed_FacePrice = 3000;
    private static String Fixed_Credits = "1000";

    @Override
    public OrdersDto createOrder(DuibaEvent.RequestParams params, ConsumerDO consumer, ItemKey key, Integer actualPrice, String phone, SupplierProductDto product, String chargeMode, String developerBizId) throws Exception {
        OrdersDto order = new OrdersDto(true);
        order.setChargeMode(chargeMode);
        order.setDeveloperBizId(developerBizId);
        order.setConsumerId(consumer.getId());
        order.setAppId(key.getApp().getId());
        order.setDeveloperId(key.getApp().getDeveloperId());
        order.setFacePrice(product.getFacePrice());
        order.setBizParams(phone);
        order.setActualPrice(actualPrice);
        order.setQuantity(Integer.valueOf(1));
        order.setStatus("create");
        order.setType("phoneflow");
        if ("api".equals(chargeMode)) {
            order.setCredits(Long.valueOf(0L));
        } else {
            Long credits = this.remotePreStockService.calculateCreditsByItemKeyAndDegree(key, "" + product.getFacePrice() / 100);
            credits = this.getFixedCredits(key.getApp().getId(), product, credits);
            order.setCredits(credits);
            if (this.isOverThreshold(order, key.getApp())) {
                order.setAuditStatus("wait");
            }
        }
        if (order.getActualPrice() > 0) {
            order.setPayStatus("wait_pay");
        } else {
            order.setPayStatus("none");
        }
        if (order.getDuibaActualPrice() > 0) {
            order.setDuibaPayStatus("wait_pay");
        } else {
            order.setDuibaPayStatus("none");
        }
        if (order.getConsumerPayPrice() > 0L) {
            order.setSubOrderType("amb");
            order.setConsumerPayStatus("wait_pay");
            throw new Exception("\u975e\u52a0\u94b1\u8d2d\u5546\u54c1");
        }
        order.setConsumerPayStatus("none");
        order.setItemId(key.getItem().getId());
        if (key.getAppItem() != null) {
            order.setAppItemId(key.getAppItem().getId());
        }
        order.setBrief("\u624b\u673a\u53f7:" + phone + " [" + product.getName() + "]");
        order.setIp(params.getIp());
        OrdersPlugin.OrdersPluginContext context = new OrdersPlugin.OrdersPluginContext();
        DuibaPluginEventsDispatcher.get().triggerBeforeOrderCreate(key, consumer, chargeMode, params, context);
        order = this.takeOrderIntimes(order, key, 3);
        Long appId = null;
        Long appItemId = null;
        Long itemId = null;
        Object supplierProductId = null;
        if (key.getApp() != null) {
            appId = key.getApp().getId();
        }
        if (key.getAppItem() != null) {
            appItemId = key.getAppItem().getId();
        }
        if (key.getItem() != null) {
            itemId = key.getItem().getId();
        }
        OrderCreateContext orderCreateContext = new OrderCreateContext(params, actualPrice, itemId, appItemId, appId, consumer.getId(), order.getId(), chargeMode, null);
        return order;
    }

    @Override
    public void asynCreate(OrdersDto order, DuibaEvent.RequestParams params, ConsumerDO consumer, ItemKey key, SupplierProductDto product, String chargeMode) throws Exception {
        try {
            OrdersPlugin.OrdersPluginContext context = new OrdersPlugin.OrdersPluginContext();
            try {
                DuibaPluginEventsDispatcher.get().triggerBeforeOrderCreate(key, consumer, chargeMode, params, context);
            }
            catch (Exception e) {
                DuibaPluginEventsDispatcher.get().triggerOnOrderCreateException(key, consumer, chargeMode, params, e, context);
                throw e;
            }
            try {
                this.duibaEventsDispatcher.dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderCreate, order, params));
            }
            catch (Exception e) {
                log.error("className: " + this.getClass().getName() + "   method: innerCreate", (Throwable)e);
            }
            if ("mall".equals(chargeMode)) {
                ConsumerExchangeRecordDto cer = new ConsumerExchangeRecordDto(true);
                cer.setConsumerId(consumer.getId());
                cer.setType(Integer.valueOf(1));
                cer.setOrderId(order.getId());
                this.remoteConsumerExchangeRecordService.insert(cer);
            }
            SupplierOrderDto supplierOrder = new SupplierOrderDto(true);
            supplierOrder.setOrderId(order.getId());
            supplierOrder.setStatus("create");
            supplierOrder.setSupplierProductId(product.getId());
            supplierOrder.setDuibaOrderNum(order.getOrderNum());
            this.supplierOrdersService.insert(supplierOrder);
            order.setSupplierOrderId(supplierOrder.getId());
            OrdersDto order4u = new OrdersDto(order.getId());
            order4u.setSupplierOrderId(order.getSupplierOrderId());
            this.ordersNormalUpdateManager.updateSupplierOrderId(order4u.getId(), order.getConsumerId(), order4u.getSupplierOrderId());
            if (order.getCredits() > 0L) {
                this.consumeCreditsLocal(order.getCredits(), consumer.getId());
            }
            DuibaPluginEventsDispatcher.get().triggerAfterOrderCreate(order, params, context);
            if ("unknown_pay".equals(order.getPayStatus()) || "unknown_pay".equals(order.getDuibaPayStatus())) {
                this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId());
            } else {
                this.createFlowWorker.makeCompleteByCreator(order.getId(), order.getConsumerId());
            }
            this.flowworkEngine.go(order.getId(), consumer.getId());
        }
        catch (StatusException e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), e.getMessage());
        }
        catch (Exception e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), "\u672a\u77e5\u9519\u8bef");
            log.error("asynCreate:", (Throwable)e);
        }
    }

    public Long getFixedCredits(Long appId, SupplierProductDto product, Long credits) {
        if (appId.equals(LianHua_AppId) && product.getFacePrice().equals(Fixed_FacePrice)) {
            return Long.parseLong(Fixed_Credits);
        }
        return credits;
    }
}

