/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo.ordercreate.impl;

import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.crecord.ConsumerExchangeRecordDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.remoteservice.crecord.RemoteConsumerExchangeRecordService;
import cn.com.duiba.order.center.biz.bo.OrdersNormalUpdateManager;
import cn.com.duiba.order.center.biz.bo.ordercreate.OrderCreateBaseBo;
import cn.com.duiba.order.center.biz.bo.ordercreate.VirtualCreateBo;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsDispatcher;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginEventsDispatcher;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.order.center.biz.service.bean.PriceDegree;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.CreateFlowWorker;
import cn.com.duiba.order.center.biz.service.supplier_order.SupplierProductsService;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import cn.com.duiba.service.tools.DuibaEvent;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VirtualCreateBoImpl
extends OrderCreateBaseBo
implements VirtualCreateBo {
    private static Logger log = LoggerFactory.getLogger(VirtualCreateBoImpl.class);
    @Resource
    private RemotePreStockService remotePreStockService;
    @Autowired
    private RemoteConsumerExchangeRecordService remoteConsumerExchangeRecordService;
    @Autowired
    private CreateFlowWorker createFlowWorker;
    @Autowired
    private SupplierProductsService supplierProductsService;
    @Autowired
    private OrdersNormalUpdateManager ordersNormalUpdateManager;
    @Autowired
    private DuibaEventsDispatcher duibaEventsDispatcher;

    @Override
    public OrdersDto innerCreateOrder(DuibaEvent.RequestParams requestParams, ItemKey key, AppItemDO ai, ConsumerDO consumer, String degreeStr, Long appItemId, String bizParams, String chargeMode, Long relationId, Integer relationType, String developerBizId) throws Exception {
        OrdersDto order = new OrdersDto(true);
        order.setChargeMode(chargeMode);
        Long money = 0L;
        if (null != ai.getSalePrice()) {
            money = ai.getSalePrice();
        }
        if (null != money && this.canUseByAmb(order) && ai.isOpTypeAppItem(11) && money > 0L) {
            order.setConsumerPayPrice(money);
            order.setConsumerPayStatus("wait_pay");
            order.setSubOrderType("amb");
        } else {
            order.setConsumerPayStatus("none");
        }
        order.setIp(requestParams.getIp());
        order.setConsumerId(consumer.getId());
        order.setAppId(consumer.getAppId());
        order.setDeveloperId(key.getApp().getDeveloperId());
        order.setFacePrice(Integer.valueOf(0));
        order.setActualPrice(Integer.valueOf(0));
        order.setQuantity(Integer.valueOf(1));
        order.setStatus("create");
        order.setType("virtual");
        order.setBizParams(bizParams);
        if (order.getActualPrice() > 0) {
            order.setPayStatus("wait_pay");
        } else {
            order.setPayStatus("none");
        }
        if (order.getDuibaActualPrice() > 0) {
            order.setDuibaPayStatus("wait_pay");
            throw new Exception("\u975e\u5151\u5427\u4ed8\u8d39\u5546\u54c1");
        }
        order.setDuibaPayStatus("none");
        order.setItemId(null);
        order.setAppItemId(appItemId);
        PriceDegree pd = new PriceDegree(ai.getCustomPrice());
        StringBuffer sb = new StringBuffer();
        if (pd.isSingleDegree()) {
            sb.append(ai.getTitle());
        } else {
            sb.append(ai.getTitle()).append(":").append(pd.getTitleByDegree(degreeStr));
        }
        order.setBrief(sb.toString());
        order.setDeveloperBizId(developerBizId);
        if ("turntable".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
            order.setRelationId(relationId);
            order.setRelationType(relationType);
        } else if ("mall".equals(order.getChargeMode())) {
            order.setCredits(this.remotePreStockService.calculateCreditsByItemKeyAndDegree(key, degreeStr));
            if (this.isOverThreshold(order, key.getApp())) {
                order.setAuditStatus("wait");
            }
        } else if ("singlelottery".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
            order.setRelationId(relationId);
            order.setRelationType(relationType);
        } else if ("hdtool".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
            order.setRelationId(relationId);
            order.setRelationType(relationType);
        } else if ("game".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
            order.setRelationId(relationId);
            order.setRelationType(relationType);
        } else if ("question".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
            order.setRelationId(relationId);
            order.setRelationType(relationType);
        } else if ("quizz".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
            order.setRelationId(relationId);
            order.setRelationType(relationType);
        } else if ("ngame".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
            order.setRelationId(relationId);
            order.setRelationType(relationType);
        } else if ("guess".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
            order.setRelationId(relationId);
            order.setRelationType(relationType);
        } else if ("activity".equals(order.getChargeMode())) {
            order.setCredits(Long.valueOf(0L));
            order.setRelationId(relationId);
            order.setRelationType(relationType);
        }
        order = this.takeOrderIntimes(order, key, 3);
        Long appId = null;
        Long itemId = null;
        Object supplierProductId = null;
        if (key.getApp() != null) {
            appId = key.getApp().getId();
        }
        if (key.getItem() != null) {
            itemId = key.getItem().getId();
        }
        OrderCreateContext orderCreateContext = new OrderCreateContext(requestParams, null, itemId, appItemId, appId, consumer.getId(), order.getId(), chargeMode, null);
        orderCreateContext.addParam("degreeStr", (Object)degreeStr);
        System.out.println("orderId:" + order.getId());
        this.messageService.sendMsg(this.topicConstant.getVirtualCreate(), JSONObject.toJSONString((Object)orderCreateContext));
        return order;
    }

    @Override
    public void asynCreate(OrdersDto order, DuibaEvent.RequestParams params, ConsumerDO consumer, ItemKey key, String chargeMode, String degreeStr) throws Exception {
        try {
            OrdersPlugin.OrdersPluginContext context = new OrdersPlugin.OrdersPluginContext();
            context.setAttribute("orderNum", order.getOrderNum());
            try {
                DuibaPluginEventsDispatcher.get().triggerBeforeOrderCreate(key, consumer, chargeMode, params, context);
            }
            catch (Exception e) {
                log.error("takeOrderIntimes", (Throwable)e);
                DuibaPluginEventsDispatcher.get().triggerOnOrderCreateException(key, consumer, chargeMode, params, e, context);
                throw e;
            }
            try {
                this.duibaEventsDispatcher.dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderCreate, order, params));
            }
            catch (Exception e) {
                log.error("className: " + this.getClass().getName() + "   method: innerCreateOrder", (Throwable)e);
            }
            if ("mall".equals(chargeMode)) {
                ConsumerExchangeRecordDto cer = new ConsumerExchangeRecordDto(true);
                cer.setConsumerId(consumer.getId());
                cer.setType(Integer.valueOf(1));
                cer.setOrderId(order.getId());
                this.remoteConsumerExchangeRecordService.insert(cer);
            }
            if (StringUtils.isNotBlank((String)key.getApp().getVirtualExchangeUrl())) {
                SupplierOrderDto supplierOrder = new SupplierOrderDto(true);
                supplierOrder.setOrderId(order.getId());
                supplierOrder.setStatus("create");
                supplierOrder.setDuibaOrderNum(order.getOrderNum());
                supplierOrder.setBizParams(degreeStr);
                SupplierProductDto sp = this.supplierProductsService.findBySupplier("developer-virtual");
                supplierOrder.setSupplierProductId(sp.getId());
                this.remoteSupplierOrdersService.insert(supplierOrder);
                order.setSupplierOrderId(supplierOrder.getId());
                OrdersDto o4u = new OrdersDto(order.getId());
                o4u.setSupplierOrderId(order.getSupplierOrderId());
                this.ordersNormalUpdateManager.updateSupplierOrderId(o4u.getId(), order.getConsumerId(), o4u.getSupplierOrderId());
            }
            if (order.getCredits() > 0L) {
                this.consumeCreditsLocal(order.getCredits(), consumer.getId());
            }
            DuibaPluginEventsDispatcher.get().triggerAfterOrderCreate(order, params, context);
            if ("unknown_pay".equals(order.getPayStatus()) || "unknown_pay".equals(order.getDuibaPayStatus())) {
                this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId());
            } else {
                this.createFlowWorker.makeCompleteByCreator(order.getId(), order.getConsumerId());
            }
            this.flowworkEngine.go(order.getId(), consumer.getId());
        }
        catch (StatusException e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), e.getMessage());
        }
        catch (Exception e) {
            this.createFlowWorker.forceMakeTofail(order.getId(), order.getConsumerId(), "\u672a\u77e5\u9519\u8bef");
            log.error("asynCreate:", (Throwable)e);
        }
    }
}

