/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.consumer.supplier;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.consumer.ordercreate.SupperConsumer;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.GyjxPhonebillSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.LianLianPhonebillSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.NewLianLianPhonebillSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.OufeiPhonebillSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.SududaPhonebillSupplier2;
import cn.com.duiba.order.center.biz.tool.KafkaClient;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PhonebillCallbackConsumer
implements SupperConsumer {
    private static Logger log = LoggerFactory.getLogger(PhonebillCallbackConsumer.class);
    @Autowired
    private KafkaClient kafkaClient;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private GyjxPhonebillSupplier2 gyjxPhonebillSupplier2;
    @Autowired
    private LianLianPhonebillSupplier2 lianLianPhonebillSupplier2;
    @Autowired
    private NewLianLianPhonebillSupplier2 newLianLianPhonebillSupplier2;
    @Autowired
    private SududaPhonebillSupplier2 sududaPhonebillSupplier2;
    @Autowired
    private OufeiPhonebillSupplier2 oufeiPhonebillSupplier2;
    private static int pool = 5;
    private ExecutorService executorService;

    @Override
    public synchronized void start() {
        if (this.executorService != null) {
            return;
        }
        this.executorService = Executors.newFixedThreadPool(pool, new ThreadFactory(){
            private int i = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Thread-phonebill-Consumer-" + this.i++);
            }
        });
        for (int i = 0; i < pool; ++i) {
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Properties props = new Properties();
                        props.put("bootstrap.servers", PhonebillCallbackConsumer.this.kafkaClient.getBootstrapServers());
                        props.put("group.id", "default");
                        props.put("enable.auto.commit", "false");
                        props.put("session.timeout.ms", "30000");
                        props.put("auto.offset.reset", "earliest");
                        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        KafkaConsumer consumer = new KafkaConsumer(props);
                        consumer.subscribe(Arrays.asList(PhonebillCallbackConsumer.this.topicConstant.getPhonebillCallback()));
                        while (!Thread.currentThread().isInterrupted()) {
                            ConsumerRecords records = consumer.poll(100L);
                            for (TopicPartition pt : records.partitions()) {
                                for (ConsumerRecord record : records.records(pt)) {
                                    try {
                                        SupplierResponse response = (SupplierResponse)JSONObject.parseObject((String)((String)record.value()), SupplierResponse.class);
                                        if ("phonebill-gyjx".equals(response.getSupplierName())) {
                                            PhonebillCallbackConsumer.this.gyjxPhonebillSupplier2.supplierCallback(response);
                                            continue;
                                        }
                                        if ("phonebill-oufei".equals(response.getSupplierName())) {
                                            PhonebillCallbackConsumer.this.oufeiPhonebillSupplier2.supplierCallback(response);
                                            continue;
                                        }
                                        if ("phonebill-lianlian-new".equals(response.getSupplierName())) {
                                            PhonebillCallbackConsumer.this.lianLianPhonebillSupplier2.supplierCallback(response);
                                            continue;
                                        }
                                        if ("phonebill-lianlian-new-platform".equals(response.getSupplierName())) {
                                            PhonebillCallbackConsumer.this.newLianLianPhonebillSupplier2.supplierCallback(response);
                                            continue;
                                        }
                                        if ("phonebill-sududa".equals(response.getSupplierName())) {
                                            PhonebillCallbackConsumer.this.sududaPhonebillSupplier2.supplierCallback(response);
                                            continue;
                                        }
                                        log.error("\u6ca1\u6709\u5bf9\u5e94\u7684\u4e0a\u6e38\uff1a" + response.getSupplierName());
                                    }
                                    catch (Exception e) {
                                        log.error("PhonebillCallback consumer error:", (Throwable)e);
                                    }
                                    finally {
                                        long lastOffset = record.offset();
                                        consumer.commitSync(Collections.singletonMap(pt, new OffsetAndMetadata(lastOffset + 1L)));
                                    }
                                }
                            }
                        }
                        consumer.close();
                    }
                    catch (Exception e) {
                        log.error("error:", (Throwable)e);
                    }
                }
            });
        }
    }

    @Override
    public synchronized void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }
}

