/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event;

import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.core.event.ConsumeCreditsFailEvent;
import cn.com.duiba.order.center.biz.core.event.ConsumerCreditsSuccessEvent;
import cn.com.duiba.order.center.biz.core.event.DuibaActivityEvent;
import cn.com.duiba.order.center.biz.core.event.DuibaHdtoolEvent;
import cn.com.duiba.order.center.biz.core.event.DuibaSecondsKillActivityEvent;
import cn.com.duiba.order.center.biz.core.event.DuibaSingleLotteryEvent;
import cn.com.duiba.order.center.biz.core.event.DuibaTurntableEvent;
import cn.com.duiba.order.center.biz.core.event.GameOrdersEvent;
import cn.com.duiba.order.center.biz.core.event.GuessOrdersEvent;
import cn.com.duiba.order.center.biz.core.event.HdtoolOrdersEvent;
import cn.com.duiba.order.center.biz.core.event.ItemEvent;
import cn.com.duiba.order.center.biz.core.event.ManualLotteryEvent;
import cn.com.duiba.order.center.biz.core.event.NgameOrdersEvent;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.core.event.QuestionOrdersEvent;
import cn.com.duiba.order.center.biz.core.event.QuizzOrdersEvent;
import cn.com.duiba.order.center.biz.core.event.SingleLotteryEvent;
import cn.com.duiba.order.center.biz.core.event.TurntableEvent;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.service.tools.DuibaEvent;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DuibaEventsDispatcher {
    private static Logger log = LoggerFactory.getLogger(DuibaEventsDispatcher.class);
    private static DuibaEventsDispatcher dispatcher = new DuibaEventsDispatcher();
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;

    public static DuibaEventsDispatcher get() {
        return dispatcher;
    }

    public void dispatchEvent(DuibaEvent<?> e) {
        if (e instanceof OrdersEvent) {
            this.processOrdersEvent((OrdersEvent)e);
        } else if (e instanceof TurntableEvent) {
            this.processTurntableEvent((TurntableEvent)e);
        } else if (e instanceof SingleLotteryEvent) {
            this.processSingleLotteryEvent((SingleLotteryEvent)e);
        } else if (e instanceof ManualLotteryEvent) {
            this.processManualLotteryEvent((ManualLotteryEvent)e);
        } else if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
        } else if (e instanceof DuibaActivityEvent) {
            this.processDuibaActivityEvent((DuibaActivityEvent)e);
        } else if (e instanceof DuibaSecondsKillActivityEvent) {
            this.processDuibaSecondsKillActivityEvent((DuibaSecondsKillActivityEvent)e);
        } else if (e instanceof DuibaSingleLotteryEvent) {
            this.processDuibaSingleLotteryEvent((DuibaSingleLotteryEvent)e);
        } else if (e instanceof DuibaHdtoolEvent) {
            this.processDuibaHdtoolEvent((DuibaHdtoolEvent)e);
        } else if (e instanceof DuibaTurntableEvent) {
            this.processDuibaTurntableEvent((DuibaTurntableEvent)e);
        } else if (e instanceof HdtoolOrdersEvent) {
            this.processHdtoolOrdersEvent((HdtoolOrdersEvent)e);
        } else if (e instanceof GameOrdersEvent) {
            this.processGameOrdersEvent((GameOrdersEvent)e);
        } else if (e instanceof QuestionOrdersEvent) {
            this.processQuestionOrdersEvent((QuestionOrdersEvent)e);
        } else if (e instanceof QuizzOrdersEvent) {
            this.processQuizzOrdersEvent((QuizzOrdersEvent)e);
        } else if (e instanceof NgameOrdersEvent) {
            this.processNgameOrdersEvent((NgameOrdersEvent)e);
        } else if (e instanceof GuessOrdersEvent) {
            this.processGuessOrdersEvent((GuessOrdersEvent)e);
        }
    }

    public void dispatchConsumeCreditsFailEvent(ConsumeCreditsFailEvent event) {
        this.messageService.sendMsg(this.topicConstant.getConsumeCreditsFailEvent(), JSONObject.toJSONString((Object)event));
    }

    public void dispatchConsumeCreditsSuccessEvent(ConsumerCreditsSuccessEvent event) {
        this.messageService.sendMsg(this.topicConstant.getConsumerCreditsSuccessEvent(), JSONObject.toJSONString((Object)event));
    }

    private void processSingleLotteryEvent(SingleLotteryEvent sle) {
        this.messageService.sendMsg(this.topicConstant.getSingleLotteryEvent(), JSONObject.toJSONString((Object)sle));
    }

    private void processTurntableEvent(TurntableEvent te) {
        this.messageService.sendMsg(this.topicConstant.getTurntableEvent(), JSONObject.toJSONString((Object)te));
    }

    private void processOrdersEvent(OrdersEvent oe) {
        this.messageService.sendMsg(this.topicConstant.getOrderEvent(), JSONObject.toJSONString((Object)oe));
    }

    private void processManualLotteryEvent(ManualLotteryEvent mle) {
        this.messageService.sendMsg(this.topicConstant.getManualLotteryEvent(), JSONObject.toJSONString((Object)mle));
    }

    private void processItemEvent(ItemEvent be) {
        this.messageService.sendMsg(this.topicConstant.getItemEvent(), JSONObject.toJSONString((Object)be));
    }

    private void processDuibaActivityEvent(DuibaActivityEvent be) {
        this.messageService.sendMsg(this.topicConstant.getDuibaActivityEvent(), JSONObject.toJSONString((Object)be));
    }

    private void processDuibaSingleLotteryEvent(DuibaSingleLotteryEvent be) {
        this.messageService.sendMsg(this.topicConstant.getDuibaSingleLotteryEvent(), JSONObject.toJSONString((Object)be));
    }

    private void processDuibaSecondsKillActivityEvent(DuibaSecondsKillActivityEvent be) {
        this.messageService.sendMsg(this.topicConstant.getDuibaSecondsKillActivityEvent(), JSONObject.toJSONString((Object)be));
    }

    private void processDuibaTurntableEvent(DuibaTurntableEvent be) {
        this.messageService.sendMsg(this.topicConstant.getDuibaTurntableEvent(), JSONObject.toJSONString((Object)be));
    }

    private void processDuibaHdtoolEvent(DuibaHdtoolEvent be) {
        this.messageService.sendMsg(this.topicConstant.getDuibaHdtoolEvent(), JSONObject.toJSONString((Object)be));
    }

    private void processHdtoolOrdersEvent(HdtoolOrdersEvent event) {
        this.messageService.sendMsg(this.topicConstant.getHdtoolOrdersEvent(), JSONObject.toJSONString((Object)event));
    }

    private void processQuizzOrdersEvent(QuizzOrdersEvent event) {
        this.messageService.sendMsg(this.topicConstant.getQuizzOrdersEvent(), JSONObject.toJSONString((Object)event));
    }

    private void processGameOrdersEvent(GameOrdersEvent event) {
        this.messageService.sendMsg(this.topicConstant.getGameOrdersEvent(), JSONObject.toJSONString((Object)event));
    }

    private void processNgameOrdersEvent(NgameOrdersEvent event) {
        this.messageService.sendMsg(this.topicConstant.getNgameOrdersEvent(), JSONObject.toJSONString((Object)event));
    }

    private void processGuessOrdersEvent(GuessOrdersEvent event) {
        this.messageService.sendMsg(this.topicConstant.getGuessOrdersEvent(), JSONObject.toJSONString((Object)event));
    }

    private void processQuestionOrdersEvent(QuestionOrdersEvent event) {
        this.messageService.sendMsg(this.topicConstant.getQuestionOrdersEvent(), JSONObject.toJSONString((Object)event));
    }
}

