/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.plugin.mixed;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.QuantityLimitService;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginRegister;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.tools.DuibaEvent;
import cn.com.duiba.wolf.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CouponQuantityLimitPlugin
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(CouponQuantityLimitPlugin.class);
    @Autowired
    private QuantityLimitService quantityLimitService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    private OrdersEvent.OrdersEventListener ordersEventListener = new OrdersEvent.OrdersEventListener(){

        @Override
        public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
        }

        @Override
        public void onOrderSuccess(OrdersDto order) {
        }

        @Override
        public void onOrderFail(OrdersDto order) {
            ItemKey itemKey;
            if (order.getGmtCreate().getTime() > DateUtils.getTodayZeroTimeInMillis() && (itemKey = CouponQuantityLimitPlugin.this.remoteItemKeyService.getItemKey(order.getItemId(), order.getAppItemId(), order.getAppId())) != null && "coupon".equals(itemKey.getItemType())) {
                try {
                    CouponQuantityLimitPlugin.this.quantityLimitService.subtractCounter(itemKey);
                }
                catch (Exception e) {
                    log.error("\u8fd4\u8fd8\u6bcf\u65e5\u9650\u91cf\u7f13\u5b58\u4e2d\u7684\u5e93\u5b58\uff0c" + e.getMessage());
                }
            }
        }

        @Override
        public void onOrderAuditPass(OrdersDto order) {
        }

        @Override
        public void onOrderAuditReject(OrdersDto order) {
        }

        @Override
        public void onLastSendTime(OrdersDto order) {
        }
    };
    private OrdersPlugin ordersPlugin = new OrdersPlugin.BlankOrdersPlugin(){
        private static final String QUANTITY_KEY = "__coupon_quantity_add";

        @Override
        public void beforeOrderCreate(ItemKey itemKey, ConsumerDO consumer, String chargeMode, DuibaEvent.RequestParams params, OrdersPlugin.OrdersPluginContext context) throws Exception {
            if (itemKey != null && "coupon".equals(itemKey.getItemType()) && CouponQuantityLimitPlugin.this.quantityLimitService.chargeMode(chargeMode)) {
                Boolean quantityLimit = CouponQuantityLimitPlugin.this.quantityLimitService.addCounter(itemKey);
                if (quantityLimit != null && !quantityLimit.booleanValue()) {
                    throw new StatusException(0, "\u4eca\u5929\u5df2\u5151\u5b8c");
                }
                context.setAttribute(QUANTITY_KEY, true);
            }
        }

        @Override
        public void onOrderCreateException(ItemKey itemKey, ConsumerDO consumer, String chargeMode, DuibaEvent.RequestParams params, Exception exception, OrdersPlugin.OrdersPluginContext context) {
            if (itemKey != null && "coupon".equals(itemKey.getItemType()) && CouponQuantityLimitPlugin.this.quantityLimitService.chargeMode(chargeMode)) {
                try {
                    Boolean hasadd = (Boolean)context.getAttribute(QUANTITY_KEY);
                    if (hasadd != null && hasadd.booleanValue()) {
                        CouponQuantityLimitPlugin.this.quantityLimitService.subtractCounter(itemKey);
                    }
                    context.remove(QUANTITY_KEY);
                }
                catch (Exception e) {
                    log.error("\u8fd4\u8fd8\u6bcf\u65e5\u9650\u91cf\u7f13\u5b58\u4e2d\u7684\u5e93\u5b58\uff0c" + e.getMessage());
                }
            }
        }
    };

    private boolean isPlatformCouponGoodsOrder(OrdersDto order) {
        return order.getTypeInt() != null && order.getTypeInt().intValue() == GoodsTypeEnum.PLATFORM.getGtype();
    }

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(this.ordersEventListener);
        DuibaPluginRegister.get().addOrdersPlugin(this.ordersPlugin);
    }
}

