/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.plugin.stock;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginRegister;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.item.remoteservice.RemoteItemStockConsumeService;
import cn.com.duiba.service.tools.DuibaEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ObjectVirtualStockPlugin
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(ObjectVirtualStockPlugin.class);
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private RemoteItemStockConsumeService remoteItemStockConsumeService;
    private OrdersEvent.OrdersEventListener ordersEventListener = new OrdersEvent.OrdersEventListener(){

        @Override
        public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
        }

        @Override
        public void onOrderSuccess(OrdersDto order) {
        }

        @Override
        public void onOrderFail(OrdersDto order) {
            ItemKey itemKey = ObjectVirtualStockPlugin.this.remoteItemKeyService.getItemKey(order.getItemId(), order.getAppItemId(), order.getAppId());
            if (this.chargeModeCheck(order.getChargeMode()) && ("object".equals(itemKey.getItemType()) || "virtual".equals(itemKey.getItemType()))) {
                try {
                    ObjectVirtualStockPlugin.this.remoteItemStockConsumeService.paybackStock(order.getOrderNum(), "normal");
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: paybackStock", (Throwable)e);
                }
            }
        }

        @Override
        public void onOrderAuditPass(OrdersDto order) {
        }

        @Override
        public void onOrderAuditReject(OrdersDto order) {
        }

        @Override
        public void onLastSendTime(OrdersDto order) {
        }

        private boolean chargeModeCheck(String chargeMode) {
            if ("hdtool".equals(chargeMode)) {
                return false;
            }
            if ("singlelottery".equals(chargeMode)) {
                return false;
            }
            if ("turntable".equals(chargeMode)) {
                return false;
            }
            if ("manuallottery".equals(chargeMode)) {
                return false;
            }
            if ("game".equals(chargeMode)) {
                return false;
            }
            if ("question".equals(chargeMode)) {
                return false;
            }
            if ("quizz".equals(chargeMode)) {
                return false;
            }
            if ("seckill".equals(chargeMode)) {
                return true;
            }
            if ("ngame".equals(chargeMode)) {
                return false;
            }
            if ("guess".equals(chargeMode)) {
                return false;
            }
            return !"activity".equals(chargeMode);
        }
    };
    private OrdersPlugin ordersPlugin = new OrdersPlugin.BlankOrdersPlugin(){
        private static final String ObJ_VIRTUAL_STOCK = "__obj_virtual_stock_consume";

        @Override
        public void beforeOrderCreate(ItemKey itemKey, ConsumerDO consumer, String chargeMode, DuibaEvent.RequestParams params, OrdersPlugin.OrdersPluginContext context) throws Exception {
            if (this.chargeModeCheck(chargeMode) && this.ObjVirtualTypeCheck(itemKey.getItemType()).booleanValue()) {
                try {
                    Object orderNum = context.getAttribute("orderNum");
                    if (null != orderNum) {
                        ObjectVirtualStockPlugin.this.remoteItemStockConsumeService.consumeStock(itemKey, orderNum.toString(), "normal");
                        context.setAttribute(ObJ_VIRTUAL_STOCK, true);
                    }
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: consumeStock,\u51cf\u5e93\u5b58\u5931\u8d25", (Throwable)e);
                    throw e;
                }
            }
        }

        @Override
        public void onOrderCreateException(ItemKey itemKey, ConsumerDO consumer, String chargeMode, DuibaEvent.RequestParams params, Exception exception, OrdersPlugin.OrdersPluginContext context) {
            if (this.chargeModeCheck(chargeMode) && this.ObjVirtualTypeCheck(itemKey.getItemType()).booleanValue()) {
                try {
                    Boolean hasadd = (Boolean)context.getAttribute(ObJ_VIRTUAL_STOCK);
                    Object orderNum = context.getAttribute("orderNum");
                    if (hasadd != null && hasadd.booleanValue() && orderNum != null) {
                        ObjectVirtualStockPlugin.this.remoteItemStockConsumeService.paybackStock(orderNum.toString(), "normal");
                    }
                    context.remove(ObJ_VIRTUAL_STOCK);
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: increaseRemaining,\u8fd4\u5e93\u5b58\u5931\u8d25", (Throwable)e);
                }
            }
        }

        private boolean chargeModeCheck(String chargeMode) {
            if ("hdtool".equals(chargeMode)) {
                return false;
            }
            if ("singlelottery".equals(chargeMode)) {
                return false;
            }
            if ("turntable".equals(chargeMode)) {
                return false;
            }
            if ("manuallottery".equals(chargeMode)) {
                return false;
            }
            if ("game".equals(chargeMode)) {
                return false;
            }
            if ("question".equals(chargeMode)) {
                return false;
            }
            if ("quizz".equals(chargeMode)) {
                return false;
            }
            if ("seckill".equals(chargeMode)) {
                return true;
            }
            if ("ngame".equals(chargeMode)) {
                return false;
            }
            if ("guess".equals(chargeMode)) {
                return false;
            }
            return !"activity".equals(chargeMode);
        }

        private Boolean ObjVirtualTypeCheck(String type) {
            if ("object".equals(type) || "virtual".equals(type)) {
                return true;
            }
            return false;
        }
    };

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(this.ordersEventListener);
        DuibaPluginRegister.get().addOrdersPlugin(this.ordersPlugin);
    }
}

