/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.plugin.stock;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginRegister;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.dataobject.ItemAppSpecifyDO;
import cn.com.duiba.service.item.remoteservice.RemoteItemAppSpecifyService;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.item.remoteservice.RemoteItemStockConsumeService;
import cn.com.duiba.service.tools.DuibaEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedirectStockPlugin
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(RedirectStockPlugin.class);
    @Autowired
    private RemoteItemAppSpecifyService remoteItemAppSpecifyService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private RemoteItemStockConsumeService remoteItemStockConsumeService;
    private OrdersEvent.OrdersEventListener ordersEventListener = new OrdersEvent.OrdersEventListener(){

        @Override
        public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
        }

        @Override
        public void onOrderSuccess(OrdersDto order) {
        }

        @Override
        public void onOrderFail(OrdersDto order) {
            ItemKey itemKey = RedirectStockPlugin.this.remoteItemKeyService.getItemKeyIncludeDeleted(order.getItemId(), order.getAppItemId(), order.getAppId());
            if (this.directItemCheck(itemKey, order.getChargeMode()).booleanValue()) {
                try {
                    RedirectStockPlugin.this.remoteItemStockConsumeService.paybackRedirectStock(order.getOrderNum(), "normalspecify");
                }
                catch (Exception e) {
                    log.error("\u8fd4\u5e93\u5b58\u5f02\u5e38", (Throwable)e);
                }
            }
        }

        @Override
        public void onOrderAuditPass(OrdersDto order) {
        }

        @Override
        public void onOrderAuditReject(OrdersDto order) {
        }

        @Override
        public void onLastSendTime(OrdersDto order) {
        }

        private Boolean directItemCheck(ItemKey key, String chargeMode) {
            ItemAppSpecifyDO itemAppSpecifyDO;
            if (null != key && null != key.getItem() && key.getItem().isOpTypeItem(3) && this.chargeModeCheck(chargeMode) && null != (itemAppSpecifyDO = RedirectStockPlugin.this.remoteItemAppSpecifyService.findByItemIdAndAppId(key.getItem().getId(), key.getApp().getId()))) {
                return true;
            }
            return false;
        }

        private boolean chargeModeCheck(String chargeMode) {
            if ("hdtool".equals(chargeMode)) {
                return false;
            }
            if ("singlelottery".equals(chargeMode)) {
                return false;
            }
            if ("turntable".equals(chargeMode)) {
                return false;
            }
            if ("manuallottery".equals(chargeMode)) {
                return false;
            }
            if ("game".equals(chargeMode)) {
                return false;
            }
            if ("question".equals(chargeMode)) {
                return false;
            }
            if ("quizz".equals(chargeMode)) {
                return false;
            }
            if ("ngame".equals(chargeMode)) {
                return false;
            }
            if ("guess".equals(chargeMode)) {
                return false;
            }
            return !"activity".equals(chargeMode);
        }
    };
    private OrdersPlugin ordersPlugin = new OrdersPlugin.BlankOrdersPlugin(){
        private static final String DIRECT_STOCK_KEY = "__redirect_stock";

        @Override
        public void beforeOrderCreate(ItemKey itemKey, ConsumerDO consumer, String chargeMode, DuibaEvent.RequestParams params, OrdersPlugin.OrdersPluginContext context) throws Exception {
            if (this.directItemCheck(itemKey, chargeMode).booleanValue()) {
                try {
                    Object objOrderNum = context.getAttribute("orderNum");
                    if (null != objOrderNum) {
                        RedirectStockPlugin.this.remoteItemStockConsumeService.consumeRedirectStock(itemKey, objOrderNum.toString(), "normalspecify");
                        context.setAttribute(DIRECT_STOCK_KEY, true);
                    }
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: consumeRedirectStock", (Throwable)e);
                    throw e;
                }
            }
        }

        @Override
        public void onOrderCreateException(ItemKey itemKey, ConsumerDO consumer, String chargeMode, DuibaEvent.RequestParams params, Exception exception, OrdersPlugin.OrdersPluginContext context) {
            if (this.directItemCheck(itemKey, chargeMode).booleanValue()) {
                try {
                    Boolean hasadd = (Boolean)context.getAttribute(DIRECT_STOCK_KEY);
                    Object objOrderNum = context.getAttribute("orderNum");
                    if (hasadd != null && hasadd.booleanValue() && objOrderNum != null) {
                        RedirectStockPlugin.this.remoteItemStockConsumeService.paybackRedirectStock(objOrderNum.toString(), "normalspecify");
                    }
                    context.remove(DIRECT_STOCK_KEY);
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: paybackRedirectStock,\u8fd4\u5b9a\u5411\u5e93\u5b58\u5931\u8d25", (Throwable)e);
                }
            }
        }

        private Boolean directItemCheck(ItemKey key, String chargeMode) {
            ItemAppSpecifyDO itemAppSpecifyDO;
            if (null != key && null != key.getItem() && key.getItem().isOpTypeItem(3) && this.chargeModeCheck(chargeMode) && null != (itemAppSpecifyDO = RedirectStockPlugin.this.remoteItemAppSpecifyService.findByItemIdAndAppId(key.getItem().getId(), key.getApp().getId()))) {
                return true;
            }
            return false;
        }

        private boolean chargeModeCheck(String chargeMode) {
            if ("hdtool".equals(chargeMode)) {
                return false;
            }
            if ("singlelottery".equals(chargeMode)) {
                return false;
            }
            if ("turntable".equals(chargeMode)) {
                return false;
            }
            if ("manuallottery".equals(chargeMode)) {
                return false;
            }
            if ("game".equals(chargeMode)) {
                return false;
            }
            if ("question".equals(chargeMode)) {
                return false;
            }
            if ("quizz".equals(chargeMode)) {
                return false;
            }
            if ("seckill".equals(chargeMode)) {
                return false;
            }
            if ("ngame".equals(chargeMode)) {
                return false;
            }
            if ("guess".equals(chargeMode)) {
                return false;
            }
            return !"activity".equals(chargeMode);
        }
    };

    private boolean isPlatformCouponGoodsOrder(OrdersDto order) {
        return order.getTypeInt() != null && order.getTypeInt().intValue() == GoodsTypeEnum.PLATFORM.getGtype();
    }

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(this.ordersEventListener);
        DuibaPluginRegister.get().addOrdersPlugin(this.ordersPlugin);
    }
}

