/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.core.event.eventlistener.realtime.fastOrder;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsRegister;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.service.orders_faster.OrdersFasterSimpleService;
import cn.com.duiba.order.center.biz.support.OrderFasterEventLog;
import cn.com.duiba.order.center.biz.support.ThreadPoolDuibaService;
import cn.com.duiba.order.center.biz.support.ThreadPoolDuibaServiceLog;
import cn.com.duiba.service.tools.DuibaEvent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HdToolsTimeoutOrderRealTime
implements InitializingBean {
    @Autowired
    private OrdersFasterSimpleService remoteOrdersFasterSimpleService;

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registOrdersEvent(new OrdersEvent.OrdersEventListener(){

            @Override
            public void onOrderCreate(OrdersDto order, DuibaEvent.RequestParams request) {
            }

            @Override
            public void onOrderSuccess(final OrdersDto order) {
                if (this.hdtoolTimeoutCondition(order)) {
                    ThreadPoolDuibaServiceLog.info("className: " + this.getClass().getName() + "   method: onOrderSuccess");
                    ThreadPoolDuibaService.get().submit(new Runnable(){

                        @Override
                        public void run() {
                            int ret = HdToolsTimeoutOrderRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 9);
                            if (ret == 1) {
                                OrderFasterEventLog.deleteLog(order, "\u6d3b\u52a8\u5de5\u5177\u8d85\u65f6\u8ba2\u5355");
                            }
                        }
                    }, 1);
                }
            }

            @Override
            public void onOrderFail(final OrdersDto order) {
                if (this.hdtoolTimeoutCondition(order)) {
                    ThreadPoolDuibaServiceLog.info("className: " + this.getClass().getName() + "   method: onOrderFail");
                    ThreadPoolDuibaService.get().submit(new Runnable(){

                        @Override
                        public void run() {
                            int ret = HdToolsTimeoutOrderRealTime.this.remoteOrdersFasterSimpleService.deleteOrderByOrderIdAndFasterType(order.getId(), 9);
                            if (ret == 1) {
                                OrderFasterEventLog.deleteLog(order, "\u6d3b\u52a8\u5de5\u5177\u8d85\u65f6\u8ba2\u5355");
                            }
                        }
                    }, 1);
                }
            }

            @Override
            public void onOrderAuditPass(OrdersDto order) {
            }

            @Override
            public void onOrderAuditReject(OrdersDto order) {
            }

            @Override
            public void onLastSendTime(OrdersDto order) {
            }

            private boolean hdtoolTimeoutCondition(OrdersDto order) {
                if (order.getChargeMode().equals("hdtool") && null != order.getItemId()) {
                    return !order.getType().equals("coupon") && !order.getType().equals("virtual");
                }
                return false;
            }
        });
    }
}

