/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.plugin.impl.plugin_impl;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.QuantityLimitService;
import cn.com.duiba.order.center.biz.plugin.DuibaPluginRegister;
import cn.com.duiba.order.center.biz.plugin.OrdersPlugin;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.dataobject.ItemLimitDO;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.item.remoteservice.RemoteItemLimitService;
import cn.com.duiba.service.tools.DuibaEvent;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QuantityLimitTakeOrderPlugin
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(QuantityLimitTakeOrderPlugin.class);
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private QuantityLimitService quantityLimitService;
    @Autowired
    private RemoteItemLimitService remoteItemLimitService;
    private OrdersPlugin quantityLimitPlugin = new OrdersPlugin.BlankOrdersPlugin(){

        @Override
        public void afterOrderCreate(OrdersDto order, DuibaEvent.RequestParams params, OrdersPlugin.OrdersPluginContext context) {
            try {
                if ("mall".equals(order.getChargeMode())) {
                    ItemKey itemKey = QuantityLimitTakeOrderPlugin.this.remoteItemKeyService.getItemKey(order.getItemId(), order.getAppItemId(), order.getAppId());
                    if (QuantityLimitTakeOrderPlugin.this.quantityLimitService.isQuantityLimitItem(itemKey).booleanValue()) {
                        ItemLimitDO limit = new ItemLimitDO();
                        limit.setConsumerId(order.getConsumerId());
                        limit.setAppId(order.getAppId());
                        limit.setAppItemId(order.getAppItemId());
                        limit.setItemId(order.getItemId());
                        limit.setItemKey(order.getItemId(), order.getAppItemId());
                        limit.setGmtCreate(new Date());
                        limit.setSourceId(order.getId());
                        limit.setSourceType(ItemLimitDO.SourceTypeOrder);
                        QuantityLimitTakeOrderPlugin.this.remoteItemLimitService.insert(limit);
                    }
                }
            }
            catch (Exception e) {
                log.error("afterOrderCreate.insert.itemLimit error:", (Throwable)e);
            }
        }
    };

    public void afterPropertiesSet() throws Exception {
        DuibaPluginRegister.get().addOrdersPlugin(this.quantityLimitPlugin);
    }
}

