/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.crecord.impl;

import cn.com.duiba.order.center.api.dto.crecord.ConsumerExchangeRecordDto;
import cn.com.duiba.order.center.biz.dao.crecord.ConsumerExchangeRecordDao;
import cn.com.duiba.order.center.biz.entity.crecord.ConsumerExchangeRecordEntity;
import cn.com.duiba.order.center.biz.service.crecord.ConsumerExchangeRecordService;
import cn.com.duiba.order.center.biz.service.crecord.CrecordService;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsumerExchangeRecordServiceImpl
implements ConsumerExchangeRecordService {
    @Autowired
    public ConsumerExchangeRecordDao consumerExchangeRecordDao;
    @Autowired
    private CrecordService crecordService;

    @Override
    public long getSequenceID() {
        return this.consumerExchangeRecordDao.getSequenceID();
    }

    @Override
    public ConsumerExchangeRecordDto find(Long id, long consumerId) {
        return (ConsumerExchangeRecordDto)BeanUtils.copy((Object)this.consumerExchangeRecordDao.find(id, consumerId), ConsumerExchangeRecordDto.class);
    }

    @Override
    public void insert(ConsumerExchangeRecordDto consumerExchangeRecordDO) {
        ConsumerExchangeRecordEntity entity = (ConsumerExchangeRecordEntity)BeanUtils.copy((Object)consumerExchangeRecordDO, ConsumerExchangeRecordEntity.class);
        this.consumerExchangeRecordDao.insert(entity);
        consumerExchangeRecordDO.setId(entity.getId());
        this.crecordService.sendSyncMessage(consumerExchangeRecordDO.getConsumerId(), consumerExchangeRecordDO.getId());
    }

    @Override
    public int updateSwitchs(Long id, Long switchs, Long orderId, long consumerId) {
        int num = this.consumerExchangeRecordDao.updateSwitchs(id, switchs, orderId, consumerId);
        this.crecordService.sendSyncMessage(consumerId, id);
        return num;
    }

    @Override
    public int updateOrderId(Long id, Long orderId, long consumerId) {
        int num = this.consumerExchangeRecordDao.updateOrderId(id, orderId, consumerId);
        this.crecordService.sendSyncMessage(consumerId, id);
        return num;
    }

    @Override
    public int updateJson(Long id, String json, long consumerId) {
        int num = this.consumerExchangeRecordDao.updateJson(id, json, consumerId);
        this.crecordService.sendSyncMessage(consumerId, id);
        return num;
    }

    @Override
    public int updateOverDue(Long id, Date overDue, Long consumerId) {
        int num = this.consumerExchangeRecordDao.updateOverDue(id, overDue, consumerId);
        this.crecordService.sendSyncMessage(consumerId, id);
        return num;
    }

    @Override
    public List<ConsumerExchangeRecordDto> findConsumerExchangeRecord(Map<String, Object> queryMap, long consumerId) {
        return BeanUtils.copyList(this.consumerExchangeRecordDao.findConsumerExchangeRecord(queryMap, consumerId), ConsumerExchangeRecordDto.class);
    }

    @Override
    public List<ConsumerExchangeRecordDto> findConsumerExchangeRecordValid(Map<String, Object> queryMap, long consumerId) {
        return BeanUtils.copyList(this.consumerExchangeRecordDao.findConsumerExchangeRecordValid(queryMap, consumerId), ConsumerExchangeRecordDto.class);
    }

    @Override
    public List<ConsumerExchangeRecordDto> findConsumerExchangeRecordInvalid(Map<String, Object> queryMap, long consumerId) {
        return BeanUtils.copyList(this.consumerExchangeRecordDao.findConsumerExchangeRecordInvalid(queryMap, consumerId), ConsumerExchangeRecordDto.class);
    }

    @Override
    public ConsumerExchangeRecordDto findByOrderId(Long orderId, Long consumerId) {
        return (ConsumerExchangeRecordDto)BeanUtils.copy((Object)this.consumerExchangeRecordDao.findByOrderId(orderId, consumerId), ConsumerExchangeRecordDto.class);
    }

    @Override
    public ConsumerExchangeRecordDto findByRelationIdAndType(Long relationId, Integer type, Long consumerId) {
        return (ConsumerExchangeRecordDto)BeanUtils.copy((Object)this.consumerExchangeRecordDao.findByRelationIdAndType(relationId, type, consumerId), ConsumerExchangeRecordDto.class);
    }

    @Override
    public ConsumerExchangeRecordDto findGameByRelationIdAndType(Long relationId, Integer type, Long consumerId) {
        return (ConsumerExchangeRecordDto)BeanUtils.copy((Object)this.consumerExchangeRecordDao.findGameByRelationIdAndType(relationId, type, consumerId), ConsumerExchangeRecordDto.class);
    }

    @Override
    public ConsumerExchangeRecordDto findGuessByRelationIdAndType(Long relationId, Integer type, Long consumerId) {
        return (ConsumerExchangeRecordDto)BeanUtils.copy((Object)this.consumerExchangeRecordDao.findGuessByRelationIdAndType(relationId, type, consumerId), ConsumerExchangeRecordDto.class);
    }

    @Override
    public List<ConsumerExchangeRecordDto> findConsumerExchangeRecordPptv(Long consumerId, Long minId, Integer max) {
        return BeanUtils.copyList(this.consumerExchangeRecordDao.findConsumerExchangeRecordPptv(consumerId, minId, max), ConsumerExchangeRecordDto.class);
    }

    @Override
    public List<ConsumerExchangeRecordDto> findGameRecord(Long consumerId, Integer type, Integer offset, Integer max) {
        return BeanUtils.copyList(this.consumerExchangeRecordDao.findGameRecord(consumerId, type, offset, max), ConsumerExchangeRecordDto.class);
    }

    @Override
    public ConsumerExchangeRecordDto findOneRecordInvalid(long consumerId) {
        return (ConsumerExchangeRecordDto)BeanUtils.copy((Object)this.consumerExchangeRecordDao.findOneRecordInvalid(consumerId), ConsumerExchangeRecordDto.class);
    }
}

