/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.email.impl;

import cn.com.duiba.order.center.biz.service.email.ConfigurationItemConstant;
import cn.com.duiba.order.center.biz.service.email.EmailService;
import cn.com.duiba.order.center.biz.service.email.PayCenterLog;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service(value="emailService")
public class EmailServiceImpl
implements EmailService {
    @Autowired
    private JavaMailSender sender;
    private ExecutorService executorService = Executors.newFixedThreadPool(1);

    @Override
    public void sendEmail(String to, String subject, String text, boolean html) throws Exception {
        MimeMessage mail = this.sender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mail);
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setFrom("system@duiba.com.cn");
        helper.setText(text, html);
        this.sender.send(mail);
    }

    @Override
    public void sendEmail(List<String> to, String subject, String text, boolean html) throws Exception {
        this.sendEmail(to.toArray(new String[to.size()]), subject, text, html);
    }

    @Override
    public void sendEmail(String[] to, String subject, String text, boolean html) throws Exception {
        MimeMessage mail = this.sender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mail);
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setFrom("system@duiba.com.cn");
        helper.setText(text, html);
        this.sender.send(mail);
    }

    @Override
    public void sendEmailBcc(List<String> to, String subject, String text, boolean html) throws Exception {
        MimeMessage mail = this.sender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mail);
        helper.setBcc(to.toArray(new String[to.size()]));
        helper.setSubject(subject);
        helper.setFrom("system@duiba.com.cn");
        helper.setText(text, html);
        this.sender.send(mail);
    }

    @Override
    public void sendSeriousEmail4PayCenter(final String head, final String text) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    EmailServiceImpl.this.sendEmail(ConfigurationItemConstant.getEmailList(), head, text, false);
                }
                catch (Exception e) {
                    PayCenterLog.info("\u90ae\u4ef6\u53d1\u9001\u5f02\u5e38", e);
                }
            }
        });
    }
}

