/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange.tool;

import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.biz.constant.PredicateConstant;
import cn.com.duiba.order.center.biz.service.exchange.tool.ThreadPoolConsumeCreditsService;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncHttpClientPool {
    protected String threadName = "t_1";
    private static final Logger log = LoggerFactory.getLogger(AbstractAsyncHttpClientPool.class);
    private CloseableHttpAsyncClient httpClient;
    private ScheduledExecutorService whileService = Executors.newScheduledThreadPool(1);
    private Map<Long, AtomicInteger> runningStat = new ConcurrentHashMap<Long, AtomicInteger>();
    private Map<Long, AtomicInteger> waitRunStat = new ConcurrentHashMap<Long, AtomicInteger>();
    private Map<Long, ConcurrentLinkedQueue<CallbackProcesser>> queue = new ConcurrentHashMap<Long, ConcurrentLinkedQueue<CallbackProcesser>>();

    public abstract Logger getLog();

    public abstract int getAppBusyValve();

    public abstract int getAppConcurrentValve();

    public abstract CloseableHttpAsyncClient getAsyncHttpClient();

    protected AbstractAsyncHttpClientPool() {
        this.httpClient = this.getAsyncHttpClient();
        this.httpClient.start();
        this.whileService.scheduleWithFixedDelay(new Thread(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    CallbackProcesser processer;
                    if (!AbstractAsyncHttpClientPool.this.httpClient.isRunning()) {
                        log.error(AbstractAsyncHttpClientPool.this.getClass().getName() + " httpClient not running,restart it");
                        CloseableHttpAsyncClient client = AbstractAsyncHttpClientPool.this.getAsyncHttpClient();
                        client.start();
                        AbstractAsyncHttpClientPool.this.httpClient = client;
                    }
                    do {
                        processer = null;
                        ArrayList<Long> appIds = new ArrayList<Long>();
                        for (Long appId : AbstractAsyncHttpClientPool.this.queue.keySet()) {
                            if (((ConcurrentLinkedQueue)AbstractAsyncHttpClientPool.this.queue.get(appId)).isEmpty() || !AbstractAsyncHttpClientPool.this.canSubmitToPool(appId)) continue;
                            appIds.add(appId);
                        }
                        if (appIds.isEmpty()) return;
                        for (Long appId : appIds) {
                            AtomicInteger count;
                            if (AbstractAsyncHttpClientPool.this.runningStat.get(appId) != null && ((AtomicInteger)AbstractAsyncHttpClientPool.this.runningStat.get(appId)).intValue() >= AbstractAsyncHttpClientPool.this.getAppConcurrentValve()) continue;
                            ConcurrentLinkedQueue qu = (ConcurrentLinkedQueue)AbstractAsyncHttpClientPool.this.queue.get(appId);
                            if (!qu.isEmpty()) {
                                processer = (CallbackProcesser)qu.poll();
                            }
                            if (processer == null) continue;
                            log.debug("submit appId=" + processer.getAppId());
                            AtomicInteger data = (AtomicInteger)AbstractAsyncHttpClientPool.this.waitRunStat.get(processer.getAppId());
                            if (data != null) {
                                data.decrementAndGet();
                            }
                            if ((count = (AtomicInteger)AbstractAsyncHttpClientPool.this.runningStat.get(processer.getAppId())) == null) {
                                AbstractAsyncHttpClientPool.this.runningStat.put(processer.getAppId(), new AtomicInteger(1));
                            } else {
                                count.incrementAndGet();
                            }
                            try {
                                if (AbstractAsyncHttpClientPool.this instanceof ThreadPoolConsumeCreditsService) {
                                    HttpRequestLogDto log = new HttpRequestLogDto();
                                    log.setAppId(appId);
                                    log.setType("BeforeConsumeSend");
                                    log.setTag("BeforeConsumeSend");
                                    log.setUrl(processer.getRequest().getURI().toString());
                                    StatHttpRequestLog.log(log);
                                }
                                AbstractAsyncHttpClientPool.this.httpClient.execute(processer.getRequest(), (FutureCallback)processer);
                            }
                            catch (Exception e) {
                                log.error("httpClient.execute error", (Throwable)e);
                                processer.failed(e);
                            }
                        }
                    } while (processer != null);
                    return;
                }
                catch (Exception e) {
                    log.error(this.getClass().getSimpleName() + " while cycle exception", (Throwable)e);
                }
            }
        }, this.threadName), 1000L, 10L, TimeUnit.MILLISECONDS);
    }

    public synchronized void submit(Long appId, HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        AtomicInteger count = this.waitRunStat.get(appId);
        if (count == null) {
            count = new AtomicInteger(1);
            this.waitRunStat.put(appId, count);
        } else {
            count.incrementAndGet();
        }
        ConcurrentLinkedQueue<CallbackProcesser> qu = this.queue.get(appId);
        if (qu == null) {
            qu = new ConcurrentLinkedQueue();
            this.queue.put(appId, qu);
        }
        qu.add(new CallbackProcesser(appId, request, callback));
    }

    private boolean canSubmitToPool(Long appId) {
        AtomicInteger count = this.runningStat.get(appId);
        if (count == null) {
            return true;
        }
        return count.get() < this.getAppConcurrentValve();
    }

    public JSONObject dumpDetail() {
        JSONObject o = new JSONObject();
        o.put("runningStat", this.runningStat);
        o.put("waitRunStat", this.waitRunStat);
        return o;
    }

    public JSONObject dumpExclude0Detail() {
        JSONObject o = new JSONObject();
        Map run_map = Maps.filterValues(this.runningStat, (Predicate)PredicateConstant.exclude0Predicate());
        Map wait_map = Maps.filterValues(this.waitRunStat, (Predicate)PredicateConstant.exclude0Predicate());
        o.put("runningStat", (Object)run_map);
        o.put("waitRunStat", (Object)wait_map);
        return o;
    }

    public int dumpSize() {
        int total = 0;
        for (AtomicInteger a : this.waitRunStat.values()) {
            total += a.get();
        }
        for (AtomicInteger a : this.runningStat.values()) {
            total += a.get();
        }
        return total;
    }

    public boolean isAppBusy(Long appId) {
        AtomicInteger rCount;
        int total = 0;
        AtomicInteger count = this.waitRunStat.get(appId);
        if (count != null) {
            total = count.intValue();
        }
        if ((rCount = this.runningStat.get(appId)) != null) {
            total += rCount.intValue();
        }
        return total >= this.getAppBusyValve();
    }

    protected RequestConfig getDefaultConfig() {
        return RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
    }

    private class CallbackProcesser
    implements FutureCallback<HttpResponse> {
        private HttpUriRequest request;
        private FutureCallback<HttpResponse> callback;
        private Long appId;

        public CallbackProcesser(Long appId, HttpUriRequest request, FutureCallback<HttpResponse> callback) {
            this.request = request;
            this.callback = callback;
            this.appId = appId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(HttpResponse result) {
            try {
                this.callback.completed((Object)result);
            }
            finally {
                ((AtomicInteger)AbstractAsyncHttpClientPool.this.runningStat.get(this.appId)).decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Exception ex) {
            try {
                this.callback.failed(ex);
            }
            finally {
                ((AtomicInteger)AbstractAsyncHttpClientPool.this.runningStat.get(this.appId)).decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelled() {
            try {
                this.callback.cancelled();
            }
            finally {
                ((AtomicInteger)AbstractAsyncHttpClientPool.this.runningStat.get(this.appId)).decrementAndGet();
            }
        }

        public Long getAppId() {
            return this.appId;
        }

        public HttpUriRequest getRequest() {
            return this.request;
        }
    }
}

