/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier;

import cn.com.duiba.order.center.biz.dao.log.AlipayBatchLoggDao;
import cn.com.duiba.order.center.biz.entity.log.AlipayBatchLogEntity;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.AlipayOfficialSupplier2;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlipayBatchExecutor {
    private static Logger log = LoggerFactory.getLogger(AlipayBatchExecutor.class);
    @Autowired
    private AlipayBatchLoggDao alipayBatchLoggDAO;
    private String requestUrl;
    private String batchNotifyUrl;
    private String account;
    private final String account_name = new String("\u676d\u5dde\u5151\u5427\u7f51\u7edc\u79d1\u6280\u6709\u9650\u516c\u53f8");
    private String md5Key;
    private String partner;
    private Integer batchCount;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private LinkedBlockingQueue<AlipayOfficialSupplier2.AlipayOfficialRequest> queue = new LinkedBlockingQueue();
    private static AtomicLong atomic = new AtomicLong();

    public Integer getQueueSize() {
        return this.queue.size();
    }

    public JSONObject dumpExclude0Detail() {
        HashMap maps = Maps.newHashMap();
        JSONObject o = new JSONObject();
        for (AlipayOfficialSupplier2.AlipayOfficialRequest request : this.queue) {
            maps.put(request.getOrderNum(), request);
        }
        o.put("aliPayDetail", (Object)maps);
        return o;
    }

    public static void main(String[] args) throws Exception {
        ScheduledExecutorService s = Executors.newScheduledThreadPool(1);
        s.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                System.out.println("run");
            }
        }, 0L, 5L, TimeUnit.SECONDS);
    }

    public void init() {
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    this.innerRun();
                }
                catch (Exception e) {
                    log.error("AlipayBatchExecutor scheduleWithFixedDelay error", (Throwable)e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void innerRun() {
                ArrayList<AlipayOfficialSupplier2.AlipayOfficialRequest> list = new ArrayList<AlipayOfficialSupplier2.AlipayOfficialRequest>();
                for (int i = 0; i < AlipayBatchExecutor.this.batchCount && !AlipayBatchExecutor.this.queue.isEmpty(); ++i) {
                    AlipayOfficialSupplier2.AlipayOfficialRequest req = (AlipayOfficialSupplier2.AlipayOfficialRequest)AlipayBatchExecutor.this.queue.poll();
                    if (req == null) continue;
                    list.add(req);
                }
                if (!list.isEmpty()) {
                    SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHHmmss");
                    AlipayBatchLogEntity blog = new AlipayBatchLogEntity(true);
                    AlipayBatchExecutor.this.alipayBatchLoggDAO.insert(blog);
                    String batch_no = f.format(new Date()) + blog.getId();
                    ArrayList<String> orderNums = new ArrayList<String>();
                    for (AlipayOfficialSupplier2.AlipayOfficialRequest req : list) {
                        orderNums.add(req.getOrderNum());
                    }
                    String url = AlipayBatchExecutor.this.generateUrl(batch_no, list);
                    String body = "";
                    try {
                        CloseableHttpClient client = HttpClientBuilder.create().build();
                        HttpPost post = AlipayBatchExecutor.this.generatePostRequest(batch_no, list);
                        post.setConfig(AlipayBatchExecutor.this.getTimeoutConfig());
                        CloseableHttpResponse response = client.execute((HttpUriRequest)post);
                        body = EntityUtils.toString((HttpEntity)response.getEntity());
                    }
                    catch (Exception e) {
                        log.error("scheduler httpclient error", (Throwable)e);
                    }
                    finally {
                        try {
                            AlipayBatchLogEntity log = new AlipayBatchLogEntity(blog.getId());
                            log.setBatchNo(batch_no);
                            log.setAllOrderNums(orderNums);
                            log.setRequestUrl(url);
                            log.setResponse(body);
                            AlipayBatchExecutor.this.alipayBatchLoggDAO.update(log);
                        }
                        catch (Exception e) {
                            log.error("scheduler update log error", (Throwable)e);
                        }
                    }
                }
            }
        }, 1L, 10L, TimeUnit.SECONDS);
    }

    protected RequestConfig getTimeoutConfig() {
        return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
    }

    public void addAlipayOrder(AlipayOfficialSupplier2.AlipayOfficialRequest req) {
        this.queue.add(req);
    }

    public HttpPost generatePostRequest(String batch_no, List<AlipayOfficialSupplier2.AlipayOfficialRequest> list) {
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String pay_date = new String(format.format(now));
        String detail_data = "";
        Integer fee = 0;
        for (AlipayOfficialSupplier2.AlipayOfficialRequest req : list) {
            String no = req.getOrderNum();
            String alipay = req.getAlipay();
            String realname = req.getRealname();
            String price = req.getQuantity() + "";
            fee = fee + req.getQuantity();
            String memo = req.getMemo();
            detail_data = detail_data + no + "^" + alipay + "^" + realname + "^" + price + "^" + memo + "|";
        }
        if (detail_data.endsWith("|")) {
            detail_data = detail_data.substring(0, detail_data.length() - 1);
        }
        String batch_fee = fee.toString();
        String batch_num = list.size() + "";
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", "batch_trans_notify_no_pwd");
        sParaTemp.put("partner", this.partner);
        sParaTemp.put("_input_charset", "utf-8");
        sParaTemp.put("notify_url", this.batchNotifyUrl);
        sParaTemp.put("email", this.account);
        sParaTemp.put("account_name", this.account_name);
        sParaTemp.put("pay_date", pay_date);
        sParaTemp.put("batch_no", batch_no);
        sParaTemp.put("batch_fee", batch_fee);
        sParaTemp.put("batch_num", batch_num);
        sParaTemp.put("detail_data", detail_data);
        ArrayList keys = new ArrayList(sParaTemp.keySet());
        Collections.sort(keys);
        String string = "";
        for (String s : keys) {
            if (string.length() == 0) {
                string = string + s + "=" + (String)sParaTemp.get(s);
                continue;
            }
            string = string + "&" + s + "=" + (String)sParaTemp.get(s);
        }
        string = string + this.md5Key;
        String sign = "";
        try {
            sign = AlipayBatchExecutor.toHexValue(AlipayBatchExecutor.encryptMD5(string.getBytes(Charset.forName("utf-8"))));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("md5 error");
        }
        sParaTemp.put("sign", sign);
        sParaTemp.put("sign_type", "MD5");
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(sParaTemp.size());
        for (Map.Entry entry : sParaTemp.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            pairs.add(new BasicNameValuePair((String)entry.getKey(), value));
        }
        String url = this.requestUrl;
        if (!url.endsWith("?")) {
            url = url + "?";
        }
        HttpPost post = new HttpPost(url + "_input_charset=utf-8");
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, Charset.forName("utf-8")));
        post.addHeader("Content-Type", "application/x-www-form-urlencoded; text/html; charset=utf-8");
        return post;
    }

    public String generateUrl(String batch_no, List<AlipayOfficialSupplier2.AlipayOfficialRequest> list) {
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String pay_date = new String(format.format(now));
        String detail_data = "";
        Integer fee = 0;
        for (AlipayOfficialSupplier2.AlipayOfficialRequest req : list) {
            String no = req.getOrderNum();
            String alipay = req.getAlipay();
            String realname = req.getRealname();
            String price = req.getQuantity() + "";
            fee = fee + req.getQuantity();
            String memo = req.getMemo();
            detail_data = detail_data + no + "^" + alipay + "^" + realname + "^" + price + "^" + memo + "|";
        }
        if (detail_data.endsWith("|")) {
            detail_data = detail_data.substring(0, detail_data.length() - 1);
        }
        String batch_fee = fee.toString();
        String batch_num = list.size() + "";
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", "batch_trans_notify_no_pwd");
        sParaTemp.put("partner", this.partner);
        sParaTemp.put("_input_charset", "utf-8");
        sParaTemp.put("notify_url", this.batchNotifyUrl);
        sParaTemp.put("email", this.account);
        sParaTemp.put("account_name", this.account_name);
        sParaTemp.put("pay_date", pay_date);
        sParaTemp.put("batch_no", batch_no);
        sParaTemp.put("batch_fee", batch_fee);
        sParaTemp.put("batch_num", batch_num);
        sParaTemp.put("detail_data", detail_data);
        ArrayList keys = new ArrayList(sParaTemp.keySet());
        Collections.sort(keys);
        String string = "";
        for (String s : keys) {
            if (string.length() == 0) {
                string = string + s + "=" + (String)sParaTemp.get(s);
                continue;
            }
            string = string + "&" + s + "=" + (String)sParaTemp.get(s);
        }
        string = string + this.md5Key;
        String sign = "";
        try {
            sign = AlipayBatchExecutor.toHexValue(AlipayBatchExecutor.encryptMD5(string.getBytes(Charset.forName("utf-8"))));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("md5 error");
        }
        sParaTemp.put("sign", sign);
        sParaTemp.put("sign_type", "MD5");
        String url = AlipayBatchExecutor.assembleUrl(this.requestUrl, sParaTemp);
        return url;
    }

    public static String assembleUrl(String url, Map<String, String> params) {
        url = url + "?";
        for (String key : params.keySet()) {
            try {
                if (params.get(key) == null || params.get(key).length() == 0) {
                    url = url + key + "=" + params.get(key) + "&";
                    continue;
                }
                url = url + key + "=" + URLEncoder.encode(params.get(key), "utf-8") + "&";
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    public void setMd5Key(String md5Key) {
        this.md5Key = md5Key;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setBatchNotifyUrl(String batchNotifyUrl) {
        this.batchNotifyUrl = batchNotifyUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public void setPartner(String partner) {
        this.partner = partner;
    }

    public void setBatchCount(Integer batchCount) {
        this.batchCount = batchCount;
    }
}

