/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier.impl;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.dto.unique_check.UniqueSupplierCheckDto;
import cn.com.duiba.order.center.biz.constant.Environment;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierExchangeResponse;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierOrderStatus;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.BaseSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.SupplierRequest;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SupplierExchangeFlowWorker;
import cn.com.duiba.order.center.biz.service.unique_check.UniqueSupplierCheckService;
import cn.com.duiba.order.center.biz.tool.Coder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EnlianSupplier2
extends BaseSupplier2
implements Supplier {
    private static Logger logger = LoggerFactory.getLogger(EnlianSupplier2.class);
    @Autowired
    private UniqueSupplierCheckService uniqueSupplierCheckService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private SupplierExchangeFlowWorker supplierExchangeFlowWorker;
    private String apiUrl;
    private String appKey;
    private String secretKey;
    private String version;
    private String callbackUrl;
    private String balanceUrl;
    private String queryUrl;

    public static SupplierData.SupplierExchangeRequest buildRequestData(String orderNum, String qq, Integer quantity) {
        EnlianRequest req = new EnlianRequest(orderNum, qq, quantity);
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public SupplierData.SupplierExchangeResponse submit(SupplierData.SupplierExchangeRequest req, Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("qb-enlian")) {
            throw new Exception("\u6b64\u8ba2\u5355\u4e0d\u662fQb\u5151\u6362\u8ba2\u5355");
        }
        String url = this.apiUrl;
        if (!url.endsWith("?")) {
            url = url + "?";
        }
        EnlianRequest request = null;
        if (!(req instanceof EnlianRequest)) {
            throw new Exception("req \u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        request = (EnlianRequest)req;
        String ip = order.getIp();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appKey", this.appKey);
        params.put("secretKey", this.secretKey);
        params.put("version", this.version);
        params.put("itemId", "0");
        params.put("merOrderId", request.getOrderNum());
        params.put("number", request.getQq());
        params.put("itemPrice", request.getQuantity() + "");
        params.put("callBackUrl", this.callbackUrl);
        params.put("gameType", "QB");
        if (ip != null && ip.length() > 0) {
            params.put("ip", ip);
        }
        String sign = EnlianSupplier2.sign(params);
        for (String s : params.keySet()) {
            if (s.equals("secretKey")) continue;
            url = url + s + "=" + (String)params.get(s) + "&";
        }
        url = url + "sign=" + sign;
        System.out.println(url);
        String completeUrl = url;
        String body = null;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet get = new HttpGet(url);
            get.setConfig(this.getTimeoutConfig());
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            body = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject o = JSON.parseObject((String)body);
            Boolean success = o.getBoolean("success");
            EnlianResponse resp = new EnlianResponse();
            resp.setSupplierBody(body);
            if (success.booleanValue()) {
                resp.setSupplierBizId(o.getJSONObject("data").getJSONObject("orderDetail").getString("orderId"));
            } else {
                resp.setError4Admin("QB\u5145\u503c\u5f02\u5e38\uff1a" + o.getString("errorMsg"));
                resp.setError4Developer("QB\u4e0a\u6e38\u5145\u503c\u5f02\u5e38");
                String code = o.getString("errorCode");
                if (this.isFailSure(code)) {
                    resp.setError4Consumer("\u5145\u503c\u5f02\u5e38");
                    resp.setFail(true);
                }
            }
            EnlianResponse enlianResponse = resp;
            return enlianResponse;
        }
        finally {
            SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
            so4u.setStatus("send");
            so4u.setSendTime(new Date());
            this.supplierOrdersService.update(so4u);
            HttpRequestLogDto log = new HttpRequestLogDto(true);
            log.setType("ToSupplier");
            log.setTag(this.getSupplierName());
            log.setAppId(order.getAppId());
            log.setOrderId(orderId);
            log.setConsumerId(order.getConsumerId());
            log.setUrl(completeUrl);
            StatHttpRequestLog.log(log);
        }
    }

    @Override
    public void asyncSubmit(SupplierData.SupplierExchangeRequest req, Long orderId, Long consumerId, final Supplier.SupplierCallback callback, ExecutorService es) {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("qb-enlian")) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u6b64\u8ba2\u5355\u4e0d\u662fQb\u5151\u6362\u8ba2\u5355"));
                }
            });
            return;
        }
        String url = this.apiUrl;
        if (!url.endsWith("?")) {
            url = url + "?";
        }
        EnlianRequest request = null;
        if (!(req instanceof EnlianRequest)) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("req \u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e"));
                }
            });
            return;
        }
        request = (EnlianRequest)req;
        UniqueSupplierCheckDto supplierCheck = new UniqueSupplierCheckDto(true);
        supplierCheck.setOrderNum(order.getOrderNum());
        supplierCheck.setSupplierOrderNum(so.getDuibaOrderNum());
        supplierCheck.setSupplier(sp.getSupplier());
        supplierCheck.setType(order.getType());
        try {
            this.uniqueSupplierCheckService.insert(supplierCheck);
        }
        catch (Exception e) {
            logger.error("\u5411\u4e0a\u6e38\u91cd\u590d\u8bf7\u6c42:orderNum=" + order.getOrderNum() + " ,supplierOrderNum=" + so.getDuibaOrderNum() + " ,error:" + e.getMessage());
            return;
        }
        String ip = order.getIp();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appKey", this.appKey);
        params.put("secretKey", this.secretKey);
        params.put("version", this.version);
        params.put("itemId", "0");
        params.put("merOrderId", request.getOrderNum());
        params.put("number", request.getQq());
        params.put("itemPrice", request.getQuantity() + "");
        params.put("callBackUrl", this.callbackUrl);
        params.put("gameType", "QB");
        if (ip != null && ip.length() > 0) {
            params.put("ip", ip);
        }
        String sign = EnlianSupplier2.sign(params);
        for (String s : params.keySet()) {
            if (s.equals("secretKey")) continue;
            url = url + s + "=" + (String)params.get(s) + "&";
        }
        String completeUrl = url = url + "sign=" + sign;
        SupplierRequest srequest = new SupplierRequest();
        srequest.setHttpUrl(completeUrl);
        srequest.setAppId(String.valueOf(order.getAppId()));
        srequest.setConsumerId(String.valueOf(order.getConsumerId()));
        srequest.setOrderId(String.valueOf(order.getId()));
        srequest.setSupplierOrderId(String.valueOf(order.getSupplierOrderId()));
        srequest.setSupplierName("qb-enlian");
        try {
            this.messageService.sendMsg(this.topicConstant.getQbRequest(), JSONObject.toJSONString((Object)srequest));
        }
        catch (Exception e) {
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
            logger.error("SupplierQBEnlian sendMsg:", (Throwable)e);
        }
    }

    private boolean isFailSure(String code) {
        List<String> codes = Arrays.asList("2000", "2001", "2002", "2003", "2004", "2005", "2006", "2007", "2008", "2009", "2010", "2011", "2012", "2013", "2014", "2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022", "2023", "2024", "2025", "2026", "2027");
        return codes.contains(code);
    }

    @Override
    public SupplierData.SupplierOrderStatus queryOrderStatus(String orderNum, String supplierOrderId) throws Exception {
        BaseSupplierOrderStatus status = new BaseSupplierOrderStatus();
        status.setOrderNum(orderNum);
        status.setSupplierOrderId(supplierOrderId);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appKey", this.appKey);
        params.put("secretKey", this.secretKey);
        params.put("merOrderId", orderNum);
        params.put("version", this.version);
        String sign = EnlianSupplier2.sign(params);
        String url = this.queryUrl;
        if (!url.endsWith("?")) {
            url = url + "?";
        }
        for (String s : params.keySet()) {
            if (s.equals("secretKey")) continue;
            url = url + s + "=" + (String)params.get(s) + "&";
        }
        url = url + "sign=" + sign;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(url);
        get.setConfig(this.getTimeoutConfig());
        CloseableHttpResponse resp = client.execute((HttpUriRequest)get);
        String body = EntityUtils.toString((HttpEntity)resp.getEntity());
        status.setResponse(body);
        String orderStatus = "";
        JSONObject o = JSON.parseObject((String)body);
        Boolean success = o.getBoolean("success");
        if (success.booleanValue()) {
            orderStatus = o.getJSONObject("data").getJSONObject("orderDetail").getString("orderStatus");
        }
        if ("success".equalsIgnoreCase(orderStatus)) {
            status.setSuccess(true);
        } else if ("failed".equalsIgnoreCase(orderStatus)) {
            status.setFail(true);
        } else if ("processing".equalsIgnoreCase(orderStatus) || "importing".equalsIgnoreCase(orderStatus)) {
            status.setProcessing(true);
        } else {
            String errorCode = o.getString("errorCode");
            if ("2028".equals(errorCode)) {
                status.setNotExist(true);
            } else {
                throw new Exception(body);
            }
        }
        return status;
    }

    @Override
    public BigDecimal queryBalance() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appKey", this.appKey);
        params.put("secretKey", this.secretKey);
        params.put("version", this.version);
        String sign = EnlianSupplier2.sign(params);
        String url = this.balanceUrl;
        if (!url.endsWith("?")) {
            url = url + "?";
        }
        for (String s : params.keySet()) {
            if (s.equals("secretKey")) continue;
            url = url + s + "=" + (String)params.get(s) + "&";
        }
        url = url + "sign=" + sign;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(url);
        String body = "";
        CloseableHttpResponse resp = client.execute((HttpUriRequest)get);
        body = EntityUtils.toString((HttpEntity)resp.getEntity());
        JSONObject o = JSON.parseObject((String)body);
        Boolean success = o.getBoolean("success");
        if (success.booleanValue()) {
            return new BigDecimal(o.getJSONObject("data").getDouble("balance"));
        }
        throw new Exception("\u67e5\u8be2\u5931\u8d25 " + body);
    }

    @Override
    public SupplierData.SupplierOrderStatus callbackParse(HttpServletRequest request) throws Exception {
        BaseSupplierOrderStatus ret = new BaseSupplierOrderStatus();
        if (!Environment.isDaily()) {
            String sign = request.getParameter("sign");
            Map map = request.getParameterMap();
            HashMap<String, String> p = new HashMap<String, String>();
            for (String key : map.keySet()) {
                p.put(key, ((String[])map.get(key))[0]);
            }
            p.remove("sign");
            p.put("secretKey", this.secretKey);
            if (!sign.equals(EnlianSupplier2.sign(p))) {
                throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u9519\u8bef");
            }
        }
        String orderNum = request.getParameter("merOrderId");
        OrdersDto order = null;
        SupplierOrderDto so = null;
        if (orderNum.startsWith("duiba")) {
            so = this.supplierOrdersService.findByDuibaOrderNum(orderNum);
        } else {
            order = this.orderReadManagerBo.findByOrderNum(orderNum);
            so = this.supplierOrdersService.find(order.getSupplierOrderId());
        }
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if ("qb-enlian".equals(sp.getSupplier())) {
            if ("success".equalsIgnoreCase(request.getParameter("orderStatus"))) {
                ret.setSuccess(true);
            } else {
                ret.setFail(true);
            }
        }
        return ret;
    }

    public static String sign(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String string = "";
        for (String s : keys) {
            string = string + params.get(s);
        }
        String sign = "";
        try {
            sign = EnlianSupplier2.qbToHexValue(Coder.encryptMD5(string.getBytes(Charset.forName("utf-8"))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sign;
    }

    public static String qbToHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @Override
    public String getSupplierName() {
        return "enlian";
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getBalanceUrl() {
        return this.balanceUrl;
    }

    public void setBalanceUrl(String balanceUrl) {
        this.balanceUrl = balanceUrl;
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public void setQueryUrl(String queryUrl) {
        this.queryUrl = queryUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplierCallback(SupplierResponse response) {
        Long orderId = Long.valueOf(response.getOrderId());
        Long consumerId = Long.valueOf(response.getConsumerId());
        if (response.getCallbackType().equals("completed")) {
            Exception exception = null;
            try {
                this.successBlock(response);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                this.finallyBlock(response);
            }
            if (exception == null) {
                this.supplierExchangeFlowWorker.onFinish(orderId, consumerId, response);
            } else {
                this.supplierExchangeFlowWorker.onException(orderId, consumerId, exception);
            }
        } else if (response.getCallbackType().equals("failed")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception(response.getErrorMessage()));
        } else if (response.getCallbackType().equals("cancelled")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u8bf7\u6c42\u88ab\u53d6\u6d88"));
        }
    }

    private void successBlock(SupplierResponse resp) {
        JSONObject o = JSON.parseObject((String)resp.getBody());
        Boolean success = o.getBoolean("success");
        if (success.booleanValue()) {
            resp.setSupplierBizId(o.getJSONObject("data").getJSONObject("orderDetail").getString("orderId"));
        } else {
            resp.setError4Admin("QB\u5145\u503c\u5f02\u5e38\uff1a" + o.getString("errorMsg"));
            resp.setError4Developer("QB\u4e0a\u6e38\u5145\u503c\u5f02\u5e38");
            String code = o.getString("errorCode");
            if (this.isFailSure(code)) {
                resp.setError4Consumer("\u5145\u503c\u5f02\u5e38");
                resp.setFail(true);
            }
        }
    }

    private void finallyBlock(SupplierResponse resp) {
        SupplierOrderDto so4u = new SupplierOrderDto(Long.valueOf(resp.getSupplierOrderId()));
        so4u.setStatus("send");
        so4u.setSendTime(new Date());
        this.supplierOrdersService.update(so4u);
        if (this.isHttpLogEnable()) {
            HttpRequestLogDto log = new HttpRequestLogDto(true);
            log.setType("ToSupplier");
            log.setTag(this.getSupplierName());
            log.setAppId(Long.valueOf(resp.getAppId()));
            log.setOrderId(Long.valueOf(resp.getOrderId()));
            log.setResp(resp.getBody());
            log.setConsumerId(Long.valueOf(resp.getConsumerId()));
            log.setUrl(resp.getUrl());
            log.setResp(resp.getBody());
            StatHttpRequestLog.log(log);
        }
    }

    public static class EnlianResponse
    extends BaseSupplierExchangeResponse {
    }

    public static class EnlianRequest
    implements SupplierData.SupplierExchangeRequest {
        private String orderNum;
        private String qq;
        private Integer quantity;

        public EnlianRequest(String orderNum, String qq, Integer quantity) {
            this.orderNum = orderNum;
            this.qq = qq;
            this.quantity = quantity;
        }

        @Override
        public String getOrderNum() {
            return this.orderNum;
        }

        public String getQq() {
            return this.qq;
        }

        public void setQq(String qq) {
            this.qq = qq;
        }

        public Integer getQuantity() {
            return this.quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }
    }
}

