/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier.impl;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.dto.unique_check.UniqueSupplierCheckDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierExchangeResponse;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierOrderStatus;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.BaseSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.SupplierRequest;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SupplierExchangeFlowWorker;
import cn.com.duiba.order.center.biz.service.unique_check.UniqueSupplierCheckService;
import cn.com.duiba.order.center.biz.tool.TimeProfile;
import com.alibaba.fastjson.JSONObject;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;

public class GoukaQBSupplier2
extends BaseSupplier2
implements Supplier {
    private static Logger logger = LoggerFactory.getLogger(GoukaQBSupplier2.class);
    private String url;
    private String agentID;
    private String md5Key;
    private String orderQuery;
    private String balanceQuery;
    @Autowired
    private UniqueSupplierCheckService uniqueSupplierCheckService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private SupplierExchangeFlowWorker supplierExchangeFlowWorker;

    public static SupplierData.SupplierExchangeRequest buildRequestData(String orderNum, String qq, Integer quantity) {
        GoukaQBRequest req = new GoukaQBRequest(orderNum, qq, quantity);
        return req;
    }

    @Override
    @Deprecated
    public SupplierData.SupplierExchangeResponse submit(SupplierData.SupplierExchangeRequest req, Long orderId, Long consumerId) throws Exception {
        String postUrl;
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("qb-gouka")) {
            throw new Exception("\u6b64\u8ba2\u5355\u4e0d\u662fQ\u5e01\u5151\u6362\u8ba2\u5355");
        }
        if (!this.url.endsWith("?")) {
            this.url = this.url + "?";
        }
        GoukaQBRequest request = null;
        if (!(req instanceof GoukaQBRequest)) {
            throw new Exception("req \u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        request = (GoukaQBRequest)req;
        String merchantid = this.agentID;
        String productid = "188";
        String buynumber = request.getQuantity() + "";
        String saleprice = request.getQuantity() + "";
        String orderno = request.getOrderNum();
        String gameid = request.getQq();
        String userip = order.getIp();
        String sign = GoukaQBSupplier2.md5(buynumber + gameid + merchantid + orderno + productid + saleprice + userip + this.md5Key);
        String completeUrl = postUrl = this.url + "merchantid=" + merchantid + "&productid=" + productid + "&buynumber=" + buynumber + "&saleprice=" + saleprice + "&orderno=" + orderno + "&gameid=" + gameid + "&userip=" + userip + "&sign=" + sign;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(completeUrl);
        get.setConfig(this.getTimeoutConfig());
        GoukaQBResponse resp = new GoukaQBResponse();
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
            so4u.setSupplierInfo(body);
            this.supplierOrdersService.update(so4u);
            resp.setSupplierBody(body);
            if (body == null) {
                throw new Exception("response body is null");
            }
            SAXBuilder builder = new SAXBuilder();
            StringReader xmlReader = new StringReader(body);
            InputSource xmlSource = new InputSource(xmlReader);
            Document doc = builder.build(xmlSource);
            Element root = doc.getRootElement();
            if (root.getChild("apiresult").getChild("resultcode").getValue().equals("0")) {
                String spOrderId = root.getChild("buycard").getChild("saleorderid").getValue();
                resp.setSupplierBizId(spOrderId);
                resp.setSupplierBody(body);
            } else {
                resp.setError4Admin("\u8d2d\u5361\u8fd4\u56de\u72b6\u6001\u7801\u4e3a\uff1a" + root.getChild("apiresult").getChild("resultcode").getValue());
                resp.setError4Developer("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25");
                resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            GoukaQBResponse goukaQBResponse = resp;
            return goukaQBResponse;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
            so4u.setStatus("send");
            so4u.setSendTime(new Date());
            this.supplierOrdersService.update(so4u);
            HttpRequestLogDto log = new HttpRequestLogDto(true);
            log.setType("ToSupplier");
            log.setTag(this.getSupplierName());
            log.setAppId(order.getAppId());
            log.setOrderId(order.getId());
            log.setResp(resp.getSupplierBody());
            log.setConsumerId(order.getConsumerId());
            log.setUrl(completeUrl);
            StatHttpRequestLog.log(log);
        }
    }

    @Override
    public void asyncSubmit(SupplierData.SupplierExchangeRequest req, Long orderId, Long consumerId, final Supplier.SupplierCallback callback, ExecutorService es) {
        String postUrl;
        String sign;
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("qb-gouka")) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u6b64\u8ba2\u5355\u4e0d\u662fQ\u5e01\u5151\u6362\u8ba2\u5355"));
                }
            });
            return;
        }
        if (!this.url.endsWith("?")) {
            this.url = this.url + "?";
        }
        GoukaQBRequest request = null;
        if (!(req instanceof GoukaQBRequest)) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("req \u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e"));
                }
            });
            return;
        }
        request = (GoukaQBRequest)req;
        UniqueSupplierCheckDto supplierCheck = new UniqueSupplierCheckDto(true);
        supplierCheck.setOrderNum(order.getOrderNum());
        supplierCheck.setSupplierOrderNum(so.getDuibaOrderNum());
        supplierCheck.setSupplier(sp.getSupplier());
        supplierCheck.setType(order.getType());
        try {
            this.uniqueSupplierCheckService.insert(supplierCheck);
        }
        catch (Exception e) {
            logger.error("\u5411\u4e0a\u6e38\u91cd\u590d\u8bf7\u6c42:orderNum=" + order.getOrderNum() + " ,supplierOrderNum=" + so.getDuibaOrderNum() + " ,error:" + e.getMessage());
            return;
        }
        String merchantid = this.agentID;
        String productid = "188";
        String buynumber = request.getQuantity() + "";
        String saleprice = request.getQuantity() + "";
        String orderno = request.getOrderNum();
        String gameid = request.getQq();
        String userip = order.getIp();
        try {
            sign = GoukaQBSupplier2.md5(buynumber + gameid + merchantid + orderno + productid + saleprice + userip + this.md5Key);
        }
        catch (Exception e1) {
            callback.onException(e1);
            return;
        }
        String completeUrl = postUrl = this.url + "merchantid=" + merchantid + "&productid=" + productid + "&buynumber=" + buynumber + "&saleprice=" + saleprice + "&orderno=" + orderno + "&gameid=" + gameid + "&userip=" + userip + "&sign=" + sign;
        SupplierRequest srequest = new SupplierRequest();
        srequest.setHttpUrl(completeUrl);
        srequest.setAppId(String.valueOf(order.getAppId()));
        srequest.setConsumerId(String.valueOf(order.getConsumerId()));
        srequest.setOrderId(String.valueOf(order.getId()));
        srequest.setSupplierOrderId(String.valueOf(order.getSupplierOrderId()));
        srequest.setSupplierName("qb-gouka");
        try {
            this.messageService.sendMsg(this.topicConstant.getQbRequest(), JSONObject.toJSONString((Object)srequest));
        }
        catch (Exception e) {
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
            logger.error("SupplierQBGouka sendMsg:", (Throwable)e);
        }
    }

    @Override
    public SupplierData.SupplierOrderStatus queryOrderStatus(String orderNum, String supplierOrderId) throws Exception {
        BaseSupplierOrderStatus status = new BaseSupplierOrderStatus();
        status.setOrderNum(orderNum);
        status.setSupplierOrderId(supplierOrderId);
        String orderQuery = this.orderQuery;
        if (!orderQuery.endsWith("?")) {
            orderQuery = orderQuery + "?";
        }
        String sign = GoukaQBSupplier2.md5(this.agentID + orderNum + this.md5Key);
        String queryUrl = orderQuery + "merchantid=" + this.agentID + "&orderno=" + orderNum + "&sign=" + sign;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(queryUrl);
        get.setConfig(this.getTimeoutConfig());
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        status.setResponse(body);
        StringReader xmlReader = new StringReader(body);
        InputSource xmlSource = new InputSource(xmlReader);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(xmlSource);
        Element root = doc.getRootElement();
        if (root.getChild("apiresult").getChild("resultcode").getValue().equals("0")) {
            if (root.getChild("buycard").getChild("orderstatus").getValue().equals("order_success")) {
                status.setSuccess(true);
            } else if (root.getChild("buycard").getChild("orderstatus").getValue().equals("order_failed")) {
                status.setFail(true);
            }
        } else if (!root.getChild("apiresult").getChild("resultcode").getValue().equals("9")) {
            throw new Exception(body);
        }
        return status;
    }

    @Override
    public BigDecimal queryBalance() throws Exception {
        HttpGet get;
        String balanceQuery = this.balanceQuery;
        if (!balanceQuery.endsWith("?")) {
            balanceQuery = balanceQuery + "?";
        }
        String body = "";
        String sign = GoukaQBSupplier2.md5(this.agentID + this.md5Key);
        balanceQuery = balanceQuery + "merchantid=" + this.agentID + "&sign=" + sign;
        SAXBuilder builder = new SAXBuilder();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse response = client.execute((HttpUriRequest)(get = new HttpGet(balanceQuery)));
        body = EntityUtils.toString((HttpEntity)response.getEntity());
        StringReader xmlReader = new StringReader(body);
        InputSource xmlSource = new InputSource(xmlReader);
        Document doc = builder.build(xmlSource);
        Element root = doc.getRootElement();
        if (root.getChild("apiresult").getChild("resultcode").getValue().equals("0")) {
            String balance = root.getChild("infoquery").getChild("accountbalance").getValue();
            BigDecimal bd = new BigDecimal(balance);
            return bd;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SupplierData.SupplierOrderStatus callbackParse(HttpServletRequest request) throws Exception {
        BaseSupplierOrderStatus ret = new BaseSupplierOrderStatus();
        String orderNum = request.getParameter("orderno");
        String status = request.getParameter("orderstatus");
        OrdersDto order = null;
        SupplierOrderDto so = null;
        try {
            TimeProfile.enter("GoukaQBCallback orders query by orderNum in QBExchangeController");
            if (orderNum.startsWith("duiba")) {
                so = this.supplierOrdersService.findByDuibaOrderNum(orderNum);
            } else {
                order = this.orderReadManagerBo.findByOrderNum(orderNum);
                so = this.supplierOrdersService.find(order.getSupplierOrderId());
            }
        }
        finally {
            TimeProfile.release();
        }
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if ("qb-gouka".equals(sp.getSupplier()) && "send".equals(so.getStatus())) {
            if ("order_success".equals(status)) {
                ret.setSuccess(true);
            } else if ("order_failed".equals(status)) {
                ret.setFail(true);
            }
        }
        return ret;
    }

    public static String md5(String content) throws Exception {
        return GoukaQBSupplier2.toHexValue(GoukaQBSupplier2.encryptMD5(content.getBytes(Charset.forName("utf-8"))));
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    @Override
    public String getSupplierName() {
        return "gouka-qb";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAgentID() {
        return this.agentID;
    }

    public void setAgentID(String agentID) {
        this.agentID = agentID;
    }

    public String getMd5Key() {
        return this.md5Key;
    }

    public void setMd5Key(String md5Key) {
        this.md5Key = md5Key;
    }

    public String getOrderQuery() {
        return this.orderQuery;
    }

    public void setOrderQuery(String orderQuery) {
        this.orderQuery = orderQuery;
    }

    public String getBalanceQuery() {
        return this.balanceQuery;
    }

    public void setBalanceQuery(String balanceQuery) {
        this.balanceQuery = balanceQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplierCallback(SupplierResponse response) {
        Long orderId = Long.valueOf(response.getOrderId());
        Long consumerId = Long.valueOf(response.getConsumerId());
        if (response.getCallbackType().equals("completed")) {
            Exception exception = null;
            try {
                this.successBlock(response);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                this.finallyBlock(response);
            }
            if (exception == null) {
                this.supplierExchangeFlowWorker.onFinish(orderId, consumerId, response);
            } else {
                this.supplierExchangeFlowWorker.onException(orderId, consumerId, exception);
            }
        } else if (response.getCallbackType().equals("failed")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception(response.getErrorMessage()));
        } else if (response.getCallbackType().equals("cancelled")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u8bf7\u6c42\u88ab\u53d6\u6d88"));
        }
    }

    private void successBlock(SupplierResponse resp) throws Exception {
        String body = resp.getBody();
        SupplierOrderDto so4u = new SupplierOrderDto(Long.valueOf(resp.getSupplierOrderId()));
        so4u.setSupplierInfo(resp.getBody());
        this.supplierOrdersService.update(so4u);
        if (body == null) {
            throw new Exception("response body is null");
        }
        SAXBuilder builder = new SAXBuilder();
        StringReader xmlReader = new StringReader(body);
        InputSource xmlSource = new InputSource(xmlReader);
        Document doc = builder.build(xmlSource);
        Element root = doc.getRootElement();
        if (root.getChild("apiresult").getChild("resultcode").getValue().equals("0")) {
            String spOrderId = root.getChild("buycard").getChild("saleorderid").getValue();
            resp.setSupplierBizId(spOrderId);
        } else {
            resp.setError4Admin("\u8d2d\u5361\u8fd4\u56de\u72b6\u6001\u7801\u4e3a\uff1a" + root.getChild("apiresult").getChild("resultcode").getValue());
            resp.setError4Developer("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25");
            resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private void finallyBlock(SupplierResponse resp) {
        SupplierOrderDto so4u = new SupplierOrderDto(Long.valueOf(resp.getSupplierOrderId()));
        so4u.setStatus("send");
        so4u.setSendTime(new Date());
        this.supplierOrdersService.update(so4u);
        if (this.isHttpLogEnable()) {
            HttpRequestLogDto log = new HttpRequestLogDto(true);
            log.setType("ToSupplier");
            log.setTag(this.getSupplierName());
            log.setAppId(Long.valueOf(resp.getAppId()));
            log.setOrderId(Long.valueOf(resp.getOrderId()));
            log.setResp(resp.getBody());
            log.setConsumerId(Long.valueOf(resp.getConsumerId()));
            log.setUrl(resp.getUrl());
            log.setResp(resp.getBody());
            StatHttpRequestLog.log(log);
        }
    }

    public static class GoukaQBResponse
    extends BaseSupplierExchangeResponse {
    }

    public static class GoukaQBRequest
    implements SupplierData.SupplierExchangeRequest {
        private String orderNum;
        private String qq;
        private Integer quantity;

        public GoukaQBRequest(String orderNum, String qq, Integer quantity) {
            this.orderNum = orderNum;
            this.qq = qq;
            this.quantity = quantity;
        }

        @Override
        public String getOrderNum() {
            return this.orderNum;
        }

        public String getQq() {
            return this.qq;
        }

        public void setQq(String qq) {
            this.qq = qq;
        }

        public Integer getQuantity() {
            return this.quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }
    }
}

