/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier.impl;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.dto.unique_check.UniqueSupplierCheckDto;
import cn.com.duiba.order.center.biz.constant.Environment;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierExchangeResponse;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierOrderStatus;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierFailException;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.BaseSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.SupplierRequest;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SupplierExchangeFlowWorker;
import cn.com.duiba.order.center.biz.service.unique_check.UniqueSupplierCheckService;
import com.alibaba.fastjson.JSONObject;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;

public class GyjxPhonebillSupplier2
extends BaseSupplier2 {
    private static Logger logger = LoggerFactory.getLogger(GyjxPhonebillSupplier2.class);
    private String apiUrl;
    private String agentid;
    private String merchantKey;
    private String orderQueryUrl;
    @Autowired
    private UniqueSupplierCheckService uniqueSupplierCheckService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private SupplierExchangeFlowWorker supplierExchangeFlowWorker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public SupplierData.SupplierExchangeResponse submit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId) throws SupplierFailException, Exception {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("phonebill-gyjx")) {
            throw new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u9ad8\u9633\u6377\u8fc5\u8bdd\u8d39\u5145\u503c\u8ba2\u5355");
        }
        BaseSupplierExchangeResponse resp = new BaseSupplierExchangeResponse();
        String prodId = sp.getProductId();
        String orderid = request.getOrderNum();
        String mobilenum = order.getBizParams().split(":")[0];
        String key = "prodid=" + prodId + "&agentid=" + this.agentid + "&backurl=&returntype=2&orderid=" + orderid + "&mobilenum=" + mobilenum + "&source=sales&mark=&merchantKey=" + this.merchantKey;
        System.out.println("key=" + key);
        String verifystring = GyjxPhonebillSupplier2.md5(key);
        System.out.println("md5=" + verifystring);
        String url = this.apiUrl;
        if (!this.apiUrl.endsWith("?")) {
            url = url + "?";
        }
        String tempUrl = url = url + "prodid=" + prodId + "&agentid=" + this.agentid + "&backurl=&returntype=2&orderid=" + orderid + "&mobilenum=" + mobilenum + "&source=sales&mark=" + "&verifystring=" + verifystring;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet get = new HttpGet(url);
            get.setConfig(this.getTimeoutConfig());
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            so.setSupplierInfo(body);
            resp.setSupplierBody(body);
            StringReader xmlReader = new StringReader(body);
            InputSource xmlSource = new InputSource(xmlReader);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(xmlSource);
            Element root = doc.getRootElement();
            HashMap<String, String> p = new HashMap<String, String>();
            List items = root.getChild("items").getChildren();
            for (Element item : items) {
                if (item.getAttributeValue("name").equals("prodid")) {
                    p.put("prodid", item.getAttributeValue("value"));
                    continue;
                }
                if (item.getAttributeValue("name").equals("orderid")) {
                    p.put("orderid", item.getAttributeValue("value"));
                    continue;
                }
                if (item.getAttributeValue("name").equals("tranid")) {
                    p.put("tranid", item.getAttributeValue("value"));
                    continue;
                }
                if (item.getAttributeValue("name").equals("resultno")) {
                    p.put("resultno", item.getAttributeValue("value"));
                    continue;
                }
                if (!item.getAttributeValue("name").equals("verifystring")) continue;
                p.put("verifystring", item.getAttributeValue("value"));
            }
            if ("0000".equals(p.get("resultno"))) {
                resp.setSupplierBody(body);
                resp.setSupplierBizId((String)p.get("tranid"));
            } else {
                resp.setSupplierBody(body);
                resp.setSupplierBizId((String)p.get("tranid"));
                String msg = GyjxPhonebillSupplier2.getCodeMessage((String)p.get("resultno"));
                resp.setError4Admin("\u9ad8\u9633\u8bdd\u8d39\u4e0a\u6e38\u54cd\u5e94\u5f02\u5e38\uff1a" + msg);
                resp.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5931\u8d25\u3002");
                resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                if ("0002".equals(p.get("resultno"))) {
                } else if ("1007".equals(p.get("resultno"))) {
                    resp.setError4Admin("\u9ad8\u9633\u8bdd\u8d39\u4e0a\u6e38\u4f59\u989d\u4e0d\u8db3\uff1a" + msg);
                } else if (GyjxPhonebillSupplier2.isFail((String)p.get("resultno"))) {
                    resp.setFail(true);
                }
            }
        }
        finally {
            so.setStatus("send");
            so.setSendTime(new Date());
            SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
            so4u.setStatus(so.getStatus());
            so4u.setSendTime(so.getSendTime());
            so4u.setSupplierInfo(so.getSupplierInfo());
            this.supplierOrdersService.update(so4u);
            if (this.isHttpLogEnable()) {
                HttpRequestLogDto log = new HttpRequestLogDto(true);
                log.setType("ToSupplier");
                log.setTag(this.getSupplierName());
                log.setResp(resp.getSupplierBody());
                log.setAppId(order.getAppId());
                log.setOrderId(order.getId());
                log.setConsumerId(order.getConsumerId());
                log.setDeveloperId(order.getDeveloperId());
                log.setUrl(tempUrl);
                log.setGmtCreate(new Date());
                log.setGmtModified(new Date());
                if (log.getResp() != null) {
                    log.setSuccess(Boolean.valueOf(true));
                }
                StatHttpRequestLog.log(log);
            }
        }
        return resp;
    }

    @Override
    public void asyncSubmit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId, final Supplier.SupplierCallback callback, ExecutorService es) {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("phonebill-gyjx")) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u9ad8\u9633\u6377\u8fc5\u8bdd\u8d39\u5145\u503c\u8ba2\u5355"));
                }
            });
            return;
        }
        UniqueSupplierCheckDto supplierCheck = new UniqueSupplierCheckDto(true);
        supplierCheck.setOrderNum(order.getOrderNum());
        supplierCheck.setSupplierOrderNum(so.getDuibaOrderNum());
        supplierCheck.setSupplier(sp.getSupplier());
        supplierCheck.setType(order.getType());
        try {
            this.uniqueSupplierCheckService.insert(supplierCheck);
        }
        catch (Exception e) {
            logger.error("\u5411\u4e0a\u6e38\u91cd\u590d\u8bf7\u6c42:orderNum=" + order.getOrderNum() + " ,supplierOrderNum=" + so.getDuibaOrderNum() + " ,error:" + e.getMessage());
            return;
        }
        String prodId = sp.getProductId();
        String orderid = request.getOrderNum();
        String mobilenum = order.getBizParams().split(":")[0];
        String key = "prodid=" + prodId + "&agentid=" + this.agentid + "&backurl=&returntype=2&orderid=" + orderid + "&mobilenum=" + mobilenum + "&source=sales&mark=&merchantKey=" + this.merchantKey;
        String verifystring = null;
        try {
            verifystring = GyjxPhonebillSupplier2.md5(key);
        }
        catch (Exception e) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(e);
                }
            });
            return;
        }
        String url = this.apiUrl;
        if (!this.apiUrl.endsWith("?")) {
            url = url + "?";
        }
        String urlTemp = url = url + "prodid=" + prodId + "&agentid=" + this.agentid + "&backurl=&returntype=2&orderid=" + orderid + "&mobilenum=" + mobilenum + "&source=sales&mark=" + "&verifystring=" + verifystring;
        SupplierRequest srequest = new SupplierRequest();
        srequest.setHttpUrl(urlTemp);
        srequest.setAppId(String.valueOf(order.getAppId()));
        srequest.setConsumerId(String.valueOf(order.getConsumerId()));
        srequest.setOrderId(String.valueOf(order.getId()));
        srequest.setSupplierOrderId(String.valueOf(order.getSupplierOrderId()));
        srequest.setSupplierName("phonebill-gyjx");
        try {
            this.messageService.sendMsg(this.topicConstant.getPhonebillRequest(), JSONObject.toJSONString((Object)srequest));
        }
        catch (Exception e) {
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
            logger.error("SupplierPhonebillGyjx sendMsg:", (Throwable)e);
        }
    }

    @Override
    public SupplierData.SupplierOrderStatus queryOrderStatus(String orderNum, String supplierOrderId) throws Exception {
        BaseSupplierOrderStatus status = new BaseSupplierOrderStatus();
        status.setOrderNum(orderNum);
        status.setSupplierOrderId(supplierOrderId);
        String key = "agentid=" + this.agentid + "&backurl=&returntype=2&orderid=" + orderNum + "&source=esales&merchantKey=" + this.merchantKey;
        String verifystring = GyjxPhonebillSupplier2.md5(key);
        String url = this.orderQueryUrl;
        if (!this.apiUrl.endsWith("?")) {
            url = url + "?";
        }
        url = url + "agentid=" + this.agentid + "&backurl=&returntype=2&orderid=" + orderNum + "&source=esales&verifystring=" + verifystring;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(url);
        get.setConfig(this.getTimeoutConfig());
        CloseableHttpResponse resp = client.execute((HttpUriRequest)get);
        String body = EntityUtils.toString((HttpEntity)resp.getEntity());
        status.setResponse(body);
        String returnStatus = "";
        StringReader xmlReader = new StringReader(body);
        InputSource xmlSource = new InputSource(xmlReader);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(xmlSource);
        Element root = doc.getRootElement();
        List items = root.getChild("items").getChildren();
        for (Element e : items) {
            if (!e.getAttributeValue("name").equalsIgnoreCase("resultno")) continue;
            returnStatus = e.getAttributeValue("value");
        }
        if (!returnStatus.equals("") && returnStatus != null) {
            if (returnStatus.equals("2")) {
                status.setSuccess(true);
            } else if (returnStatus.equals("4")) {
                status.setFail(true);
            } else if (returnStatus.equals("1")) {
                status.setProcessing(true);
            }
        }
        return status;
    }

    @Override
    public BigDecimal queryBalance() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public SupplierData.SupplierOrderStatus callbackParse(HttpServletRequest request) throws Exception {
        String key;
        String vs;
        BaseSupplierOrderStatus ret = new BaseSupplierOrderStatus();
        String orderNum = request.getParameter("orderid");
        String status = request.getParameter("status");
        String ordermoney = request.getParameter("ordermoney");
        String verifystring = request.getParameter("verifystring");
        if (!Environment.isDaily() && !(vs = GyjxPhonebillSupplier2.md5(key = "orderid=" + orderNum + "&status=" + status + "&ordermoney=" + ordermoney + "&merchantKey=" + this.merchantKey)).equals(verifystring)) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        OrdersDto order = null;
        SupplierOrderDto so = null;
        if (orderNum.startsWith("duiba")) {
            so = this.supplierOrdersService.findByDuibaOrderNum(orderNum);
        } else {
            order = this.orderReadManagerBo.findByOrderNum(orderNum);
            so = this.supplierOrdersService.find(order.getSupplierOrderId());
        }
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if ("phonebill-gyjx".equals(sp.getSupplier())) {
            if ("2".equals(status)) {
                ret.setSuccess(true);
            } else if ("4".equals(status)) {
                ret.setFail(true);
            }
        }
        return ret;
    }

    @Override
    public String getSupplierName() {
        return "gyjx";
    }

    public static String md5(String content) throws Exception {
        return GyjxPhonebillSupplier2.toHexValue(GyjxPhonebillSupplier2.encryptMD5(content.getBytes(Charset.forName("utf-8"))));
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String getKeyedDigest(String strSrc, String key) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(strSrc.getBytes("UTF8"));
            String result = "";
            byte[] temp = md5.digest(key.getBytes("UTF8"));
            for (int i = 0; i < temp.length; ++i) {
                result = result + Long.toHexString(0xFF & temp[i] | 0xFFFFFF00).substring(6);
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isFail(String code) {
        List<String> codes = Arrays.asList("4", "0999");
        return codes.contains(code);
    }

    public static String getCodeMessage(String code) {
        if ("0001".equals(code)) {
            return "\u652f\u4ed8\u5931\u8d25";
        }
        if ("0002".equals(code)) {
            return "\u672a\u77e5\u9519\u8bef";
        }
        if ("0999".equals(code)) {
            return "\u672a\u5f00\u901a\u76f4\u51b2\u529f\u80fd";
        }
        if ("1000".equals(code)) {
            return "\u9ad8\u9633\u7cfb\u7edf\u5f02\u5e38";
        }
        if ("1001".equals(code)) {
            return "\u4f20\u5165\u53c2\u6570\u4e0d\u5b8c\u6574";
        }
        if ("1002".equals(code)) {
            return "\u9a8c\u8bc1\u6458\u8981\u4e32\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("1006".equals(code)) {
            return "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
        }
        if ("1007".equals(code)) {
            return "\u94b1\u5305\u4f59\u989d\u4e0d\u8db3";
        }
        if ("1008".equals(code)) {
            return "\u6b64\u4ea7\u54c1\u8d85\u51fa\u5f53\u5929\u9650\u989d";
        }
        if ("1010".equals(code)) {
            return "\u4ea7\u54c1\u4e0e\u624b\u673a\u53f7\u4e0d\u5339\u914d";
        }
        if ("1011".equals(code)) {
            return "\u5b9a\u5355\u53f7\u4e0d\u5141\u8bb8\u91cd\u590d";
        }
        if ("1013".equals(code)) {
            return "\u6682\u4e0d\u53ef\u5145\u503c";
        }
        if ("1015".equals(code)) {
            return "\u65e0\u6cd5\u67e5\u5230\u5bf9\u5e94\u53f7\u6bb5";
        }
        if ("1017".equals(code)) {
            return "\u7535\u4fe1\u624b\u673a10\u79d2\u5185\u4e0d\u80fd\u91cd\u590d\u5145\u503c";
        }
        if ("1020".equals(code)) {
            return "\u53f7\u7801\u4e0d\u652f\u6301\u6d41\u91cf\u5145\u503c\u5361";
        }
        if ("1028".equals(code)) {
            return "\u4e0b\u5355\u63a5\u53e3\u8bf7\u6c42\u6b21\u6570\u8d85\u9650";
        }
        return null;
    }

    public static SupplierData.SupplierExchangeRequest buildRequestData(SupplierProductDto sp, String orderNum) {
        PhonebillExchangeRequest req = new PhonebillExchangeRequest();
        req.setOrderNum(orderNum);
        req.setSupplierProduct(sp);
        return req;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getAgentid() {
        return this.agentid;
    }

    public String getMerchantKey() {
        return this.merchantKey;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public void setAgentid(String agentid) {
        this.agentid = agentid;
    }

    public void setMerchantKey(String merchantKey) {
        this.merchantKey = merchantKey;
    }

    public String getOrderQueryUrl() {
        return this.orderQueryUrl;
    }

    public void setOrderQueryUrl(String orderQueryUrl) {
        this.orderQueryUrl = orderQueryUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplierCallback(SupplierResponse response) {
        Long orderId = Long.valueOf(response.getOrderId());
        Long consumerId = Long.valueOf(response.getConsumerId());
        if (response.getCallbackType().equals("completed")) {
            Exception exception = null;
            try {
                this.successBlock(response);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                this.finallyBlock(response);
            }
            if (exception == null) {
                this.supplierExchangeFlowWorker.onFinish(orderId, consumerId, response);
            } else {
                this.supplierExchangeFlowWorker.onException(orderId, consumerId, exception);
            }
        } else if (response.getCallbackType().equals("failed")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception(response.getErrorMessage()));
        } else if (response.getCallbackType().equals("cancelled")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u8bf7\u6c42\u88ab\u53d6\u6d88"));
        }
    }

    private void successBlock(SupplierResponse resp) throws Exception {
        String body = resp.getBody();
        StringReader xmlReader = new StringReader(body);
        InputSource xmlSource = new InputSource(xmlReader);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(xmlSource);
        Element root = doc.getRootElement();
        HashMap<String, String> p = new HashMap<String, String>();
        List items = root.getChild("items").getChildren();
        for (Element item : items) {
            if (item.getAttributeValue("name").equals("prodid")) {
                p.put("prodid", item.getAttributeValue("value"));
                continue;
            }
            if (item.getAttributeValue("name").equals("orderid")) {
                p.put("orderid", item.getAttributeValue("value"));
                continue;
            }
            if (item.getAttributeValue("name").equals("tranid")) {
                p.put("tranid", item.getAttributeValue("value"));
                continue;
            }
            if (item.getAttributeValue("name").equals("resultno")) {
                p.put("resultno", item.getAttributeValue("value"));
                continue;
            }
            if (!item.getAttributeValue("name").equals("verifystring")) continue;
            p.put("verifystring", item.getAttributeValue("value"));
        }
        if ("0000".equals(p.get("resultno"))) {
            resp.setSupplierBizId((String)p.get("tranid"));
        } else {
            resp.setSupplierBizId((String)p.get("tranid"));
            String msg = GyjxPhonebillSupplier2.getCodeMessage((String)p.get("resultno"));
            resp.setError4Admin("\u9ad8\u9633\u8bdd\u8d39\u4e0a\u6e38\u54cd\u5e94\u5f02\u5e38\uff1a" + msg);
            resp.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5931\u8d25\u3002");
            resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
            if (!"0002".equals(p.get("resultno"))) {
                if ("1007".equals(p.get("resultno"))) {
                    resp.setError4Admin("\u9ad8\u9633\u8bdd\u8d39\u4e0a\u6e38\u4f59\u989d\u4e0d\u8db3\uff1a" + msg);
                } else if (GyjxPhonebillSupplier2.isFail((String)p.get("resultno"))) {
                    resp.setFail(true);
                }
            }
        }
    }

    private void finallyBlock(SupplierResponse resp) {
        SupplierOrderDto so4u = new SupplierOrderDto(Long.valueOf(resp.getSupplierOrderId()));
        so4u.setStatus("send");
        so4u.setSendTime(new Date());
        so4u.setSupplierInfo(resp.getBody());
        this.supplierOrdersService.update(so4u);
        if (this.isHttpLogEnable()) {
            HttpRequestLogDto log = new HttpRequestLogDto(true);
            log.setType("ToSupplier");
            log.setTag(this.getSupplierName());
            log.setAppId(Long.valueOf(resp.getAppId()));
            log.setOrderId(Long.valueOf(resp.getOrderId()));
            log.setResp(resp.getBody());
            log.setConsumerId(Long.valueOf(resp.getConsumerId()));
            log.setUrl(resp.getUrl());
            log.setResp(resp.getBody());
            StatHttpRequestLog.log(log);
        }
    }

    public static class PhonebillExchangeRequest
    implements SupplierData.SupplierExchangeRequest {
        private SupplierProductDto sp;
        private String orderNum;

        @Override
        public String getOrderNum() {
            return this.orderNum;
        }

        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }

        public SupplierProductDto getSupplierProduct() {
            return this.sp;
        }

        public void setSupplierProduct(SupplierProductDto sp) {
            this.sp = sp;
        }
    }
}

