/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier.impl;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.dto.unique_check.UniqueSupplierCheckDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierExchangeResponse;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierOrderStatus;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierFailException;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.BaseSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.SupplierRequest;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SupplierExchangeFlowWorker;
import cn.com.duiba.order.center.biz.service.unique_check.UniqueSupplierCheckService;
import cn.com.duiba.order.center.biz.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;

public class OufeiPhonebillSupplier2
extends BaseSupplier2 {
    private static Logger logger = LoggerFactory.getLogger(OufeiPhonebillSupplier2.class);
    public static final String RETCODE_SUCCESS = "1";
    public static final String RETCODE_CANCEL = "9";
    public static final String RETCODE_ERROR_9999 = "9999";
    public static final String RETCODE_ERROR_105 = "105";
    public static final String RETCODE_ERROR_334 = "334";
    public static final String RETCODE_ERROR_1043 = "1043";
    public static final String QUERY_ORDER_STATUS_SUCCESS = "1";
    public static final String QUERY_ORDER_STATUS_RECHARGING = "0";
    public static final String QUERY_ORDER_STATUS_FAIL = "9";
    public static final String QUERY_ORDER_STATUS_NOTFOUND = "-1";
    public static final String QUERYBALANCE_RETCODE_SUCCESS = "1";
    public static final String GAME_STATE_SUCCESS = "1";
    public static final String GAME_STATE_CANCEL = "9";
    public static final String GAME_STATE_RECHARGING = "0";
    private String url;
    private String agentID;
    private String agentPW;
    private String md5Key;
    private String notifyUrl;
    private String orderQuery;
    private String balanceQuery;
    private String version;
    @Autowired
    private UniqueSupplierCheckService uniqueSupplierCheckService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private SupplierExchangeFlowWorker supplierExchangeFlowWorker;

    public static SupplierData.SupplierExchangeRequest buildRequestData(SupplierProductDto sp, String orderNum) {
        PhonebillExchangeRequest req = new PhonebillExchangeRequest();
        req.setOrderNum(orderNum);
        req.setSupplierProduct(sp);
        return req;
    }

    public static String md5(String content) throws Exception {
        return OufeiPhonebillSupplier2.toHexValue(OufeiPhonebillSupplier2.encryptMD5(content.getBytes(Charset.forName("utf-8"))));
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    @Override
    @Deprecated
    public SupplierData.SupplierExchangeResponse submit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId) throws SupplierFailException, Exception {
        String postUrl;
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("phonebill-oufei")) {
            throw new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u6b27\u98de\u8bdd\u8d39\u5145\u503c\u8ba2\u5355");
        }
        OufeiPhonebillResponse resp = new OufeiPhonebillResponse();
        String url = this.url;
        if (!url.endsWith("?")) {
            url = url + "?";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String userid = this.agentID;
        String userpws = OufeiPhonebillSupplier2.md5(this.agentPW);
        String cardid = sp.getProductId();
        String cardnum = sp.getFacePrice() / 100 + "";
        String sporder_id = order.getOrderNum();
        String sporder_time = format.format(order.getGmtCreate());
        String game_userid = order.getBizParams().split(":")[0];
        String KeyStr = this.md5Key;
        String md5_str = OufeiPhonebillSupplier2.md5(userid + userpws + cardid + cardnum + sporder_id + sporder_time + game_userid + KeyStr).toUpperCase();
        String completeUrl = postUrl = url + "userid=" + userid + "&userpws=" + userpws + "&cardid=" + cardid + "&cardnum=" + cardnum + "&sporder_id=" + sporder_id + "&sporder_time=" + sporder_time + "&game_userid=" + game_userid + "&md5_str=" + md5_str + "&ret_url=" + this.notifyUrl + "&version=" + this.version;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(postUrl);
        post.setConfig(this.getTimeoutConfig());
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            resp.setSupplierBody(body);
            so.setSupplierInfo(body);
            StringReader xmlReader = new StringReader(body);
            InputSource xmlSource = new InputSource(xmlReader);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(xmlSource);
            Element root = doc.getRootElement();
            String retcode = root.getChild("retcode").getValue();
            if ((root.getChild("err_msg").getValue() == null || root.getChild("err_msg").getValue().trim().length() == 0) && "1".equals(retcode)) {
                String spOrderId = root.getChild("orderid").getValue();
                String gameState = root.getChild("game_state").getValue();
                if ("1".equals(gameState)) {
                    resp.setSuccess(true);
                    resp.setSupplierBizId(spOrderId);
                    resp.setSupplierBody(body);
                } else if ("0".equals(gameState)) {
                    resp.setSupplierBizId(spOrderId);
                    resp.setSupplierBody(body);
                } else if ("9".equals(gameState)) {
                    resp.setSupplierBizId(spOrderId);
                    resp.setSupplierBody(body);
                    resp.setError4Admin("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25,\u8ba2\u5355\u64a4\u9500\uff0c\u53ef\u9000\u6b3e\u3002");
                    resp.setError4Developer("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25");
                    resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                } else {
                    resp.setError4Admin("\u6b27\u98de\u8fd4\u56de\u72b6\u6001\u7801gameState\u4e3a\u672a\u77e5\u5904\u7406\u7c7b\u578b\uff1a" + gameState);
                    resp.setError4Developer("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25");
                    resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
            } else if (RETCODE_ERROR_105.equals(retcode) || RETCODE_ERROR_334.equals(retcode) || RETCODE_ERROR_1043.equals(retcode) || RETCODE_ERROR_9999.equals(retcode)) {
                so.setStatus("send");
                so.setErrorMessage("\u4e0a\u6e38\u7279\u6b8a\u5f02\u5e38\uff0c\u9700\u8c03\u67e5\u8be2\u63a5\u53e3\u786e\u8ba4\u8ba2\u5355\u72b6\u6001");
                so.setSupplierInfo(body);
            } else {
                resp.setSupplierBody(body);
                resp.setError4Admin("\u4e0a\u6e38\u7279\u6b8a\u5f02\u5e38\uff0c\u8fd4\u56de\u53c2\u6570\u5f02\u5e38");
                resp.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5f02\u5e38");
                resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            OufeiPhonebillResponse oufeiPhonebillResponse = resp;
            return oufeiPhonebillResponse;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ("create".equals(so.getStatus())) {
                so.setStatus("send");
            }
            so.setSendTime(new Date());
            SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
            so4u.setSendTime(so.getSendTime());
            so4u.setStatus(so.getStatus());
            so4u.setSupplierInfo(so.getSupplierInfo());
            so4u.setErrorMessage(so.getErrorMessage());
            this.supplierOrdersService.update(so4u);
            if (this.isHttpLogEnable()) {
                HttpRequestLogDto log = new HttpRequestLogDto(true);
                log.setType("ToSupplier");
                log.setTag(this.getSupplierName());
                log.setResp(resp.getSupplierBody());
                log.setAppId(order.getAppId());
                log.setOrderId(order.getId());
                log.setConsumerId(order.getConsumerId());
                log.setDeveloperId(order.getDeveloperId());
                log.setUrl(completeUrl);
                log.setGmtCreate(new Date());
                log.setGmtModified(new Date());
                if (log.getResp() != null) {
                    log.setSuccess(Boolean.valueOf(true));
                }
                StatHttpRequestLog.log(log);
            }
        }
    }

    @Override
    public void asyncSubmit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId, final Supplier.SupplierCallback callback, ExecutorService es) {
        String postUrl;
        String userpws;
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("phonebill-oufei")) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u6b27\u98de\u8bdd\u8d39\u5145\u503c\u8ba2\u5355"));
                }
            });
            return;
        }
        UniqueSupplierCheckDto supplierCheck = new UniqueSupplierCheckDto(true);
        supplierCheck.setOrderNum(order.getOrderNum());
        supplierCheck.setSupplierOrderNum(so.getDuibaOrderNum());
        supplierCheck.setSupplier(sp.getSupplier());
        supplierCheck.setType(order.getType());
        try {
            this.uniqueSupplierCheckService.insert(supplierCheck);
        }
        catch (Exception e) {
            logger.error("\u5411\u4e0a\u6e38\u91cd\u590d\u8bf7\u6c42:orderNum=" + order.getOrderNum() + " ,supplierOrderNum=" + so.getDuibaOrderNum() + " ,error:" + e.getMessage());
            return;
        }
        String url = this.url;
        if (!url.endsWith("?")) {
            url = url + "?";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String userid = this.agentID;
        try {
            userpws = OufeiPhonebillSupplier2.md5(this.agentPW);
        }
        catch (Exception e2) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(e2);
                }
            });
            return;
        }
        String cardid = sp.getProductId();
        String cardnum = sp.getFacePrice() / 100 + "";
        String sporder_id = order.getOrderNum();
        String sporder_time = format.format(order.getGmtCreate());
        String game_userid = order.getBizParams().split(":")[0];
        String KeyStr = this.md5Key;
        String md5_str = null;
        try {
            md5_str = OufeiPhonebillSupplier2.md5(userid + userpws + cardid + cardnum + sporder_id + sporder_time + game_userid + KeyStr).toUpperCase();
        }
        catch (Exception e1) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(e1);
                }
            });
            return;
        }
        String completeUrl = postUrl = url + "userid=" + userid + "&userpws=" + userpws + "&cardid=" + cardid + "&cardnum=" + cardnum + "&sporder_id=" + sporder_id + "&sporder_time=" + sporder_time + "&game_userid=" + game_userid + "&md5_str=" + md5_str + "&ret_url=" + this.notifyUrl + "&version=" + this.version;
        SupplierRequest srequest = new SupplierRequest();
        srequest.setHttpUrl(completeUrl);
        srequest.setAppId(String.valueOf(order.getAppId()));
        srequest.setConsumerId(String.valueOf(order.getConsumerId()));
        srequest.setOrderId(String.valueOf(order.getId()));
        srequest.setSupplierOrderId(String.valueOf(order.getSupplierOrderId()));
        srequest.setSupplierName("phonebill-oufei");
        try {
            this.messageService.sendMsg(this.topicConstant.getPhonebillRequest(), JSONObject.toJSONString((Object)srequest));
        }
        catch (Exception e) {
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
            logger.error("SupplierPhonebillOufei sendMsg:", (Throwable)e);
        }
    }

    @Override
    public SupplierData.SupplierOrderStatus queryOrderStatus(String orderNum, String supplierOrderId) throws Exception {
        BaseSupplierOrderStatus status = new BaseSupplierOrderStatus();
        status.setOrderNum(orderNum);
        status.setSupplierOrderId(supplierOrderId);
        String orderQuery = this.orderQuery;
        if (!orderQuery.endsWith("?")) {
            orderQuery = orderQuery + "?";
        }
        String queryUrl = orderQuery + "userid=" + this.agentID + "&spbillid=" + orderNum;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(queryUrl);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        status.setResponse(body);
        if ("1".equals(body)) {
            status.setSuccess(true);
        } else if ("9".equals(body)) {
            status.setFail(true);
        } else if ("0".equals(body)) {
            status.setProcessing(true);
        } else if (QUERY_ORDER_STATUS_NOTFOUND.equals(body)) {
            status.setNotExist(true);
        } else {
            throw new Exception(body);
        }
        return status;
    }

    @Override
    public SupplierData.SupplierOrderStatus callbackParse(HttpServletRequest request) throws Exception {
        SupplierProductDto sp;
        String orderId = request.getParameter("sporder_id");
        String retcode = request.getParameter("ret_code");
        SupplierOrderDto so = this.supplierOrdersService.findByDuibaOrderNum(orderId);
        so.setSupplierInfo(RequestTool.getRequestUrl(request));
        SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
        so4u.setSupplierInfo(so.getSupplierInfo());
        this.supplierOrdersService.update(so4u);
        OrdersDto order = this.orderReadManagerBo.find(so.getOrderId());
        BaseSupplierOrderStatus ret = new BaseSupplierOrderStatus();
        if (order != null && "phonebill-oufei".equals((sp = this.supplierProductsService.find(so.getSupplierProductId())).getSupplier()) && "send".equals(so.getStatus())) {
            if ("1".equals(retcode)) {
                ret.setSuccess(true);
            } else if ("9".equals(retcode)) {
                ret.setFail(true);
            }
        }
        return ret;
    }

    @Override
    public BigDecimal queryBalance() throws Exception {
        HttpGet get;
        String balanceQuery = this.balanceQuery;
        if (!balanceQuery.endsWith("?")) {
            balanceQuery = balanceQuery + "?";
        }
        String queryUrl = balanceQuery + "userid=" + this.agentID + "&userpws=" + OufeiPhonebillSupplier2.md5(this.agentPW) + "&version=6.0";
        SAXBuilder builder = new SAXBuilder();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse response = client.execute((HttpUriRequest)(get = new HttpGet(queryUrl)));
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        StringReader xmlReader = new StringReader(body);
        InputSource xmlSource = new InputSource(xmlReader);
        Document doc = builder.build(xmlSource);
        Element root = doc.getRootElement();
        if (root.getChild("retcode").getValue().equals("1")) {
            String balance = root.getChild("ret_leftcredit").getValue();
            BigDecimal bd = new BigDecimal(balance);
            return bd;
        }
        return null;
    }

    @Override
    public String getSupplierName() {
        return "oufei";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAgentID() {
        return this.agentID;
    }

    public void setAgentID(String agentID) {
        this.agentID = agentID;
    }

    public String getAgentPW() {
        return this.agentPW;
    }

    public void setAgentPW(String agentPW) {
        this.agentPW = agentPW;
    }

    public String getMd5Key() {
        return this.md5Key;
    }

    public void setMd5Key(String md5Key) {
        this.md5Key = md5Key;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getOrderQuery() {
        return this.orderQuery;
    }

    public void setOrderQuery(String orderQuery) {
        this.orderQuery = orderQuery;
    }

    public String getBalanceQuery() {
        return this.balanceQuery;
    }

    public void setBalanceQuery(String balanceQuery) {
        this.balanceQuery = balanceQuery;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplierCallback(SupplierResponse response) {
        Long orderId = Long.valueOf(response.getOrderId());
        Long consumerId = Long.valueOf(response.getConsumerId());
        if (response.getCallbackType().equals("completed")) {
            Exception exception = null;
            try {
                this.successBlock(response);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                this.finallyBlock(response);
            }
            if (exception == null) {
                this.supplierExchangeFlowWorker.onFinish(orderId, consumerId, response);
            } else {
                this.supplierExchangeFlowWorker.onException(orderId, consumerId, exception);
            }
        } else if (response.getCallbackType().equals("failed")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception(response.getErrorMessage()));
        } else if (response.getCallbackType().equals("cancelled")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u8bf7\u6c42\u88ab\u53d6\u6d88"));
        }
    }

    private void successBlock(SupplierResponse resp) throws Exception {
        String body = resp.getBody();
        StringReader xmlReader = new StringReader(body);
        InputSource xmlSource = new InputSource(xmlReader);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(xmlSource);
        Element root = doc.getRootElement();
        String retcode = root.getChild("retcode").getValue();
        if ((root.getChild("err_msg").getValue() == null || root.getChild("err_msg").getValue().trim().length() == 0) && "1".equals(retcode)) {
            String spOrderId = root.getChild("orderid").getValue();
            String gameState = root.getChild("game_state").getValue();
            if ("1".equals(gameState)) {
                resp.setSuccess(true);
                resp.setSupplierBizId(spOrderId);
            } else if ("0".equals(gameState)) {
                resp.setSupplierBizId(spOrderId);
            } else if ("9".equals(gameState)) {
                resp.setSupplierBizId(spOrderId);
                resp.setError4Admin("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25,\u8ba2\u5355\u64a4\u9500\uff0c\u53ef\u9000\u6b3e\u3002");
                resp.setError4Developer("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25");
                resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            } else {
                resp.setError4Admin("\u6b27\u98de\u8fd4\u56de\u72b6\u6001\u7801gameState\u4e3a\u672a\u77e5\u5904\u7406\u7c7b\u578b\uff1a" + gameState);
                resp.setError4Developer("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25");
                resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        } else if (RETCODE_ERROR_105.equals(retcode) || RETCODE_ERROR_334.equals(retcode) || RETCODE_ERROR_1043.equals(retcode) || RETCODE_ERROR_9999.equals(retcode)) {
            resp.setError4Admin("\u4e0a\u6e38\u7279\u6b8a\u5f02\u5e38\uff0c\u9700\u8c03\u67e5\u8be2\u63a5\u53e3\u786e\u8ba4\u8ba2\u5355\u72b6\u6001");
        } else {
            resp.setError4Admin("\u4e0a\u6e38\u7279\u6b8a\u5f02\u5e38\uff0c\u8fd4\u56de\u53c2\u6570\u5f02\u5e38");
            resp.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5f02\u5e38");
            resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private void finallyBlock(SupplierResponse resp) {
        SupplierOrderDto so = this.supplierOrdersService.find(Long.valueOf(resp.getSupplierOrderId()));
        if ("create".equals(so.getStatus())) {
            so.setStatus("send");
        }
        so.setSendTime(new Date());
        SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
        so4u.setSendTime(so.getSendTime());
        so4u.setStatus(so.getStatus());
        so4u.setSupplierInfo(so.getSupplierInfo());
        so4u.setErrorMessage(so.getErrorMessage());
        this.supplierOrdersService.update(so4u);
        if (this.isHttpLogEnable()) {
            HttpRequestLogDto log = new HttpRequestLogDto(true);
            log.setType("ToSupplier");
            log.setTag(this.getSupplierName());
            log.setAppId(Long.valueOf(resp.getAppId()));
            log.setOrderId(Long.valueOf(resp.getOrderId()));
            log.setResp(resp.getBody());
            log.setConsumerId(Long.valueOf(resp.getConsumerId()));
            log.setUrl(resp.getUrl());
            log.setResp(resp.getBody());
            StatHttpRequestLog.log(log);
        }
    }

    public static class PhonebillExchangeRequest
    implements SupplierData.SupplierExchangeRequest {
        private SupplierProductDto sp;
        private String orderNum;

        @Override
        public String getOrderNum() {
            return this.orderNum;
        }

        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }

        public SupplierProductDto getSupplierProduct() {
            return this.sp;
        }

        public void setSupplierProduct(SupplierProductDto sp) {
            this.sp = sp;
        }
    }

    public static class OufeiPhonebillResponse
    extends BaseSupplierExchangeResponse {
    }
}

